/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.sttp.akkahttp;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.event.LoggingAdapter;
import akka.http.javadsl.model.ContentType;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.HttpExt;
import akka.http.scaladsl.HttpsConnectionContext;
import akka.http.scaladsl.coding.Deflate$;
import akka.http.scaladsl.coding.Gzip$;
import akka.http.scaladsl.coding.NoCoding$;
import akka.http.scaladsl.model.BodyPartEntity;
import akka.http.scaladsl.model.ContentType$;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.ErrorInfo;
import akka.http.scaladsl.model.HttpCharsets$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpHeader$;
import akka.http.scaladsl.model.HttpMessage;
import akka.http.scaladsl.model.HttpMessage$;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethod$;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.Multipart;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.Content$minusLength$;
import akka.http.scaladsl.model.headers.Content$minusType$;
import akka.http.scaladsl.model.headers.HttpEncoding;
import akka.http.scaladsl.model.headers.HttpEncodings$;
import akka.http.scaladsl.settings.ConnectionPoolSettings;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializer$;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.scaladsl.FileIO$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.StreamConverters$;
import akka.util.ByteString;
import akka.util.ByteString$;
import com.softwaremill.sttp.BasicRequestBody;
import com.softwaremill.sttp.BasicResponseAs;
import com.softwaremill.sttp.ByteArrayBody;
import com.softwaremill.sttp.ByteBufferBody;
import com.softwaremill.sttp.FutureMonad;
import com.softwaremill.sttp.IgnoreResponse$;
import com.softwaremill.sttp.InputStreamBody;
import com.softwaremill.sttp.MappedResponseAs;
import com.softwaremill.sttp.Method;
import com.softwaremill.sttp.Method$;
import com.softwaremill.sttp.MonadError;
import com.softwaremill.sttp.Multipart;
import com.softwaremill.sttp.MultipartBody;
import com.softwaremill.sttp.NoBody$;
import com.softwaremill.sttp.PathBody;
import com.softwaremill.sttp.RequestBody;
import com.softwaremill.sttp.RequestT;
import com.softwaremill.sttp.Response;
import com.softwaremill.sttp.ResponseAs;
import com.softwaremill.sttp.ResponseAsByteArray$;
import com.softwaremill.sttp.ResponseAsFile;
import com.softwaremill.sttp.ResponseAsStream;
import com.softwaremill.sttp.ResponseAsString;
import com.softwaremill.sttp.StreamBody;
import com.softwaremill.sttp.StringBody;
import com.softwaremill.sttp.SttpHandler;
import com.softwaremill.sttp.Uri;
import com.softwaremill.sttp.akkahttp.AkkaHttpHandler$;
import com.softwaremill.sttp.package$;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\tmf\u0001B\u0001\u0003\u0001-\u0011q\"Q6lC\"#H\u000f\u001d%b]\u0012dWM\u001d\u0006\u0003\u0007\u0011\t\u0001\"Y6lC\"$H\u000f\u001d\u0006\u0003\u000b\u0019\tAa\u001d;ua*\u0011q\u0001C\u0001\rg>4Go^1sK6LG\u000e\u001c\u0006\u0002\u0013\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\u0011\u0019BC\u0006\u000f\u000e\u0003\u0011I!!\u0006\u0003\u0003\u0017M#H\u000f\u001d%b]\u0012dWM\u001d\t\u0003/ii\u0011\u0001\u0007\u0006\u000339\t!bY8oGV\u0014(/\u001a8u\u0013\tY\u0002D\u0001\u0004GkR,(/\u001a\t\u0005;\u00112C&D\u0001\u001f\u0015\ty\u0002%\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\t\t#%\u0001\u0004tiJ,\u0017-\u001c\u0006\u0002G\u0005!\u0011m[6b\u0013\t)cD\u0001\u0004T_V\u00148-\u001a\t\u0003O)j\u0011\u0001\u000b\u0006\u0003S\t\nA!\u001e;jY&\u00111\u0006\u000b\u0002\u000b\u0005f$Xm\u0015;sS:<\u0007CA\u0007.\u0013\tqcBA\u0002B]fD\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!M\u0001\fC\u000e$xN]*zgR,W\u000e\u0005\u00023k5\t1G\u0003\u00025E\u0005)\u0011m\u0019;pe&\u0011ag\r\u0002\f\u0003\u000e$xN]*zgR,W\u000e\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0003\t)7\r\u0005\u0002\u0018u%\u00111\b\u0007\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRD\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IAP\u0001\u001ci\u0016\u0014X.\u001b8bi\u0016\f5\r^8s'f\u001cH/Z7P]\u000ecwn]3\u0011\u00055y\u0014B\u0001!\u000f\u0005\u001d\u0011un\u001c7fC:DQA\u0011\u0001\u0005\n\r\u000ba\u0001P5oSRtD\u0003\u0002#G\u000f\"\u0003\"!\u0012\u0001\u000e\u0003\tAQ\u0001M!A\u0002EBQ\u0001O!A\u0002eBQ!P!A\u0002y*AA\u0013\u0001\u00059\t\t1\u000bC\u0004M\u0001\t\u0007I1B'\u0002\u0005\u0005\u001cX#A\u0019\t\r=\u0003\u0001\u0015!\u00032\u0003\r\t7\u000f\t\u0005\b#\u0002\u0011\r\u0011b\u0003S\u00031i\u0017\r^3sS\u0006d\u0017N_3s+\u0005\u0019\u0006C\u0001+V\u001b\u0005\u0001\u0013B\u0001,!\u0005E\t5\r^8s\u001b\u0006$XM]5bY&TXM\u001d\u0005\u00071\u0002\u0001\u000b\u0011B*\u0002\u001b5\fG/\u001a:jC2L'0\u001a:!\u0011\u0015Q\u0006\u0001\"\u0011\\\u0003\u0011\u0019XM\u001c3\u0016\u0005q\u001bGCA/j!\r9\"D\u0018\t\u0004'}\u000b\u0017B\u00011\u0005\u0005!\u0011Vm\u001d9p]N,\u0007C\u00012d\u0019\u0001!Q\u0001Z-C\u0002\u0015\u0014\u0011\u0001V\t\u0003M2\u0002\"!D4\n\u0005!t!a\u0002(pi\"Lgn\u001a\u0005\u0006Uf\u0003\ra[\u0001\u0002eB!A\u000e_1|\u001d\tigO\u0004\u0002ok:\u0011q\u000e\u001e\b\u0003aNl\u0011!\u001d\u0006\u0003e*\ta\u0001\u0010:p_Rt\u0014\"A\u0005\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t9H!A\u0004qC\u000e\\\u0017mZ3\n\u0005eT(a\u0002*fcV,7\u000f\u001e\u0006\u0003o\u0012\u0001\"\u0001`%\u000e\u0003\u0001AQA \u0001\u0005B}\fQB]3ta>t7/Z'p]\u0006$WCAA\u0001!\u0011\u0019\u00121\u0001\f\n\u0007\u0005\u0015AA\u0001\u0006N_:\fG-\u0012:s_JDq!!\u0003\u0001\t\u0013\tY!\u0001\u0007nKRDw\u000e\u001a+p\u0003.\\\u0017\r\u0006\u0003\u0002\u000e\u0005}\u0001\u0003BA\b\u00037i!!!\u0005\u000b\t\u0005M\u0011QC\u0001\u0006[>$W\r\u001c\u0006\u0004?\u0005]!bAA\rE\u0005!\u0001\u000e\u001e;q\u0013\u0011\ti\"!\u0005\u0003\u0015!#H\u000f]'fi\"|G\r\u0003\u0005\u0002\"\u0005\u001d\u0001\u0019AA\u0012\u0003\u0005i\u0007cA\n\u0002&%\u0019\u0011q\u0005\u0003\u0003\r5+G\u000f[8e\u0011\u001d\tY\u0003\u0001C\u0005\u0003[\tABY8es\u001a\u0013x.\\!lW\u0006,B!a\f\u00026Q1\u0011\u0011GA\u001c\u0003\u0003\u0002Ba\u0006\u000e\u00024A\u0019!-!\u000e\u0005\r\u0011\fIC1\u0001f\u0011!\tI$!\u000bA\u0002\u0005m\u0012A\u0001:s!\u0019\u0019\u0012QHA\u001aw&\u0019\u0011q\b\u0003\u0003\u0015I+7\u000f]8og\u0016\f5\u000f\u0003\u0005\u0002D\u0005%\u0002\u0019AA#\u0003\tA'\u000f\u0005\u0003\u0002\u0010\u0005\u001d\u0013\u0002BA%\u0003#\u0011A\u0002\u0013;uaJ+7\u000f]8og\u0016Dq!!\u0014\u0001\t\u0013\ty%A\biK\u0006$WM]:Ge>l\u0017i[6b)\u0011\t\t&a\u001e\u0011\r\u0005M\u0013QLA1\u001b\t\t)F\u0003\u0003\u0002X\u0005e\u0013!C5n[V$\u0018M\u00197f\u0015\r\tYFD\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA0\u0003+\u00121aU3r!\u001di\u00111MA4\u0003OJ1!!\u001a\u000f\u0005\u0019!V\u000f\u001d7feA!\u0011\u0011NA9\u001d\u0011\tY'!\u001c\u0011\u0005At\u0011bAA8\u001d\u00051\u0001K]3eK\u001aLA!a\u001d\u0002v\t11\u000b\u001e:j]\u001eT1!a\u001c\u000f\u0011!\t\u0019%a\u0013A\u0002\u0005\u0015\u0003bBA>\u0001\u0011%\u0011QP\u0001\u000ee\u0016\fX/Z:u)>\f5n[1\u0015\t\u0005}\u0014q\u0012\t\u0007\u0003\u0003\u000b))!#\u000e\u0005\u0005\r%BA\u0015\u000f\u0013\u0011\t9)a!\u0003\u0007Q\u0013\u0018\u0010\u0005\u0003\u0002\u0010\u0005-\u0015\u0002BAG\u0003#\u00111\u0002\u0013;uaJ+\u0017/^3ti\"9!.!\u001fA\u0002\u0005E\u0005\u0007BAJ\u0003/\u0003R\u0001\u001c=\u0002\u0016n\u00042AYAL\t-\tI*a$\u0002\u0002\u0003\u0005)\u0011A3\u0003\u0007}#\u0013\u0007C\u0004\u0002\u001e\u0002!I!a(\u0002\u001b!,\u0017\rZ3sgR{\u0017i[6b)\u0011\t\t+a+\u0011\r\u0005\u0005\u0015QQAR!\u0019\t\u0019&!\u0018\u0002&B!\u0011qBAT\u0013\u0011\tI+!\u0005\u0003\u0015!#H\u000f\u001d%fC\u0012,'\u000f\u0003\u0005\u0002.\u0006m\u0005\u0019AA)\u0003\u001dAW-\u00193feNDq!!-\u0001\t\u0013\t\u0019,A\u0006ue\u00064XM]:f)JLX\u0003BA[\u0003{#B!a.\u0002@B1\u0011\u0011QAC\u0003s\u0003b!a\u0015\u0002^\u0005m\u0006c\u00012\u0002>\u00121A-a,C\u0002\u0015D\u0001\"!1\u00020\u0002\u0007\u00111Y\u0001\u0002YB1\u00111KA/\u0003\u000b\u0004b!!!\u0002\u0006\u0006m\u0006bBAe\u0001\u0011%\u00111Z\u0001\u000eg\u0016$(i\u001c3z\u001f:\f5n[1\u0015\u0011\u0005}\u0014QZAm\u0003GDqA[Ad\u0001\u0004\ty\r\r\u0003\u0002R\u0006U\u0007#\u00027y\u0003'\\\bc\u00012\u0002V\u0012Y\u0011q[Ag\u0003\u0003\u0005\tQ!\u0001f\u0005\ryFE\r\u0005\t\u00037\f9\r1\u0001\u0002^\u0006!!m\u001c3z!\u0011\u0019\u0012q\\>\n\u0007\u0005\u0005HAA\u0006SKF,Xm\u001d;C_\u0012L\b\u0002CAs\u0003\u000f\u0004\r!!#\u0002\u0005\u0005\u0014\bbBAu\u0001\u0011%\u00111^\u0001\u001ea\u0006\u00148/Z\"p]R,g\u000e\u001e+za\u0016|%oT2uKR\u001cFO]3b[R!\u0011Q^A{!\u0019\t\t)!\"\u0002pB!\u0011qBAy\u0013\u0011\t\u00190!\u0005\u0003\u0017\r{g\u000e^3oiRK\b/\u001a\u0005\bU\u0006\u001d\b\u0019AA|a\u0011\tI0!@\u0011\u000b1D\u00181`>\u0011\u0007\t\fi\u0010B\u0006\u0002\u0000\u0006U\u0018\u0011!A\u0001\u0006\u0003)'aA0%g!9\u0011\u0011\u001e\u0001\u0005\n\t\rA\u0003BAw\u0005\u000bA\u0001Ba\u0002\u0003\u0002\u0001\u0007!\u0011B\u0001\tGRDU-\u00193feB)QBa\u0003\u0002h%\u0019!Q\u0002\b\u0003\r=\u0003H/[8o\u0011\u001d\u0011\t\u0002\u0001C\u0005\u0005'\tQ\"[:D_:$XM\u001c;UsB,Gc\u0001 \u0003\u0016!A!q\u0003B\b\u0001\u0004\t\t'\u0001\u0004iK\u0006$WM\u001d\u0005\b\u00057\u0001A\u0011\u0002B\u000f\u0003=I7oQ8oi\u0016tG\u000fT3oORDGc\u0001 \u0003 !A!q\u0003B\r\u0001\u0004\t\t\u0007C\u0004\u0003$\u0001!IA!\n\u0002%\u0011,7m\u001c3f\u0003.\\\u0017MU3ta>t7/\u001a\u000b\u0005\u0003\u000b\u00129\u0003\u0003\u0005\u0003*\t\u0005\u0002\u0019AA#\u0003!\u0011Xm\u001d9p]N,\u0007b\u0002B\u0017\u0001\u0011\u0005#qF\u0001\u0006G2|7/\u001a\u000b\u0003\u0005c\u00012!\u0004B\u001a\u0013\r\u0011)D\u0004\u0002\u0005+:LGO\u0002\u0004\u0003:\u0001)!1\b\u0002\b%&\u001c\u0007\u000e\u0016:z+\u0011\u0011iDa\u0012\u0014\u0007\t]B\u0002C\u0006\u0003B\t]\"\u0011!Q\u0001\n\t\r\u0013!\u0001;\u0011\r\u0005\u0005\u0015Q\u0011B#!\r\u0011'q\t\u0003\u0007I\n]\"\u0019A3\t\u000f\t\u00139\u0004\"\u0001\u0003LQ!!Q\nB(!\u0015a(q\u0007B#\u0011!\u0011\tE!\u0013A\u0002\t\r\u0003\u0002\u0003B*\u0005o!\tA!\u0016\u0002\u0011Q|g)\u001e;ve\u0016,\"Aa\u0016\u0011\t]Q\"Q\t\u0005\n\u00057\u0002\u0011\u0011!C\u0006\u0005;\nqAU5dQR\u0013\u00180\u0006\u0003\u0003`\t\u0015D\u0003\u0002B1\u0005O\u0002R\u0001 B\u001c\u0005G\u00022A\u0019B3\t\u0019!'\u0011\fb\u0001K\"A!\u0011\tB-\u0001\u0004\u0011I\u0007\u0005\u0004\u0002\u0002\u0006\u0015%1M\u0004\b\u0005[\u0012\u0001\u0012\u0001B8\u0003=\t5n[1IiR\u0004\b*\u00198eY\u0016\u0014\bcA#\u0003r\u00191\u0011A\u0001E\u0001\u0005g\u001a2A!\u001d\r\u0011\u001d\u0011%\u0011\u000fC\u0001\u0005o\"\"Aa\u001c\t\u0011\tm$\u0011\u000fC\u0005\u0005{\nQ!\u00199qYf$rA\u0005B@\u0005\u0003\u0013\u0019\t\u0003\u00041\u0005s\u0002\r!\r\u0005\u0007q\te\u0004\u0019A\u001d\t\ru\u0012I\b1\u0001?\u0011!\u0011YH!\u001d\u0005\u0002\t\u001dEC\u0001BE)\r\u0011\"1\u0012\u0005\tq\t\u0015\u0005\u0013!a\u0002s!A!q\u0012B9\t\u0003\u0011\t*\u0001\tvg&tw-Q2u_J\u001c\u0016p\u001d;f[R!!1\u0013BL)\r\u0011\"Q\u0013\u0005\tq\t5\u0005\u0013!a\u0002s!1\u0001G!$A\u0002EB!Ba'\u0003rE\u0005I\u0011\u0001BO\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\nDC\u0001BPU\rI$\u0011U\u0016\u0003\u0005G\u0003BA!*\u000306\u0011!q\u0015\u0006\u0005\u0005S\u0013Y+A\u0005v]\u000eDWmY6fI*\u0019!Q\u0016\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00032\n\u001d&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q!Q\u0017B9#\u0003%\tAa.\u00025U\u001c\u0018N\\4BGR|'oU=ti\u0016lG\u0005Z3gCVdG\u000f\n\u001a\u0015\t\t}%\u0011\u0018\u0005\u0007a\tM\u0006\u0019A\u0019")
public class AkkaHttpHandler
implements SttpHandler<Future, Source<ByteString, Object>> {
    private final ActorSystem actorSystem;
    private final ExecutionContext ec;
    private final boolean terminateActorSystemOnClose;
    private final ActorSystem as;
    private final ActorMaterializer materializer;

    public static ExecutionContext usingActorSystem$default$2(ActorSystem actorSystem) {
        return AkkaHttpHandler$.MODULE$.usingActorSystem$default$2(actorSystem);
    }

    public static ExecutionContext apply$default$1() {
        return AkkaHttpHandler$.MODULE$.apply$default$1();
    }

    public static SttpHandler<Future, Source<ByteString, Object>> usingActorSystem(ActorSystem actorSystem, ExecutionContext executionContext) {
        return AkkaHttpHandler$.MODULE$.usingActorSystem(actorSystem, executionContext);
    }

    public static SttpHandler<Future, Source<ByteString, Object>> apply(ExecutionContext executionContext) {
        return AkkaHttpHandler$.MODULE$.apply(executionContext);
    }

    private ActorSystem as() {
        return this.as;
    }

    private ActorMaterializer materializer() {
        return this.materializer;
    }

    public <T> Future<Response<T>> send(RequestT<Object, T, Source<ByteString, Object>> r) {
        ExecutionContext ec = this.ec;
        return this.RichTry(this.requestToAkka(r).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> this.setBodyOnAkka(r, (RequestBody<Source<ByteString, Object>>)r.body(), (HttpRequest)x$1))).toFuture().flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
            HttpExt qual$1 = Http$.MODULE$.apply(this.as());
            HttpRequest x$18 = x$2;
            HttpsConnectionContext x$19 = qual$1.singleRequest$default$2();
            ConnectionPoolSettings x$20 = qual$1.singleRequest$default$3();
            LoggingAdapter x$21 = qual$1.singleRequest$default$4();
            return qual$1.singleRequest(x$18, x$19, x$20, x$21, (Materializer)this.materializer());
        }, ec).flatMap((Function1 & Serializable & scala.Serializable)hr -> {
            int code = hr.status().intValue();
            Future body = package$.MODULE$.codeIsSuccess(code) ? this.bodyFromAkka(r.response(), this.decodeAkkaResponse((HttpResponse)hr)).map((Function1 & Serializable & scala.Serializable)x$3 -> scala.package$.MODULE$.Right().apply(x$3), ec) : this.bodyFromAkka(package$.MODULE$.asString(), this.decodeAkkaResponse((HttpResponse)hr)).map((Function1 & Serializable & scala.Serializable)x$4 -> scala.package$.MODULE$.Left().apply(x$4), ec);
            return body.map((Function1 & Serializable & scala.Serializable)x$5 -> new Response(x$5, code, this.headersFromAkka((HttpResponse)hr), (List)Nil$.MODULE$), ec);
        }, ec);
    }

    public MonadError<Future> responseMonad() {
        return new FutureMonad(this.ec);
    }

    private HttpMethod methodToAkka(String m) {
        HttpMethod httpMethod;
        String string = m;
        String string2 = Method$.MODULE$.GET();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            httpMethod = HttpMethods$.MODULE$.GET();
        } else {
            String string4 = Method$.MODULE$.HEAD();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                httpMethod = HttpMethods$.MODULE$.HEAD();
            } else {
                String string6 = Method$.MODULE$.POST();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    httpMethod = HttpMethods$.MODULE$.POST();
                } else {
                    String string8 = Method$.MODULE$.PUT();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        httpMethod = HttpMethods$.MODULE$.PUT();
                    } else {
                        String string10 = Method$.MODULE$.DELETE();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            httpMethod = HttpMethods$.MODULE$.DELETE();
                        } else {
                            String string12 = Method$.MODULE$.OPTIONS();
                            String string13 = string;
                            if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                httpMethod = HttpMethods$.MODULE$.OPTIONS();
                            } else {
                                String string14 = Method$.MODULE$.PATCH();
                                String string15 = string;
                                if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                    httpMethod = HttpMethods$.MODULE$.PATCH();
                                } else {
                                    String string16 = Method$.MODULE$.CONNECT();
                                    String string17 = string;
                                    if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                                        httpMethod = HttpMethods$.MODULE$.CONNECT();
                                    } else {
                                        String string18 = Method$.MODULE$.TRACE();
                                        String string19 = string;
                                        httpMethod = !(string18 != null ? !string18.equals(string19) : string19 != null) ? HttpMethods$.MODULE$.TRACE() : HttpMethod$.MODULE$.custom(m);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return httpMethod;
    }

    private <T> Future<T> bodyFromAkka(ResponseAs<T, Source<ByteString, Object>> rr, HttpResponse hr) {
        Future future;
        ExecutionContext ec = this.ec;
        ResponseAs<T, Source<ByteString, Object>> responseAs = rr;
        if (responseAs instanceof MappedResponseAs) {
            MappedResponseAs mappedResponseAs = (MappedResponseAs)responseAs;
            BasicResponseAs raw = mappedResponseAs.raw();
            Function1 g = mappedResponseAs.g();
            future = this.bodyFromAkka((ResponseAs<T, Source<ByteString, Object>>)raw, hr).map(g, ec);
        } else if (IgnoreResponse$.MODULE$.equals(responseAs)) {
            HttpMessage.HttpMessageScalaDSLSugar$.MODULE$.discardEntityBytes$extension(HttpMessage$.MODULE$.HttpMessageScalaDSLSugar((HttpMessage)hr), (Materializer)this.materializer());
            future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        } else if (responseAs instanceof ResponseAsString) {
            ResponseAsString responseAsString = (ResponseAsString)responseAs;
            String enc = responseAsString.encoding();
            future = this.asByteArray$1(hr, ec).map((Function1 & Serializable & scala.Serializable)x$9 -> new String((byte[])x$9, enc), ec);
        } else if (ResponseAsByteArray$.MODULE$.equals(responseAs)) {
            future = this.asByteArray$1(hr, ec);
        } else if (responseAs instanceof ResponseAsStream) {
            ResponseAsStream responseAsStream = (ResponseAsStream)responseAs;
            future = Future$.MODULE$.successful(responseAsStream.responseIsStream().apply((Object)hr.entity().dataBytes()));
        } else if (responseAs instanceof ResponseAsFile) {
            ResponseAsFile responseAsFile = (ResponseAsFile)responseAs;
            File file = responseAsFile.input();
            boolean overwrite = responseAsFile.overwrite();
            future = this.saved$1(file, overwrite, hr).map((Function1 & Serializable & scala.Serializable)x$10 -> file, ec);
        } else {
            throw new MatchError(responseAs);
        }
        return future;
    }

    private scala.collection.immutable.Seq<Tuple2<String, String>> headersFromAkka(HttpResponse hr) {
        Tuple2 ch = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.ContentTypeHeader()), (Object)hr.entity().contentType().toString());
        Option cl = hr.entity().contentLengthOption().map((Function1 & Serializable & scala.Serializable)x$11 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.ContentLengthHeader()), (Object)((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)x$11))).toString()));
        scala.collection.immutable.Seq other = (scala.collection.immutable.Seq)hr.headers().map((Function1 & Serializable & scala.Serializable)h -> new Tuple2((Object)h.name(), (Object)h.value()), Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = ch;
        return ((List)cl.toList().$plus$plus((GenTraversableOnce)other, List$.MODULE$.canBuildFrom())).$colon$colon((Object)tuple2);
    }

    private Try<HttpRequest> requestToAkka(RequestT<Object, ?, Source<ByteString, Object>> r) {
        akka.http.scaladsl.model.Uri x$22 = Uri$.MODULE$.apply(((Uri)r.uri()).toString());
        HttpMethod x$23 = this.methodToAkka(((Method)r.method()).m());
        scala.collection.immutable.Seq x$24 = HttpRequest$.MODULE$.apply$default$3();
        RequestEntity x$25 = HttpRequest$.MODULE$.apply$default$4();
        HttpProtocol x$26 = HttpRequest$.MODULE$.apply$default$5();
        HttpRequest ar = HttpRequest$.MODULE$.apply(x$23, x$22, x$24, x$25, x$26);
        return this.headersToAkka((scala.collection.immutable.Seq<Tuple2<String, String>>)r.headers()).map((Function1 & Serializable & scala.Serializable)headers -> ar.withHeaders(headers));
    }

    private Try<scala.collection.immutable.Seq<HttpHeader>> headersToAkka(scala.collection.immutable.Seq<Tuple2<String, String>> headers) {
        Failure failure;
        scala.collection.immutable.Seq parsed = (scala.collection.immutable.Seq)((TraversableLike)((TraversableLike)headers.filterNot((Function1 & Serializable & scala.Serializable)header -> BoxesRunTime.boxToBoolean((boolean)this.isContentType((Tuple2<String, String>)header)))).filterNot((Function1 & Serializable & scala.Serializable)header -> BoxesRunTime.boxToBoolean((boolean)this.isContentLength((Tuple2<String, String>)header)))).map((Function1 & Serializable & scala.Serializable)h -> HttpHeader$.MODULE$.parse((String)h._1(), (String)h._2(), HttpHeader$.MODULE$.parse$default$3()), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Seq errors = (scala.collection.immutable.Seq)parsed.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends HttpHeader.ParsingResult, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof HttpHeader.ParsingResult$.Error) {
                    HttpHeader.ParsingResult$.Error error = (HttpHeader.ParsingResult$.Error)A1;
                    ErrorInfo e = error.error();
                    object = e;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(HttpHeader.ParsingResult x1) {
                HttpHeader.ParsingResult parsingResult = x1;
                boolean bl = parsingResult instanceof HttpHeader.ParsingResult$.Error;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (errors.isEmpty()) {
            scala.collection.immutable.Seq headers2 = (scala.collection.immutable.Seq)parsed.collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends HttpHeader.ParsingResult, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof HttpHeader.ParsingResult$.Ok) {
                        HttpHeader.ParsingResult$.Ok ok = (HttpHeader.ParsingResult$.Ok)A1;
                        HttpHeader h = ok.header();
                        object = h;
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(HttpHeader.ParsingResult x2) {
                    HttpHeader.ParsingResult parsingResult = x2;
                    boolean bl = parsingResult instanceof HttpHeader.ParsingResult$.Ok;
                    return bl;
                }
            }, Seq$.MODULE$.canBuildFrom());
            failure = new Success((Object)headers2.toList());
        } else {
            failure = new Failure((Throwable)new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot parse headers: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errors}))));
        }
        return failure;
    }

    private <T> Try<scala.collection.immutable.Seq<T>> traverseTry(scala.collection.immutable.Seq<Try<T>> l) {
        scala.collection.immutable.Seq seq;
        scala.collection.immutable.Seq fs;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = l.partition((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isSuccess()));
                if (tuple2 == null) break block2;
                scala.collection.immutable.Seq ss = (scala.collection.immutable.Seq)tuple2._1();
                fs = (scala.collection.immutable.Seq)tuple2._2();
                if (!(ss instanceof scala.collection.immutable.Seq)) break block2;
                seq = ss;
                if (fs instanceof scala.collection.immutable.Seq) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Seq seq2 = fs;
        Tuple2 tuple2 = new Tuple2((Object)seq, (Object)seq2);
        Tuple2 tuple22 = tuple2;
        scala.collection.immutable.Seq ss = (scala.collection.immutable.Seq)tuple22._1();
        scala.collection.immutable.Seq fs2 = (scala.collection.immutable.Seq)tuple22._2();
        return fs2.isEmpty() ? new Success(ss.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.get(), Seq$.MODULE$.canBuildFrom())) : new Failure(((Failure)fs2.head()).exception());
    }

    private Try<HttpRequest> setBodyOnAkka(RequestT<Object, ?, Source<ByteString, Object>> r, RequestBody<Source<ByteString, Object>> body, HttpRequest ar) {
        return this.parseContentTypeOrOctetStream(r).flatMap((Function1 & Serializable & scala.Serializable)ct -> {
            Success success;
            RequestBody requestBody = body;
            if (NoBody$.MODULE$.equals(requestBody)) {
                success = new Success((Object)ar);
            } else if (requestBody instanceof StringBody) {
                StringBody stringBody = (StringBody)requestBody;
                String b = stringBody.s();
                String encoding = stringBody.encoding();
                success = new Success((Object)ar.withEntity((ContentType)AkkaHttpHandler.ctWithEncoding$1(ct, encoding), b.getBytes(encoding)));
            } else if (requestBody instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = (ByteArrayBody)requestBody;
                byte[] b = byteArrayBody.b();
                success = new Success((Object)ar.withEntity((RequestEntity)HttpEntity$.MODULE$.apply(ct, b)));
            } else if (requestBody instanceof ByteBufferBody) {
                ByteBufferBody byteBufferBody = (ByteBufferBody)requestBody;
                ByteBuffer b = byteBufferBody.b();
                success = new Success((Object)ar.withEntity((RequestEntity)HttpEntity$.MODULE$.apply(ct, ByteString$.MODULE$.apply(b))));
            } else if (requestBody instanceof InputStreamBody) {
                InputStreamBody inputStreamBody = (InputStreamBody)requestBody;
                InputStream b = inputStreamBody.b();
                success = new Success((Object)ar.withEntity((RequestEntity)HttpEntity$.MODULE$.apply(ct, StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable & scala.Serializable)() -> b, StreamConverters$.MODULE$.fromInputStream$default$2()))));
            } else if (requestBody instanceof PathBody) {
                PathBody pathBody = (PathBody)requestBody;
                Path b = pathBody.f();
                success = new Success((Object)ar.withEntity((ContentType)ct, b));
            } else if (requestBody instanceof StreamBody) {
                StreamBody streamBody = (StreamBody)requestBody;
                Source s = (Source)streamBody.s();
                success = new Success((Object)ar.withEntity((RequestEntity)HttpEntity$.MODULE$.apply(ct, s)));
            } else if (requestBody instanceof MultipartBody) {
                MultipartBody multipartBody = (MultipartBody)requestBody;
                scala.collection.immutable.Seq ps = multipartBody.parts();
                success = this.traverseTry((scala.collection.immutable.Seq)ps.map((Function1 & Serializable & scala.Serializable)mp -> this.toBodyPart$1((Multipart)mp), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)bodyParts -> ar.withEntity(Multipart.FormData$.MODULE$.apply((Seq)bodyParts).toEntity()));
            } else {
                throw new MatchError((Object)requestBody);
            }
            return success;
        });
    }

    private Try<akka.http.scaladsl.model.ContentType> parseContentTypeOrOctetStream(RequestT<Object, ?, Source<ByteString, Object>> r) {
        return this.parseContentTypeOrOctetStream((Option<String>)r.headers().find((Function1 & Serializable & scala.Serializable)header -> BoxesRunTime.boxToBoolean((boolean)this.isContentType((Tuple2<String, String>)header))).map((Function1 & Serializable & scala.Serializable)x$16 -> (String)x$16._2()));
    }

    private Try<akka.http.scaladsl.model.ContentType> parseContentTypeOrOctetStream(Option<String> ctHeader) {
        return (Try)ctHeader.map((Function1 & Serializable & scala.Serializable)ct -> (Try)ContentType$.MODULE$.parse(ct).fold((Function1 & Serializable & scala.Serializable)errors -> new Failure((Throwable)new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot parse content type: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errors})))), (Function1 & Serializable & scala.Serializable)x$17 -> new Success(x$17))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Success((Object)ContentTypes$.MODULE$.application$divoctet$minusstream()));
    }

    private boolean isContentType(Tuple2<String, String> header) {
        return ((String)header._1()).toLowerCase().contains(Content$minusType$.MODULE$.lowercaseName());
    }

    private boolean isContentLength(Tuple2<String, String> header) {
        return ((String)header._1()).toLowerCase().contains(Content$minusLength$.MODULE$.lowercaseName());
    }

    private HttpResponse decodeAkkaResponse(HttpResponse response) {
        Gzip$ gzip$;
        HttpEncoding httpEncoding = response.encoding();
        HttpEncoding httpEncoding2 = HttpEncodings$.MODULE$.gzip();
        HttpEncoding httpEncoding3 = httpEncoding;
        if (!(httpEncoding2 != null ? !httpEncoding2.equals(httpEncoding3) : httpEncoding3 != null)) {
            gzip$ = Gzip$.MODULE$;
        } else {
            HttpEncoding httpEncoding4 = HttpEncodings$.MODULE$.deflate();
            HttpEncoding httpEncoding5 = httpEncoding;
            if (!(httpEncoding4 != null ? !httpEncoding4.equals(httpEncoding5) : httpEncoding5 != null)) {
                gzip$ = Deflate$.MODULE$;
            } else {
                HttpEncoding httpEncoding6 = HttpEncodings$.MODULE$.identity();
                HttpEncoding httpEncoding7 = httpEncoding;
                if (!(httpEncoding6 != null ? !httpEncoding6.equals(httpEncoding7) : httpEncoding7 != null)) {
                    gzip$ = NoCoding$.MODULE$;
                } else {
                    throw new UnsupportedEncodingException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported encoding: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{httpEncoding})));
                }
            }
        }
        Gzip$ decoder = gzip$;
        return (HttpResponse)decoder.decodeMessage((HttpMessage)response);
    }

    public void close() {
        block0: {
            if (!this.terminateActorSystemOnClose) break block0;
            this.actorSystem.terminate();
        }
    }

    private <T> RichTry<T> RichTry(Try<T> t) {
        return new RichTry<T>(this, t);
    }

    private final Future asByteArray$1(HttpResponse hr$1, ExecutionContext ec$2) {
        return hr$1.entity().dataBytes().runFold((Object)ByteString$.MODULE$.apply(""), (Function2 & Serializable & scala.Serializable)(x$6, x$7) -> x$6.$plus$plus(x$7), (Materializer)this.materializer()).map((Function1 & Serializable & scala.Serializable)x$8 -> (byte[])x$8.toArray(ClassTag$.MODULE$.Byte()), ec$2);
    }

    private final Future saved$1(File file, boolean overwrite, HttpResponse hr$1) {
        Object object;
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            object = BoxesRunTime.boxToBoolean((boolean)file.createNewFile());
        } else {
            if (!overwrite) {
                throw new IOException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File ", " exists - overwriting prohibited"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file.getAbsolutePath()})));
            }
            object = BoxedUnit.UNIT;
        }
        return (Future)hr$1.entity().dataBytes().runWith((Graph)FileIO$.MODULE$.toPath(file.toPath(), FileIO$.MODULE$.toPath$default$2()), (Materializer)this.materializer());
    }

    private static final akka.http.scaladsl.model.ContentType ctWithEncoding$1(akka.http.scaladsl.model.ContentType ct, String encoding) {
        return (akka.http.scaladsl.model.ContentType)HttpCharsets$.MODULE$.getForKey((Object)encoding).map((Function1 & Serializable & scala.Serializable)hc -> ContentType$.MODULE$.apply(ct.mediaType(), (Function0 & Serializable & scala.Serializable)() -> hc)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ct);
    }

    private static final BodyPartEntity entity$1(akka.http.scaladsl.model.ContentType ct, Multipart mp$1) {
        HttpEntity.Strict strict;
        BasicRequestBody basicRequestBody = mp$1.body();
        if (basicRequestBody instanceof StringBody) {
            StringBody stringBody = (StringBody)basicRequestBody;
            String b = stringBody.s();
            String encoding = stringBody.encoding();
            strict = HttpEntity$.MODULE$.apply(AkkaHttpHandler.ctWithEncoding$1(ct, encoding), b.getBytes(encoding));
        } else if (basicRequestBody instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = (ByteArrayBody)basicRequestBody;
            byte[] b = byteArrayBody.b();
            strict = HttpEntity$.MODULE$.apply(ct, b);
        } else if (basicRequestBody instanceof ByteBufferBody) {
            ByteBufferBody byteBufferBody = (ByteBufferBody)basicRequestBody;
            ByteBuffer b = byteBufferBody.b();
            strict = HttpEntity$.MODULE$.apply(ct, ByteString$.MODULE$.apply(b));
        } else if (basicRequestBody instanceof InputStreamBody) {
            InputStreamBody inputStreamBody = (InputStreamBody)basicRequestBody;
            strict = new HttpEntity.IndefiniteLength(ct, StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable & scala.Serializable)() -> inputStreamBody.b(), StreamConverters$.MODULE$.fromInputStream$default$2()));
        } else if (basicRequestBody instanceof PathBody) {
            PathBody pathBody = (PathBody)basicRequestBody;
            Path b = pathBody.f();
            strict = HttpEntity$.MODULE$.fromPath(ct, b, HttpEntity$.MODULE$.fromPath$default$3());
        } else {
            throw new MatchError((Object)basicRequestBody);
        }
        return strict;
    }

    private final Try toBodyPart$1(Multipart mp) {
        return this.parseContentTypeOrOctetStream((Option<String>)mp.contentType()).flatMap((Function1 & Serializable & scala.Serializable)ct -> this.headersToAkka((scala.collection.immutable.Seq<Tuple2<String, String>>)mp.additionalHeaders().toList()).map((Function1 & Serializable & scala.Serializable)headers -> {
            Map dispositionParams = (Map)mp.fileName().fold((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty(), (Function1 & Serializable & scala.Serializable)fn -> (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filename"), fn)})));
            return Multipart.FormData$.BodyPart$.MODULE$.apply(mp.name(), AkkaHttpHandler.entity$1(ct, mp), dispositionParams, headers);
        }));
    }

    public AkkaHttpHandler(ActorSystem actorSystem, ExecutionContext ec, boolean terminateActorSystemOnClose) {
        this.actorSystem = actorSystem;
        this.ec = ec;
        this.terminateActorSystemOnClose = terminateActorSystemOnClose;
        this.as = actorSystem;
        this.materializer = ActorMaterializer$.MODULE$.apply(ActorMaterializer$.MODULE$.apply$default$1(), ActorMaterializer$.MODULE$.apply$default$2(), (ActorRefFactory)this.as());
    }

    public class RichTry<T> {
        private final Try<T> t;
        public final /* synthetic */ AkkaHttpHandler $outer;

        public Future<T> toFuture() {
            Future future;
            Try<T> try_ = this.t;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object v = success.value();
                future = Future$.MODULE$.successful(v);
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable v = failure.exception();
                future = Future$.MODULE$.failed(v);
            } else {
                throw new MatchError(try_);
            }
            return future;
        }

        public /* synthetic */ AkkaHttpHandler com$softwaremill$sttp$akkahttp$AkkaHttpHandler$RichTry$$$outer() {
            return this.$outer;
        }

        public RichTry(AkkaHttpHandler $outer, Try<T> t) {
            this.t = t;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

