/*
 * Decompiled with CFR 0.152.
 */
package com.softwaremill.sttp.akkahttp;

import akka.actor.ActorRefFactory;
import akka.actor.ActorSystem;
import akka.event.LoggingAdapter;
import akka.http.javadsl.model.ContentType;
import akka.http.scaladsl.ClientTransport$;
import akka.http.scaladsl.Http$;
import akka.http.scaladsl.HttpExt;
import akka.http.scaladsl.HttpsConnectionContext;
import akka.http.scaladsl.coding.Deflate$;
import akka.http.scaladsl.coding.Gzip$;
import akka.http.scaladsl.coding.NoCoding$;
import akka.http.scaladsl.model.BodyPartEntity;
import akka.http.scaladsl.model.ContentType$;
import akka.http.scaladsl.model.ContentTypes$;
import akka.http.scaladsl.model.ErrorInfo;
import akka.http.scaladsl.model.HttpCharsets$;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.HttpEntity$;
import akka.http.scaladsl.model.HttpHeader;
import akka.http.scaladsl.model.HttpHeader$;
import akka.http.scaladsl.model.HttpMessage;
import akka.http.scaladsl.model.HttpMethod;
import akka.http.scaladsl.model.HttpMethod$;
import akka.http.scaladsl.model.HttpMethods$;
import akka.http.scaladsl.model.HttpProtocol;
import akka.http.scaladsl.model.HttpRequest;
import akka.http.scaladsl.model.HttpRequest$;
import akka.http.scaladsl.model.HttpResponse;
import akka.http.scaladsl.model.Multipart;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.Uri$;
import akka.http.scaladsl.model.headers.Content$minusLength$;
import akka.http.scaladsl.model.headers.Content$minusType$;
import akka.http.scaladsl.model.headers.HttpEncoding;
import akka.http.scaladsl.model.headers.HttpEncodings$;
import akka.http.scaladsl.settings.ConnectionPoolSettings;
import akka.http.scaladsl.settings.ConnectionPoolSettings$;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializer$;
import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.scaladsl.FileIO$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.StreamConverters$;
import akka.util.ByteString;
import akka.util.ByteString$;
import com.softwaremill.sttp.BasicRequestBody;
import com.softwaremill.sttp.BasicResponseAs;
import com.softwaremill.sttp.ByteArrayBody;
import com.softwaremill.sttp.ByteBufferBody;
import com.softwaremill.sttp.FileBody;
import com.softwaremill.sttp.FutureMonad;
import com.softwaremill.sttp.HeaderNames$;
import com.softwaremill.sttp.IgnoreResponse$;
import com.softwaremill.sttp.InputStreamBody;
import com.softwaremill.sttp.MappedResponseAs;
import com.softwaremill.sttp.Method;
import com.softwaremill.sttp.Method$;
import com.softwaremill.sttp.MonadError;
import com.softwaremill.sttp.Multipart;
import com.softwaremill.sttp.MultipartBody;
import com.softwaremill.sttp.NoBody$;
import com.softwaremill.sttp.RequestBody;
import com.softwaremill.sttp.RequestT;
import com.softwaremill.sttp.Response;
import com.softwaremill.sttp.ResponseAs;
import com.softwaremill.sttp.ResponseAsByteArray$;
import com.softwaremill.sttp.ResponseAsFile;
import com.softwaremill.sttp.ResponseAsStream;
import com.softwaremill.sttp.ResponseAsString;
import com.softwaremill.sttp.StreamBody;
import com.softwaremill.sttp.StringBody;
import com.softwaremill.sttp.SttpBackend;
import com.softwaremill.sttp.SttpBackendOptions;
import com.softwaremill.sttp.Uri;
import com.softwaremill.sttp.akkahttp.AkkaHttpBackend$;
import com.softwaremill.sttp.internal.SttpFile;
import com.softwaremill.sttp.package$;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\rUd\u0001B\u0001\u0003\u0001-\u0011q\"Q6lC\"#H\u000f\u001d\"bG.,g\u000e\u001a\u0006\u0003\u0007\u0011\t\u0001\"Y6lC\"$H\u000f\u001d\u0006\u0003\u000b\u0019\tAa\u001d;ua*\u0011q\u0001C\u0001\rg>4Go^1sK6LG\u000e\u001c\u0006\u0002\u0013\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\u0004\n\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g!\u0011\u0019BC\u0006\u000f\u000e\u0003\u0011I!!\u0006\u0003\u0003\u0017M#H\u000f\u001d\"bG.,g\u000e\u001a\t\u0003/ii\u0011\u0001\u0007\u0006\u000339\t!bY8oGV\u0014(/\u001a8u\u0013\tY\u0002D\u0001\u0004GkR,(/\u001a\t\u0005;\u00112C&D\u0001\u001f\u0015\ty\u0002%\u0001\u0005tG\u0006d\u0017\rZ:m\u0015\t\t#%\u0001\u0004tiJ,\u0017-\u001c\u0006\u0002G\u0005!\u0011m[6b\u0013\t)cD\u0001\u0004T_V\u00148-\u001a\t\u0003O)j\u0011\u0001\u000b\u0006\u0003S\t\nA!\u001e;jY&\u00111\u0006\u000b\u0002\u000b\u0005f$Xm\u0015;sS:<\u0007CA\u0007.\u0013\tqcBA\u0002B]fD\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!M\u0001\fC\u000e$xN]*zgR,W\u000e\u0005\u00023k5\t1G\u0003\u00025E\u0005)\u0011m\u0019;pe&\u0011ag\r\u0002\f\u0003\u000e$xN]*zgR,W\u000e\u0003\u00059\u0001\t\u0005\t\u0015!\u0003:\u0003\t)7\r\u0005\u0002\u0018u%\u00111\b\u0007\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqRD\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IAP\u0001\u001ci\u0016\u0014X.\u001b8bi\u0016\f5\r^8s'f\u001cH/Z7P]\u000ecwn]3\u0011\u00055y\u0014B\u0001!\u000f\u0005\u001d\u0011un\u001c7fC:D\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IaQ\u0001\u0005_B$8\u000f\u0005\u0002\u0014\t&\u0011Q\t\u0002\u0002\u0013'R$\bOQ1dW\u0016tGm\u00149uS>t7\u000f\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0003I\u0019Wo\u001d;p[\"#H\u000f]:D_:$X\r\u001f;\u0011\u00075I5*\u0003\u0002K\u001d\t1q\n\u001d;j_:\u0004\"\u0001\u0014)\u000e\u00035S!a\b(\u000b\u0005=\u0013\u0013\u0001\u00025uiBL!!U'\u0003-!#H\u000f]:D_:tWm\u0019;j_:\u001cuN\u001c;fqRD\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001V\u0001\u001dGV\u001cHo\\7D_:tWm\u0019;j_:\u0004vn\u001c7TKR$\u0018N\\4t!\ri\u0011*\u0016\t\u0003-fk\u0011a\u0016\u0006\u000316\u000b\u0001b]3ui&twm]\u0005\u00035^\u0013acQ8o]\u0016\u001cG/[8o!>|GnU3ui&twm\u001d\u0005\t9\u0002\u0011\t\u0011)A\u0005;\u0006I1-^:u_6dun\u001a\t\u0004\u001b%s\u0006CA0c\u001b\u0005\u0001'BA1#\u0003\u0015)g/\u001a8u\u0013\t\u0019\u0007M\u0001\bM_\u001e<\u0017N\\4BI\u0006\u0004H/\u001a:\t\u000b\u0015\u0004A\u0011\u00024\u0002\rqJg.\u001b;?)!9\u0017N[6m[:|\u0007C\u00015\u0001\u001b\u0005\u0011\u0001\"\u0002\u0019e\u0001\u0004\t\u0004\"\u0002\u001de\u0001\u0004I\u0004\"B\u001fe\u0001\u0004q\u0004\"\u0002\"e\u0001\u0004\u0019\u0005\"B$e\u0001\u0004A\u0005\"B*e\u0001\u0004!\u0006\"\u0002/e\u0001\u0004iV\u0001B9\u0001\tq\u0011\u0011a\u0015\u0005\bg\u0002\u0011\r\u0011b\u0003u\u0003\t\t7/F\u00012\u0011\u00191\b\u0001)A\u0005c\u0005\u0019\u0011m\u001d\u0011\t\u000fa\u0004!\u0019!C\u0006s\u0006aQ.\u0019;fe&\fG.\u001b>feV\t!\u0010\u0005\u0002|y6\t\u0001%\u0003\u0002~A\t\t\u0012i\u0019;pe6\u000bG/\u001a:jC2L'0\u001a:\t\r}\u0004\u0001\u0015!\u0003{\u00035i\u0017\r^3sS\u0006d\u0017N_3sA!Aq\n\u0001b\u0001\n\u0013\t\u0019!\u0006\u0002\u0002\u0006A\u0019A*a\u0002\n\u0007\u0005%QJA\u0004IiR\u0004X\t\u001f;\t\u0011\u00055\u0001\u0001)A\u0005\u0003\u000b\tQ\u0001\u001b;ua\u0002B\u0011\"!\u0005\u0001\u0005\u0004%I!a\u0005\u0002-\r|gN\\3di&|g\u000eU8pYN+G\u000f^5oON,\u0012!\u0016\u0005\b\u0003/\u0001\u0001\u0015!\u0003V\u0003]\u0019wN\u001c8fGRLwN\u001c)p_2\u001cV\r\u001e;j]\u001e\u001c\b\u0005C\u0004\u0002\u001c\u0001!\t%!\b\u0002\tM,g\u000eZ\u000b\u0005\u0003?\ti\u0003\u0006\u0003\u0002\"\u0005e\u0002\u0003B\f\u001b\u0003G\u0001RaEA\u0013\u0003SI1!a\n\u0005\u0005!\u0011Vm\u001d9p]N,\u0007\u0003BA\u0016\u0003[a\u0001\u0001\u0002\u0005\u00020\u0005e!\u0019AA\u0019\u0005\u0005!\u0016cAA\u001aYA\u0019Q\"!\u000e\n\u0007\u0005]bBA\u0004O_RD\u0017N\\4\t\u0011\u0005m\u0012\u0011\u0004a\u0001\u0003{\t\u0011A\u001d\t\t\u0003\u007f\t9&!\u000b\u0002^9!\u0011\u0011IA*\u001d\u0011\t\u0019%!\u0015\u000f\t\u0005\u0015\u0013q\n\b\u0005\u0003\u000f\ni%\u0004\u0002\u0002J)\u0019\u00111\n\u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0011BA\u0004\t\u0013\t)a!C\u0002\u0002V\u0011\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002Z\u0005m#a\u0002*fcV,7\u000f\u001e\u0006\u0004\u0003+\"\u0001cAA0a6\t\u0001\u0001C\u0004\u0002d\u0001!\t%!\u001a\u0002\u001bI,7\u000f]8og\u0016luN\\1e+\t\t9\u0007\u0005\u0003\u0014\u0003S2\u0012bAA6\t\tQQj\u001c8bI\u0016\u0013(o\u001c:\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r\u0005aQ.\u001a;i_\u0012$v.Q6lCR!\u00111OA@!\u0011\t)(a\u001f\u000e\u0005\u0005]$bAA=\u001b\u0006)Qn\u001c3fY&!\u0011QPA<\u0005)AE\u000f\u001e9NKRDw\u000e\u001a\u0005\t\u0003\u0003\u000bi\u00071\u0001\u0002\u0004\u0006\tQ\u000eE\u0002\u0014\u0003\u000bK1!a\"\u0005\u0005\u0019iU\r\u001e5pI\"9\u00111\u0012\u0001\u0005\n\u00055\u0015\u0001\u00042pIf4%o\\7BW.\fW\u0003BAH\u0003+#\u0002\"!%\u0002\u0018\u0006\u0005\u00161\u0016\t\u0005/i\t\u0019\n\u0005\u0003\u0002,\u0005UE\u0001CA\u0018\u0003\u0013\u0013\r!!\r\t\u0011\u0005e\u0015\u0011\u0012a\u0001\u00037\u000b!A\u001d:\u0011\u000fM\ti*a%\u0002^%\u0019\u0011q\u0014\u0003\u0003\u0015I+7\u000f]8og\u0016\f5\u000f\u0003\u0005\u0002$\u0006%\u0005\u0019AAS\u0003\tA'\u000f\u0005\u0003\u0002v\u0005\u001d\u0016\u0002BAU\u0003o\u0012A\u0002\u0013;uaJ+7\u000f]8og\u0016D\u0001\"!,\u0002\n\u0002\u0007\u0011qV\u0001\u0013G\"\f'o]3u\rJ|W\u000eS3bI\u0016\u00148\u000f\u0005\u0003\u000e\u0013\u0006E\u0006\u0003BAZ\u0003wsA!!.\u00028B\u0019\u0011q\t\b\n\u0007\u0005ef\"\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003{\u000byL\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003ss\u0001bBAb\u0001\u0011%\u0011QY\u0001\u0010Q\u0016\fG-\u001a:t\rJ|W.Q6lCR!\u0011qYAo!\u0019\tI-a5\u0002X6\u0011\u00111\u001a\u0006\u0005\u0003\u001b\fy-A\u0005j[6,H/\u00192mK*\u0019\u0011\u0011\u001b\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002V\u0006-'aA*fcB9Q\"!7\u00022\u0006E\u0016bAAn\u001d\t1A+\u001e9mKJB\u0001\"a)\u0002B\u0002\u0007\u0011Q\u0015\u0005\b\u0003C\u0004A\u0011BAr\u00035\u0011X-];fgR$v.Q6lCR!\u0011Q]A{!\u0019\t9/a;\u0002p6\u0011\u0011\u0011\u001e\u0006\u0003S9IA!!<\u0002j\n\u0019AK]=\u0011\t\u0005U\u0014\u0011_\u0005\u0005\u0003g\f9HA\u0006IiR\u0004(+Z9vKN$\b\u0002CA\u001e\u0003?\u0004\r!a>1\t\u0005e\u0018Q \t\t\u0003\u007f\t9&a?\u0002^A!\u00111FA\u007f\t1\ty0!>\u0002\u0002\u0003\u0005)\u0011AA\u0019\u0005\ryF%\r\u0005\b\u0005\u0007\u0001A\u0011\u0002B\u0003\u00035AW-\u00193feN$v.Q6lCR!!q\u0001B\t!\u0019\t9/a;\u0003\nA1\u0011\u0011ZAj\u0005\u0017\u0001B!!\u001e\u0003\u000e%!!qBA<\u0005)AE\u000f\u001e9IK\u0006$WM\u001d\u0005\t\u0005'\u0011\t\u00011\u0001\u0002H\u00069\u0001.Z1eKJ\u001c\bb\u0002B\f\u0001\u0011%!\u0011D\u0001\fiJ\fg/\u001a:tKR\u0013\u00180\u0006\u0003\u0003\u001c\t\rB\u0003\u0002B\u000f\u0005K\u0001b!a:\u0002l\n}\u0001CBAe\u0003'\u0014\t\u0003\u0005\u0003\u0002,\t\rB\u0001CA\u0018\u0005+\u0011\r!!\r\t\u0011\t\u001d\"Q\u0003a\u0001\u0005S\t\u0011\u0001\u001c\t\u0007\u0003\u0013\f\u0019Na\u000b\u0011\r\u0005\u001d\u00181\u001eB\u0011\u0011\u001d\u0011y\u0003\u0001C\u0005\u0005c\tQb]3u\u0005>$\u0017p\u00148BW.\fG\u0003CAs\u0005g\u0011yD!\u0013\t\u0011\u0005m\"Q\u0006a\u0001\u0005k\u0001DAa\u000e\u0003<AA\u0011qHA,\u0005s\ti\u0006\u0005\u0003\u0002,\tmB\u0001\u0004B\u001f\u0005g\t\t\u0011!A\u0003\u0002\u0005E\"aA0%e!A!\u0011\tB\u0017\u0001\u0004\u0011\u0019%\u0001\u0003c_\u0012L\b#B\n\u0003F\u0005u\u0013b\u0001B$\t\tY!+Z9vKN$(i\u001c3z\u0011!\u0011YE!\fA\u0002\u0005=\u0018AA1s\u0011\u001d\u0011y\u0005\u0001C\u0005\u0005#\nQ\u0004]1sg\u0016\u001cuN\u001c;f]R$\u0016\u0010]3Pe>\u001bG/\u001a;TiJ,\u0017-\u001c\u000b\u0005\u0005'\u0012Y\u0006\u0005\u0004\u0002h\u0006-(Q\u000b\t\u0005\u0003k\u00129&\u0003\u0003\u0003Z\u0005]$aC\"p]R,g\u000e\u001e+za\u0016D\u0001\"a\u000f\u0003N\u0001\u0007!Q\f\u0019\u0005\u0005?\u0012\u0019\u0007\u0005\u0005\u0002@\u0005]#\u0011MA/!\u0011\tYCa\u0019\u0005\u0019\t\u0015$1LA\u0001\u0002\u0003\u0015\t!!\r\u0003\u0007}#3\u0007C\u0004\u0003P\u0001!IA!\u001b\u0015\t\tM#1\u000e\u0005\t\u0005[\u00129\u00071\u0001\u00020\u0006A1\r\u001e%fC\u0012,'\u000fC\u0004\u0003r\u0001!IAa\u001d\u0002\u001b%\u001c8i\u001c8uK:$H+\u001f9f)\rq$Q\u000f\u0005\t\u0005o\u0012y\u00071\u0001\u0002X\u00061\u0001.Z1eKJDqAa\u001f\u0001\t\u0013\u0011i(A\bjg\u000e{g\u000e^3oi2+gn\u001a;i)\rq$q\u0010\u0005\t\u0005o\u0012I\b1\u0001\u0002X\"9!1\u0011\u0001\u0005\n\t\u0015\u0015A\u00053fG>$W-Q6lCJ+7\u000f]8og\u0016$B!!*\u0003\b\"A!\u0011\u0012BA\u0001\u0004\t)+\u0001\u0005sKN\u0004xN\\:f\u0011\u001d\u0011i\t\u0001C!\u0005\u001f\u000bQa\u00197pg\u0016$\"A!%\u0011\u00075\u0011\u0019*C\u0002\u0003\u0016:\u0011A!\u00168ji\u001a1!\u0011\u0014\u0001\u0006\u00057\u0013qAU5dQR\u0013\u00180\u0006\u0003\u0003\u001e\n\u001d6c\u0001BL\u0019!Y!\u0011\u0015BL\u0005\u0003\u0005\u000b\u0011\u0002BR\u0003\u0005!\bCBAt\u0003W\u0014)\u000b\u0005\u0003\u0002,\t\u001dF\u0001CA\u0018\u0005/\u0013\r!!\r\t\u000f\u0015\u00149\n\"\u0001\u0003,R!!Q\u0016BX!\u0019\tyFa&\u0003&\"A!\u0011\u0015BU\u0001\u0004\u0011\u0019\u000b\u0003\u0005\u00034\n]E\u0011\u0001B[\u0003!!xNR;ukJ,WC\u0001B\\!\u00119\"D!*\t\u0013\tm\u0006!!A\u0005\f\tu\u0016a\u0002*jG\"$&/_\u000b\u0005\u0005\u007f\u0013)\r\u0006\u0003\u0003B\n\u001d\u0007CBA0\u0005/\u0013\u0019\r\u0005\u0003\u0002,\t\u0015G\u0001CA\u0018\u0005s\u0013\r!!\r\t\u0011\t\u0005&\u0011\u0018a\u0001\u0005\u0013\u0004b!a:\u0002l\n\rwa\u0002Bg\u0005!\u0005!qZ\u0001\u0010\u0003.\\\u0017\r\u0013;ua\n\u000b7m[3oIB\u0019\u0001N!5\u0007\r\u0005\u0011\u0001\u0012\u0001Bj'\r\u0011\t\u000e\u0004\u0005\bK\nEG\u0011\u0001Bl)\t\u0011y\r\u0003\u0005\u0003\\\nEG\u0011\u0002Bo\u0003\u0015\t\u0007\u000f\u001d7z)=\u0011\"q\u001cBq\u0005G\u0014)O!;\u0003l\n5\bB\u0002\u0019\u0003Z\u0002\u0007\u0011\u0007\u0003\u00049\u00053\u0004\r!\u000f\u0005\u0007{\te\u0007\u0019\u0001 \t\u000f\t\u001d(\u0011\u001ca\u0001\u0007\u00069q\u000e\u001d;j_:\u001c\bBB$\u0003Z\u0002\u0007\u0001\n\u0003\u0004T\u00053\u0004\r\u0001\u0016\u0005\u00079\ne\u0007\u0019A/\t\u0011\tm'\u0011\u001bC\u0001\u0005c$\"Ba=\u0003x\ne(1 B\u007f)\r\u0011\"Q\u001f\u0005\tq\t=\b\u0013!a\u0002s!I!q\u001dBx!\u0003\u0005\ra\u0011\u0005\t\u000f\n=\b\u0013!a\u0001\u0011\"A1Ka<\u0011\u0002\u0003\u0007A\u000b\u0003\u0005]\u0005_\u0004\n\u00111\u0001^\u0011!\u0019\tA!5\u0005\u0002\r\r\u0011\u0001E;tS:<\u0017i\u0019;peNK8\u000f^3n)1\u0019)a!\u0003\u0004\f\r51qBB\t)\r\u00112q\u0001\u0005\tq\t}\b\u0013!a\u0002s!1\u0001Ga@A\u0002EB\u0011Ba:\u0003\u0000B\u0005\t\u0019A\"\t\u0011\u001d\u0013y\u0010%AA\u0002!C\u0001b\u0015B\u0000!\u0003\u0005\r\u0001\u0016\u0005\t9\n}\b\u0013!a\u0001;\"Q1Q\u0003Bi#\u0003%\taa\u0006\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIE*\"a!\u0007+\u0007\r\u001bYb\u000b\u0002\u0004\u001eA!1qDB\u0015\u001b\t\u0019\tC\u0003\u0003\u0004$\r\u0015\u0012!C;oG\",7m[3e\u0015\r\u00199CD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\u0016\u0007C\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\u0019yC!5\u0012\u0002\u0013\u00051\u0011G\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%eU\u001111\u0007\u0016\u0004\u0011\u000em\u0001BCB\u001c\u0005#\f\n\u0011\"\u0001\u0004:\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$3'\u0006\u0002\u0004<)\u001aAka\u0007\t\u0015\r}\"\u0011[I\u0001\n\u0003\u0019\t%A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019\u0019EK\u0002^\u00077A!ba\u0012\u0003RF\u0005I\u0011AB%\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012*DCCB&\u0007\u001b\u001aye!\u0015\u0004T)\u001a\u0011ha\u0007\t\u000f\t\u001d8Q\ta\u0001\u0007\"1qi!\u0012A\u0002!CaaUB#\u0001\u0004!\u0006B\u0002/\u0004F\u0001\u0007Q\f\u0003\u0006\u0004X\tE\u0017\u0013!C\u0001\u0007/\t!$^:j]\u001e\f5\r^8s'f\u001cH/Z7%I\u00164\u0017-\u001e7uIIB!ba\u0017\u0003RF\u0005I\u0011AB\u0019\u0003i)8/\u001b8h\u0003\u000e$xN]*zgR,W\u000e\n3fM\u0006,H\u000e\u001e\u00134\u0011)\u0019yF!5\u0012\u0002\u0013\u00051\u0011H\u0001\u001bkNLgnZ!di>\u00148+_:uK6$C-\u001a4bk2$H\u0005\u000e\u0005\u000b\u0007G\u0012\t.%A\u0005\u0002\r\u0005\u0013AG;tS:<\u0017i\u0019;peNK8\u000f^3nI\u0011,g-Y;mi\u0012*\u0004BCB4\u0005#\f\n\u0011\"\u0001\u0004j\u0005QRo]5oO\u0006\u001bGo\u001c:TsN$X-\u001c\u0013eK\u001a\fW\u000f\u001c;%mQa11JB6\u0007[\u001ayg!\u001d\u0004t!1\u0001g!\u001aA\u0002EBqAa:\u0004f\u0001\u00071\t\u0003\u0004H\u0007K\u0002\r\u0001\u0013\u0005\u0007'\u000e\u0015\u0004\u0019\u0001+\t\rq\u001b)\u00071\u0001^\u0001")
public class AkkaHttpBackend
implements SttpBackend<Future, Source<ByteString, Object>> {
    private final ActorSystem actorSystem;
    private final ExecutionContext ec;
    private final boolean terminateActorSystemOnClose;
    private final SttpBackendOptions opts;
    private final Option<HttpsConnectionContext> customHttpsContext;
    private final Option<LoggingAdapter> customLog;
    private final ActorSystem as;
    private final ActorMaterializer materializer;
    private final HttpExt http;
    private final ConnectionPoolSettings connectionPoolSettings;
    private volatile byte bitmap$init$0;

    public static ExecutionContext usingActorSystem$default$6(ActorSystem actorSystem, SttpBackendOptions sttpBackendOptions, Option<HttpsConnectionContext> option, Option<ConnectionPoolSettings> option2, Option<LoggingAdapter> option3) {
        return AkkaHttpBackend$.MODULE$.usingActorSystem$default$6(actorSystem, sttpBackendOptions, option, option2, option3);
    }

    public static Option<LoggingAdapter> usingActorSystem$default$5() {
        return AkkaHttpBackend$.MODULE$.usingActorSystem$default$5();
    }

    public static Option<ConnectionPoolSettings> usingActorSystem$default$4() {
        return AkkaHttpBackend$.MODULE$.usingActorSystem$default$4();
    }

    public static Option<HttpsConnectionContext> usingActorSystem$default$3() {
        return AkkaHttpBackend$.MODULE$.usingActorSystem$default$3();
    }

    public static SttpBackendOptions usingActorSystem$default$2() {
        return AkkaHttpBackend$.MODULE$.usingActorSystem$default$2();
    }

    public static ExecutionContext apply$default$5(SttpBackendOptions sttpBackendOptions, Option<HttpsConnectionContext> option, Option<ConnectionPoolSettings> option2, Option<LoggingAdapter> option3) {
        return AkkaHttpBackend$.MODULE$.apply$default$5(sttpBackendOptions, option, option2, option3);
    }

    public static Option<LoggingAdapter> apply$default$4() {
        return AkkaHttpBackend$.MODULE$.apply$default$4();
    }

    public static Option<ConnectionPoolSettings> apply$default$3() {
        return AkkaHttpBackend$.MODULE$.apply$default$3();
    }

    public static Option<HttpsConnectionContext> apply$default$2() {
        return AkkaHttpBackend$.MODULE$.apply$default$2();
    }

    public static SttpBackendOptions apply$default$1() {
        return AkkaHttpBackend$.MODULE$.apply$default$1();
    }

    public static SttpBackend<Future, Source<ByteString, Object>> usingActorSystem(ActorSystem actorSystem, SttpBackendOptions sttpBackendOptions, Option<HttpsConnectionContext> option, Option<ConnectionPoolSettings> option2, Option<LoggingAdapter> option3, ExecutionContext executionContext) {
        return AkkaHttpBackend$.MODULE$.usingActorSystem(actorSystem, sttpBackendOptions, option, option2, option3, executionContext);
    }

    public static SttpBackend<Future, Source<ByteString, Object>> apply(SttpBackendOptions sttpBackendOptions, Option<HttpsConnectionContext> option, Option<ConnectionPoolSettings> option2, Option<LoggingAdapter> option3, ExecutionContext executionContext) {
        return AkkaHttpBackend$.MODULE$.apply(sttpBackendOptions, option, option2, option3, executionContext);
    }

    private ActorSystem as() {
        if ((byte)(this.bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/adamw/projects/sttp/akka-http-backend/src/main/scala/com/softwaremill/sttp/akkahttp/AkkaHttpBackend.scala: 36");
        }
        return this.as;
    }

    private ActorMaterializer materializer() {
        if ((byte)(this.bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/adamw/projects/sttp/akka-http-backend/src/main/scala/com/softwaremill/sttp/akkahttp/AkkaHttpBackend.scala: 37");
        }
        return this.materializer;
    }

    private HttpExt http() {
        if ((byte)(this.bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/adamw/projects/sttp/akka-http-backend/src/main/scala/com/softwaremill/sttp/akkahttp/AkkaHttpBackend.scala: 39");
        }
        return this.http;
    }

    private ConnectionPoolSettings connectionPoolSettings() {
        if ((byte)(this.bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /Users/adamw/projects/sttp/akka-http-backend/src/main/scala/com/softwaremill/sttp/akkahttp/AkkaHttpBackend.scala: 41");
        }
        return this.connectionPoolSettings;
    }

    public <T> Future<Response<T>> send(RequestT<Object, T, Source<ByteString, Object>> r) {
        Some some;
        SttpBackendOptions.Proxy p;
        ExecutionContext ec = this.ec;
        Option option = this.opts.proxy();
        ConnectionPoolSettings connectionPoolSettings = option instanceof Some && !(p = (SttpBackendOptions.Proxy)(some = (Some)option).value()).ignoreProxy(((Uri)r.uri()).host()) ? this.connectionPoolSettings().withTransport(ClientTransport$.MODULE$.httpsProxy(p.inetSocketAddress())) : this.connectionPoolSettings();
        ConnectionPoolSettings connectionPoolSettingsWithProxy = connectionPoolSettings;
        ConnectionPoolSettings settings = connectionPoolSettingsWithProxy.withUpdatedConnectionSettings((Function1 & Serializable & scala.Serializable)x$2 -> x$2.withIdleTimeout(r.options().readTimeout()));
        return this.RichTry(this.requestToAkka(r).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> this.setBodyOnAkka(r, (RequestBody<Source<ByteString, Object>>)r.body(), (HttpRequest)x$3))).toFuture().flatMap((Function1 & Serializable & scala.Serializable)req -> {
            HttpRequest x$21 = req;
            ConnectionPoolSettings x$22 = settings;
            HttpsConnectionContext x$23 = (HttpsConnectionContext)$this.customHttpsContext.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.http().defaultClientHttpsContext());
            LoggingAdapter x$24 = (LoggingAdapter)$this.customLog.getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.actorSystem.log());
            return this.http().singleRequest(x$21, x$23, x$22, x$24);
        }, ec).flatMap((Function1 & Serializable & scala.Serializable)hr -> {
            int code = hr.status().intValue();
            String statusText = hr.status().reason();
            scala.collection.immutable.Seq<Tuple2<String, String>> headers = this.headersFromAkka((HttpResponse)hr);
            Option charsetFromHeaders = headers.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AkkaHttpBackend.$anonfun$send$7(x$4))).map((Function1 & Serializable & scala.Serializable)x$5 -> (String)x$5._2()).flatMap((Function1 & Serializable & scala.Serializable)ct -> com.softwaremill.sttp.internal.package$.MODULE$.encodingFromContentType(ct));
            Future body = r.options().parseResponseIf().apply$mcZI$sp(code) ? this.bodyFromAkka(r.response(), this.decodeAkkaResponse((HttpResponse)hr), (Option<String>)charsetFromHeaders).map((Function1 & Serializable & scala.Serializable)x$6 -> scala.package$.MODULE$.Right().apply(x$6), ec) : this.bodyFromAkka(package$.MODULE$.asByteArray(), this.decodeAkkaResponse((HttpResponse)hr), (Option<String>)charsetFromHeaders).map((Function1 & Serializable & scala.Serializable)x$7 -> scala.package$.MODULE$.Left().apply(x$7), ec);
            return body.map((Function1 & Serializable & scala.Serializable)x$8 -> new Response(x$8, code, statusText, headers, (List)Nil$.MODULE$), ec);
        }, ec);
    }

    public MonadError<Future> responseMonad() {
        return new FutureMonad(this.ec);
    }

    private HttpMethod methodToAkka(String m) {
        HttpMethod httpMethod;
        String string = m;
        String string2 = Method$.MODULE$.GET();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            httpMethod = HttpMethods$.MODULE$.GET();
        } else {
            String string4 = Method$.MODULE$.HEAD();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                httpMethod = HttpMethods$.MODULE$.HEAD();
            } else {
                String string6 = Method$.MODULE$.POST();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    httpMethod = HttpMethods$.MODULE$.POST();
                } else {
                    String string8 = Method$.MODULE$.PUT();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        httpMethod = HttpMethods$.MODULE$.PUT();
                    } else {
                        String string10 = Method$.MODULE$.DELETE();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            httpMethod = HttpMethods$.MODULE$.DELETE();
                        } else {
                            String string12 = Method$.MODULE$.OPTIONS();
                            String string13 = string;
                            if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                httpMethod = HttpMethods$.MODULE$.OPTIONS();
                            } else {
                                String string14 = Method$.MODULE$.PATCH();
                                String string15 = string;
                                if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                    httpMethod = HttpMethods$.MODULE$.PATCH();
                                } else {
                                    String string16 = Method$.MODULE$.CONNECT();
                                    String string17 = string;
                                    if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                                        httpMethod = HttpMethods$.MODULE$.CONNECT();
                                    } else {
                                        String string18 = Method$.MODULE$.TRACE();
                                        String string19 = string;
                                        httpMethod = !(string18 != null ? !string18.equals(string19) : string19 != null) ? HttpMethods$.MODULE$.TRACE() : HttpMethod$.MODULE$.custom(m);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return httpMethod;
    }

    private <T> Future<T> bodyFromAkka(ResponseAs<T, Source<ByteString, Object>> rr, HttpResponse hr, Option<String> charsetFromHeaders) {
        Future future;
        ExecutionContext ec = this.ec;
        ResponseAs<T, Source<ByteString, Object>> responseAs = rr;
        if (responseAs instanceof MappedResponseAs) {
            MappedResponseAs mappedResponseAs = (MappedResponseAs)responseAs;
            BasicResponseAs raw = mappedResponseAs.raw();
            Function1 g = mappedResponseAs.g();
            future = this.bodyFromAkka((ResponseAs<T, Source<ByteString, Object>>)raw, hr, charsetFromHeaders).map(g, ec);
        } else if (IgnoreResponse$.MODULE$.equals(responseAs)) {
            hr.entity().dataBytes().runWith((Graph)Sink$.MODULE$.ignore(), (Materializer)this.materializer());
            future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        } else if (responseAs instanceof ResponseAsString) {
            ResponseAsString responseAsString = (ResponseAsString)responseAs;
            String enc = responseAsString.encoding();
            future = this.asByteArray$1(hr, ec).map((Function1 & Serializable & scala.Serializable)x$12 -> new String((byte[])x$12, (String)charsetFromHeaders.getOrElse((Function0 & Serializable & scala.Serializable)() -> enc)), ec);
        } else if (ResponseAsByteArray$.MODULE$.equals(responseAs)) {
            future = this.asByteArray$1(hr, ec);
        } else if (responseAs instanceof ResponseAsStream) {
            ResponseAsStream responseAsStream = (ResponseAsStream)responseAs;
            future = Future$.MODULE$.successful(responseAsStream.responseIsStream().apply((Object)hr.entity().dataBytes()));
        } else if (responseAs instanceof ResponseAsFile) {
            ResponseAsFile responseAsFile = (ResponseAsFile)responseAs;
            SttpFile file = responseAsFile.output();
            boolean overwrite = responseAsFile.overwrite();
            future = this.saved$1(file.toFile(), overwrite, hr).map((Function1 & Serializable & scala.Serializable)x$13 -> file, ec);
        } else {
            throw new MatchError(responseAs);
        }
        return future;
    }

    private scala.collection.immutable.Seq<Tuple2<String, String>> headersFromAkka(HttpResponse hr) {
        Tuple2 ch = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.ContentType()), (Object)hr.entity().contentType().toString());
        Option cl = hr.entity().contentLengthOption().map((Function1 & Serializable & scala.Serializable)x$14 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.ContentLength()), (Object)((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)x$14))).toString()));
        scala.collection.immutable.Seq other = (scala.collection.immutable.Seq)hr.headers().map((Function1 & Serializable & scala.Serializable)h -> new Tuple2((Object)h.name(), (Object)h.value()), Seq$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = ch;
        return ((List)cl.toList().$plus$plus((GenTraversableOnce)other, List$.MODULE$.canBuildFrom())).$colon$colon((Object)tuple2);
    }

    private Try<HttpRequest> requestToAkka(RequestT<Object, ?, Source<ByteString, Object>> r) {
        akka.http.scaladsl.model.Uri x$25 = Uri$.MODULE$.apply(((Uri)r.uri()).toString());
        HttpMethod x$26 = this.methodToAkka(((Method)r.method()).m());
        scala.collection.immutable.Seq x$27 = HttpRequest$.MODULE$.apply$default$3();
        RequestEntity x$28 = HttpRequest$.MODULE$.apply$default$4();
        HttpProtocol x$29 = HttpRequest$.MODULE$.apply$default$5();
        HttpRequest ar = HttpRequest$.MODULE$.apply(x$26, x$25, x$27, x$28, x$29);
        return this.headersToAkka((scala.collection.immutable.Seq<Tuple2<String, String>>)r.headers()).map((Function1 & Serializable & scala.Serializable)headers -> ar.withHeaders(headers));
    }

    private Try<scala.collection.immutable.Seq<HttpHeader>> headersToAkka(scala.collection.immutable.Seq<Tuple2<String, String>> headers) {
        Failure failure;
        scala.collection.immutable.Seq parsed = (scala.collection.immutable.Seq)((TraversableLike)((TraversableLike)headers.filterNot((Function1 & Serializable & scala.Serializable)header -> BoxesRunTime.boxToBoolean((boolean)this.isContentType((Tuple2<String, String>)header)))).filterNot((Function1 & Serializable & scala.Serializable)header -> BoxesRunTime.boxToBoolean((boolean)this.isContentLength((Tuple2<String, String>)header)))).map((Function1 & Serializable & scala.Serializable)h -> HttpHeader$.MODULE$.parse((String)h._1(), (String)h._2(), HttpHeader$.MODULE$.parse$default$3()), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Seq errors = (scala.collection.immutable.Seq)parsed.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends HttpHeader.ParsingResult, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof HttpHeader.ParsingResult$.Error) {
                    HttpHeader.ParsingResult$.Error error = (HttpHeader.ParsingResult$.Error)A1;
                    ErrorInfo e = error.error();
                    object = e;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(HttpHeader.ParsingResult x1) {
                HttpHeader.ParsingResult parsingResult = x1;
                boolean bl = parsingResult instanceof HttpHeader.ParsingResult$.Error;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (errors.isEmpty()) {
            scala.collection.immutable.Seq headers2 = (scala.collection.immutable.Seq)parsed.collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends HttpHeader.ParsingResult, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x2;
                    if (A1 instanceof HttpHeader.ParsingResult$.Ok) {
                        HttpHeader.ParsingResult$.Ok ok = (HttpHeader.ParsingResult$.Ok)A1;
                        HttpHeader h = ok.header();
                        object = h;
                    } else {
                        object = function1.apply(x2);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(HttpHeader.ParsingResult x2) {
                    HttpHeader.ParsingResult parsingResult = x2;
                    boolean bl = parsingResult instanceof HttpHeader.ParsingResult$.Ok;
                    return bl;
                }
            }, Seq$.MODULE$.canBuildFrom());
            failure = new Success((Object)headers2.toList());
        } else {
            failure = new Failure((Throwable)new RuntimeException(new StringBuilder(22).append("Cannot parse headers: ").append(errors).toString()));
        }
        return failure;
    }

    private <T> Try<scala.collection.immutable.Seq<T>> traverseTry(scala.collection.immutable.Seq<Try<T>> l) {
        scala.collection.immutable.Seq seq;
        scala.collection.immutable.Seq fs;
        block3: {
            Tuple2 tuple2;
            block2: {
                tuple2 = l.partition((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.isSuccess()));
                if (tuple2 == null) break block2;
                scala.collection.immutable.Seq ss = (scala.collection.immutable.Seq)tuple2._1();
                fs = (scala.collection.immutable.Seq)tuple2._2();
                if (!(ss instanceof scala.collection.immutable.Seq)) break block2;
                seq = ss;
                if (fs instanceof scala.collection.immutable.Seq) break block3;
            }
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Seq seq2 = fs;
        Tuple2 tuple2 = new Tuple2((Object)seq, (Object)seq2);
        Tuple2 tuple22 = tuple2;
        scala.collection.immutable.Seq ss = (scala.collection.immutable.Seq)tuple22._1();
        scala.collection.immutable.Seq fs2 = (scala.collection.immutable.Seq)tuple22._2();
        return fs2.isEmpty() ? new Success(ss.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.get(), Seq$.MODULE$.canBuildFrom())) : new Failure(((Failure)fs2.head()).exception());
    }

    private Try<HttpRequest> setBodyOnAkka(RequestT<Object, ?, Source<ByteString, Object>> r, RequestBody<Source<ByteString, Object>> body, HttpRequest ar) {
        return this.parseContentTypeOrOctetStream(r).flatMap((Function1 & Serializable & scala.Serializable)ct -> {
            Success success;
            RequestBody requestBody = body;
            if (NoBody$.MODULE$.equals(requestBody)) {
                success = new Success((Object)ar);
            } else if (requestBody instanceof StringBody) {
                StringBody stringBody = (StringBody)requestBody;
                String b = stringBody.s();
                String encoding = stringBody.encoding();
                success = new Success((Object)ar.withEntity((ContentType)AkkaHttpBackend.ctWithEncoding$1(ct, encoding), b.getBytes(encoding)));
            } else if (requestBody instanceof ByteArrayBody) {
                ByteArrayBody byteArrayBody = (ByteArrayBody)requestBody;
                byte[] b = byteArrayBody.b();
                success = new Success((Object)ar.withEntity((RequestEntity)HttpEntity$.MODULE$.apply(ct, b)));
            } else if (requestBody instanceof ByteBufferBody) {
                ByteBufferBody byteBufferBody = (ByteBufferBody)requestBody;
                ByteBuffer b = byteBufferBody.b();
                success = new Success((Object)ar.withEntity((RequestEntity)HttpEntity$.MODULE$.apply(ct, ByteString$.MODULE$.apply(b))));
            } else if (requestBody instanceof InputStreamBody) {
                InputStreamBody inputStreamBody = (InputStreamBody)requestBody;
                InputStream b = inputStreamBody.b();
                success = new Success((Object)ar.withEntity((RequestEntity)HttpEntity$.MODULE$.apply(ct, StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable & scala.Serializable)() -> b, StreamConverters$.MODULE$.fromInputStream$default$2()))));
            } else if (requestBody instanceof FileBody) {
                FileBody fileBody = (FileBody)requestBody;
                SttpFile b = fileBody.f();
                success = new Success((Object)ar.withEntity((ContentType)ct, b.toPath()));
            } else if (requestBody instanceof StreamBody) {
                StreamBody streamBody = (StreamBody)requestBody;
                Source s = (Source)streamBody.s();
                success = new Success((Object)ar.withEntity((RequestEntity)HttpEntity$.MODULE$.apply(ct, s)));
            } else if (requestBody instanceof MultipartBody) {
                MultipartBody multipartBody = (MultipartBody)requestBody;
                scala.collection.immutable.Seq ps = multipartBody.parts();
                success = this.traverseTry((scala.collection.immutable.Seq)ps.map((Function1 & Serializable & scala.Serializable)mp -> this.toBodyPart$1((Multipart)mp), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)bodyParts -> ar.withEntity(Multipart.FormData$.MODULE$.apply((Seq)bodyParts).toEntity()));
            } else {
                throw new MatchError((Object)requestBody);
            }
            return success;
        });
    }

    private Try<akka.http.scaladsl.model.ContentType> parseContentTypeOrOctetStream(RequestT<Object, ?, Source<ByteString, Object>> r) {
        return this.parseContentTypeOrOctetStream((Option<String>)r.headers().find((Function1 & Serializable & scala.Serializable)header -> BoxesRunTime.boxToBoolean((boolean)this.isContentType((Tuple2<String, String>)header))).map((Function1 & Serializable & scala.Serializable)x$19 -> (String)x$19._2()));
    }

    private Try<akka.http.scaladsl.model.ContentType> parseContentTypeOrOctetStream(Option<String> ctHeader) {
        return (Try)ctHeader.map((Function1 & Serializable & scala.Serializable)ct -> (Try)ContentType$.MODULE$.parse(ct).fold((Function1 & Serializable & scala.Serializable)errors -> new Failure((Throwable)new RuntimeException(new StringBuilder(27).append("Cannot parse content type: ").append(errors).toString())), (Function1 & Serializable & scala.Serializable)x$20 -> new Success(x$20))).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Success((Object)ContentTypes$.MODULE$.application$divoctet$minusstream()));
    }

    private boolean isContentType(Tuple2<String, String> header) {
        return ((String)header._1()).toLowerCase().contains(Content$minusType$.MODULE$.lowercaseName());
    }

    private boolean isContentLength(Tuple2<String, String> header) {
        return ((String)header._1()).toLowerCase().contains(Content$minusLength$.MODULE$.lowercaseName());
    }

    private HttpResponse decodeAkkaResponse(HttpResponse response) {
        Gzip$ gzip$;
        HttpEncoding httpEncoding = response.encoding();
        HttpEncoding httpEncoding2 = HttpEncodings$.MODULE$.gzip();
        HttpEncoding httpEncoding3 = httpEncoding;
        if (!(httpEncoding2 != null ? !httpEncoding2.equals(httpEncoding3) : httpEncoding3 != null)) {
            gzip$ = Gzip$.MODULE$;
        } else {
            HttpEncoding httpEncoding4 = HttpEncodings$.MODULE$.deflate();
            HttpEncoding httpEncoding5 = httpEncoding;
            if (!(httpEncoding4 != null ? !httpEncoding4.equals(httpEncoding5) : httpEncoding5 != null)) {
                gzip$ = Deflate$.MODULE$;
            } else {
                HttpEncoding httpEncoding6 = HttpEncodings$.MODULE$.identity();
                HttpEncoding httpEncoding7 = httpEncoding;
                if (!(httpEncoding6 != null ? !httpEncoding6.equals(httpEncoding7) : httpEncoding7 != null)) {
                    gzip$ = NoCoding$.MODULE$;
                } else {
                    throw new UnsupportedEncodingException(new StringBuilder(22).append("Unsupported encoding: ").append(httpEncoding).toString());
                }
            }
        }
        Gzip$ decoder = gzip$;
        return (HttpResponse)decoder.decodeMessage((HttpMessage)response);
    }

    public void close() {
        block0: {
            if (!this.terminateActorSystemOnClose) break block0;
            this.actorSystem.terminate();
        }
    }

    private <T> RichTry<T> RichTry(Try<T> t) {
        return new RichTry<T>(this, t);
    }

    public static final /* synthetic */ boolean $anonfun$send$7(Tuple2 x$4) {
        Object object = x$4._1();
        String string = HeaderNames$.MODULE$.ContentType();
        return !(object != null ? !object.equals(string) : string != null);
    }

    private final Future asByteArray$1(HttpResponse hr$1, ExecutionContext ec$2) {
        return hr$1.entity().dataBytes().runFold((Object)ByteString$.MODULE$.apply(""), (Function2 & Serializable & scala.Serializable)(x$9, x$10) -> x$9.$plus$plus(x$10), (Materializer)this.materializer()).map((Function1 & Serializable & scala.Serializable)x$11 -> (byte[])x$11.toArray(ClassTag$.MODULE$.Byte()), ec$2);
    }

    private final Future saved$1(File file, boolean overwrite, HttpResponse hr$1) {
        Object object;
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            object = BoxesRunTime.boxToBoolean((boolean)file.createNewFile());
        } else {
            if (!overwrite) {
                throw new IOException(new StringBuilder(37).append("File ").append(file.getAbsolutePath()).append(" exists - overwriting prohibited").toString());
            }
            object = BoxedUnit.UNIT;
        }
        return (Future)hr$1.entity().dataBytes().runWith((Graph)FileIO$.MODULE$.toPath(file.toPath(), FileIO$.MODULE$.toPath$default$2()), (Materializer)this.materializer());
    }

    private static final akka.http.scaladsl.model.ContentType ctWithEncoding$1(akka.http.scaladsl.model.ContentType ct, String encoding) {
        return (akka.http.scaladsl.model.ContentType)HttpCharsets$.MODULE$.getForKey((Object)encoding).map((Function1 & Serializable & scala.Serializable)hc -> ContentType$.MODULE$.apply(ct.mediaType(), (Function0 & Serializable & scala.Serializable)() -> hc)).getOrElse((Function0 & Serializable & scala.Serializable)() -> ct);
    }

    private static final BodyPartEntity entity$1(akka.http.scaladsl.model.ContentType ct, Multipart mp$1) {
        HttpEntity.Strict strict;
        BasicRequestBody basicRequestBody = mp$1.body();
        if (basicRequestBody instanceof StringBody) {
            StringBody stringBody = (StringBody)basicRequestBody;
            String b = stringBody.s();
            String encoding = stringBody.encoding();
            strict = HttpEntity$.MODULE$.apply(AkkaHttpBackend.ctWithEncoding$1(ct, encoding), b.getBytes(encoding));
        } else if (basicRequestBody instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = (ByteArrayBody)basicRequestBody;
            byte[] b = byteArrayBody.b();
            strict = HttpEntity$.MODULE$.apply(ct, b);
        } else if (basicRequestBody instanceof ByteBufferBody) {
            ByteBufferBody byteBufferBody = (ByteBufferBody)basicRequestBody;
            ByteBuffer b = byteBufferBody.b();
            strict = HttpEntity$.MODULE$.apply(ct, ByteString$.MODULE$.apply(b));
        } else if (basicRequestBody instanceof InputStreamBody) {
            InputStreamBody inputStreamBody = (InputStreamBody)basicRequestBody;
            strict = new HttpEntity.IndefiniteLength(ct, StreamConverters$.MODULE$.fromInputStream((Function0 & Serializable & scala.Serializable)() -> inputStreamBody.b(), StreamConverters$.MODULE$.fromInputStream$default$2()));
        } else if (basicRequestBody instanceof FileBody) {
            FileBody fileBody = (FileBody)basicRequestBody;
            SttpFile b = fileBody.f();
            strict = HttpEntity$.MODULE$.fromPath(ct, b.toPath(), HttpEntity$.MODULE$.fromPath$default$3());
        } else {
            throw new MatchError((Object)basicRequestBody);
        }
        return strict;
    }

    private final Try toBodyPart$1(Multipart mp) {
        return this.parseContentTypeOrOctetStream((Option<String>)mp.contentType()).flatMap((Function1 & Serializable & scala.Serializable)ct -> this.headersToAkka((scala.collection.immutable.Seq<Tuple2<String, String>>)mp.additionalHeaders().toList()).map((Function1 & Serializable & scala.Serializable)headers -> {
            Map dispositionParams = (Map)mp.fileName().fold((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty(), (Function1 & Serializable & scala.Serializable)fn -> (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filename"), fn)})));
            return Multipart.FormData$.BodyPart$.MODULE$.apply(mp.name(), AkkaHttpBackend.entity$1(ct, mp), dispositionParams, headers);
        }));
    }

    public AkkaHttpBackend(ActorSystem actorSystem, ExecutionContext ec, boolean terminateActorSystemOnClose, SttpBackendOptions opts, Option<HttpsConnectionContext> customHttpsContext, Option<ConnectionPoolSettings> customConnectionPoolSettings, Option<LoggingAdapter> customLog) {
        this.actorSystem = actorSystem;
        this.ec = ec;
        this.terminateActorSystemOnClose = terminateActorSystemOnClose;
        this.opts = opts;
        this.customHttpsContext = customHttpsContext;
        this.customLog = customLog;
        this.as = actorSystem;
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 1);
        this.materializer = ActorMaterializer$.MODULE$.apply(ActorMaterializer$.MODULE$.apply$default$1(), ActorMaterializer$.MODULE$.apply$default$2(), (ActorRefFactory)this.as());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 2);
        this.http = Http$.MODULE$.apply(this.as());
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 4);
        this.connectionPoolSettings = ((ConnectionPoolSettings)customConnectionPoolSettings.getOrElse((Function0 & Serializable & scala.Serializable)() -> (ConnectionPoolSettings)ConnectionPoolSettings$.MODULE$.apply($this.actorSystem))).withUpdatedConnectionSettings((Function1 & Serializable & scala.Serializable)x$1 -> x$1.withConnectingTimeout($this.opts.connectionTimeout()));
        this.bitmap$init$0 = (byte)(this.bitmap$init$0 | 8);
    }

    public class RichTry<T> {
        private final Try<T> t;
        public final /* synthetic */ AkkaHttpBackend $outer;

        public Future<T> toFuture() {
            Future future;
            Try<T> try_ = this.t;
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object v = success.value();
                future = Future$.MODULE$.successful(v);
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable v = failure.exception();
                future = Future$.MODULE$.failed(v);
            } else {
                throw new MatchError(try_);
            }
            return future;
        }

        public /* synthetic */ AkkaHttpBackend com$softwaremill$sttp$akkahttp$AkkaHttpBackend$RichTry$$$outer() {
            return this.$outer;
        }

        public RichTry(AkkaHttpBackend $outer, Try<T> t) {
            this.t = t;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

