/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.elastic4s.streams;

import akka.actor.ActorRefFactory;
import com.sksamuel.elastic4s.ElasticClient;
import com.sksamuel.elastic4s.requests.searches.SearchHit;
import com.sksamuel.elastic4s.requests.searches.SearchRequest;
import com.sksamuel.elastic4s.streams.ScrollSubscription;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.Predef$;

public class ScrollPublisher
implements Publisher<SearchHit> {
    private final ElasticClient client;
    private final SearchRequest search;
    private final long maxItems;
    private final ActorRefFactory actorRefFactory;

    public ScrollPublisher(ElasticClient client, SearchRequest search, long maxItems, ActorRefFactory actorRefFactory) {
        this.client = client;
        this.search = search;
        this.maxItems = maxItems;
        this.actorRefFactory = actorRefFactory;
        Predef$.MODULE$.require(search.keepAlive().isDefined(), ScrollPublisher::$init$$$anonfun$1);
    }

    public void subscribe(Subscriber<? super SearchHit> s) {
        if (s == null) {
            throw new NullPointerException("Rule 1.9: Subscriber cannot be null");
        }
        ScrollSubscription subscription = new ScrollSubscription(this.client, this.search, s, this.maxItems, this.actorRefFactory);
        s.onSubscribe((Subscription)subscription);
        subscription.ready();
    }

    private static final String $init$$$anonfun$1() {
        return "Search Definition must have a scroll to be used as Publisher";
    }
}

