/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.elastic4s.streams;

import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.actor.PoisonPill$;
import akka.actor.Props$;
import com.sksamuel.elastic4s.ElasticClient;
import com.sksamuel.elastic4s.streams.BulkActor;
import com.sksamuel.elastic4s.streams.BulkActor$Completed$;
import com.sksamuel.elastic4s.streams.RequestBuilder;
import com.sksamuel.elastic4s.streams.SubscriberConfig;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.reflect.ClassTag$;

public class BulkIndexingSubscriber<T>
implements Subscriber<T> {
    private final ElasticClient client;
    private final RequestBuilder<T> builder;
    private final SubscriberConfig<T> config;
    private final ActorRefFactory actorRefFactory;
    private ActorRef actor;

    public BulkIndexingSubscriber(ElasticClient client, RequestBuilder<T> builder, SubscriberConfig<T> config, ActorRefFactory actorRefFactory) {
        this.client = client;
        this.builder = builder;
        this.config = config;
        this.actorRefFactory = actorRefFactory;
    }

    public void onSubscribe(Subscription sub) {
        if (sub == null) {
            throw new NullPointerException();
        }
        if (this.actor == null) {
            this.actor = this.actorRefFactory.actorOf(Props$.MODULE$.apply(() -> this.onSubscribe$$anonfun$1(sub), ClassTag$.MODULE$.apply(BulkActor.class)));
            return;
        }
        sub.cancel();
    }

    public void onNext(T t) {
        if (t == null) {
            throw new NullPointerException("On next should not be called until onSubscribe has returned");
        }
        ActorRef actorRef = this.actor;
        actorRef.$bang(t, actorRef.$bang$default$2(t));
    }

    public void onError(Throwable t) {
        if (t == null) {
            throw new NullPointerException();
        }
        ActorRef actorRef = this.actor;
        actorRef.$bang((Object)t, actorRef.$bang$default$2((Object)t));
    }

    public void onComplete() {
        ActorRef actorRef = this.actor;
        BulkActor$Completed$ bulkActor$Completed$ = BulkActor$Completed$.MODULE$;
        actorRef.$bang((Object)bulkActor$Completed$, actorRef.$bang$default$2((Object)bulkActor$Completed$));
    }

    public void close() {
        ActorRef actorRef = this.actor;
        actorRef.$bang((Object)PoisonPill$.MODULE$, actorRef.$bang$default$2((Object)PoisonPill$.MODULE$));
    }

    private final BulkActor onSubscribe$$anonfun$1(Subscription sub$1) {
        return new BulkActor<T>(this.client, sub$1, this.builder, this.config);
    }
}

