/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.elastic4s.streams;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorRef;
import akka.actor.Cancellable;
import com.fasterxml.jackson.module.scala.JavaTypeable$;
import com.sksamuel.elastic4s.CommonRequestOptions$;
import com.sksamuel.elastic4s.ElasticClient;
import com.sksamuel.elastic4s.ElasticDsl$;
import com.sksamuel.elastic4s.Executor$;
import com.sksamuel.elastic4s.Functor$;
import com.sksamuel.elastic4s.Handler;
import com.sksamuel.elastic4s.RequestFailure;
import com.sksamuel.elastic4s.RequestSuccess;
import com.sksamuel.elastic4s.RequestSuccess$;
import com.sksamuel.elastic4s.Response;
import com.sksamuel.elastic4s.requests.bulk.BulkRequest;
import com.sksamuel.elastic4s.requests.bulk.BulkRequest$;
import com.sksamuel.elastic4s.requests.bulk.BulkResponse;
import com.sksamuel.elastic4s.requests.bulk.BulkResponseItem;
import com.sksamuel.elastic4s.requests.common.RefreshPolicy;
import com.sksamuel.elastic4s.requests.common.RefreshPolicy$;
import com.sksamuel.elastic4s.streams.BulkActor$Completed$;
import com.sksamuel.elastic4s.streams.BulkActor$FailedResult$;
import com.sksamuel.elastic4s.streams.BulkActor$ForceIndexing$;
import com.sksamuel.elastic4s.streams.BulkActor$Request$;
import com.sksamuel.elastic4s.streams.BulkActor$Result$;
import com.sksamuel.elastic4s.streams.BulkActor$Send$;
import com.sksamuel.elastic4s.streams.RequestBuilder;
import com.sksamuel.elastic4s.streams.SubscriberConfig;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.reactivestreams.Subscription;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public class BulkActor<T>
implements Actor {
    private ActorContext context;
    private ActorRef self;
    private final ElasticClient client;
    public final Subscription com$sksamuel$elastic4s$streams$BulkActor$$subscription;
    private final RequestBuilder<T> builder;
    public final SubscriberConfig<T> com$sksamuel$elastic4s$streams$BulkActor$$config;
    public final ArrayBuffer<T> com$sksamuel$elastic4s$streams$BulkActor$$buffer;
    public boolean com$sksamuel$elastic4s$streams$BulkActor$$completed;
    public long com$sksamuel$elastic4s$streams$BulkActor$$requested;
    private long sent;
    public long com$sksamuel$elastic4s$streams$BulkActor$$confirmed;
    public long com$sksamuel$elastic4s$streams$BulkActor$$failed;
    private final Option<Cancellable> flushIntervalScheduler;
    private Option<Cancellable> flushAfterScheduler;

    public BulkActor(ElasticClient client, Subscription subscription, RequestBuilder<T> builder, SubscriberConfig<T> config) {
        this.client = client;
        this.com$sksamuel$elastic4s$streams$BulkActor$$subscription = subscription;
        this.builder = builder;
        this.com$sksamuel$elastic4s$streams$BulkActor$$config = config;
        Actor.$init$((Actor)this);
        this.com$sksamuel$elastic4s$streams$BulkActor$$buffer = new ArrayBuffer();
        this.com$sksamuel$elastic4s$streams$BulkActor$$buffer.sizeHint(config.batchSize());
        this.com$sksamuel$elastic4s$streams$BulkActor$$completed = false;
        this.com$sksamuel$elastic4s$streams$BulkActor$$requested = 0L;
        this.sent = 0L;
        this.com$sksamuel$elastic4s$streams$BulkActor$$confirmed = 0L;
        this.com$sksamuel$elastic4s$streams$BulkActor$$failed = 0L;
        this.flushIntervalScheduler = config.flushInterval().map((Function1 & Serializable)interval -> this.context().system().scheduler().schedule(interval, interval, this.self(), (Object)BulkActor$ForceIndexing$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self()));
        this.flushAfterScheduler = None$.MODULE$;
        Statics.releaseFence();
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    public void akka$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    public void com$sksamuel$elastic4s$streams$BulkActor$$resetFlushAfterScheduler() {
        this.flushAfterScheduler.foreach((Function1 & Serializable)_$2 -> _$2.cancel());
        this.flushAfterScheduler = this.com$sksamuel$elastic4s$streams$BulkActor$$config.flushAfter().map((Function1 & Serializable)interval -> this.context().system().scheduler().scheduleOnce(interval, this.self(), (Object)BulkActor$ForceIndexing$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self()));
    }

    public void preStart() {
        this.self().$bang((Object)BulkActor$Request$.MODULE$.apply(this.com$sksamuel$elastic4s$streams$BulkActor$$config.batchSize() * this.com$sksamuel$elastic4s$streams$BulkActor$$config.concurrentRequests()), this.self());
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ BulkActor $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof Throwable) {
                    Throwable t = (Throwable)object;
                    return true;
                }
                if (BulkActor$Completed$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof Request) {
                    int n;
                    Request request = BulkActor$Request$.MODULE$.unapply((Request)object);
                    int n2 = n = request._1();
                    return true;
                }
                if (object instanceof Send) {
                    Send msg = (Send)object;
                    return true;
                }
                if (BulkActor$ForceIndexing$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof Result) {
                    Result msg = (Result)object;
                    return true;
                }
                if (object instanceof FailedResult) {
                    FailedResult msg = (FailedResult)object;
                    return true;
                }
                if (object instanceof Object) {
                    Object t = object;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof Throwable) {
                    Throwable t = (Throwable)object;
                    this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$handleError(t);
                    return BoxedUnit.UNIT;
                }
                if (BulkActor$Completed$.MODULE$.equals(object)) {
                    if (this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$buffer.nonEmpty()) {
                        this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$index();
                    }
                    this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$completed = true;
                    this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$shutdownIfAllConfirmed();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Request) {
                    int n;
                    Request request = BulkActor$Request$.MODULE$.unapply((Request)object);
                    int n2 = n = request._1();
                    this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$subscription.request(Int$.MODULE$.int2long(n2));
                    this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$requested += (long)n2;
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Send) {
                    Send msg = (Send)object;
                    this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$send(msg.req(), msg.originals(), msg.attempts());
                    return BoxedUnit.UNIT;
                }
                if (BulkActor$ForceIndexing$.MODULE$.equals(object)) {
                    if (this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$buffer.nonEmpty()) {
                        this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$index();
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Result) {
                    Result msg = (Result)object;
                    this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$confirmed += (long)msg.items().size();
                    ((IterableOnceOps)msg.items().zip(msg.originals())).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            BulkResponseItem item = (BulkResponseItem)tuple2._1();
                            Object original = tuple2._2();
                            this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$config.listener().onAck(item, original);
                            return;
                        }
                        throw new MatchError((Object)tuple2);
                    });
                    this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$checkCompleteOrRequestNext(msg.items().size(), msg.requestNext());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof FailedResult) {
                    FailedResult msg = (FailedResult)object;
                    this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$failed += (long)msg.items().size();
                    ((IterableOnceOps)msg.items().zip(msg.originals())).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            BulkResponseItem item = (BulkResponseItem)tuple2._1();
                            Object original = tuple2._2();
                            this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$config.listener().onFailure(item, original);
                            return;
                        }
                        throw new MatchError((Object)tuple2);
                    });
                    this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$checkCompleteOrRequestNext(msg.items().size(), msg.requestNext());
                    return BoxedUnit.UNIT;
                }
                if (object instanceof Object) {
                    Object t = object;
                    this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$buffer.append(t);
                    if (this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$buffer.size() == this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$config.batchSize()) {
                        this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$index();
                        return BoxedUnit.UNIT;
                    }
                    this.$outer.com$sksamuel$elastic4s$streams$BulkActor$$resetFlushAfterScheduler();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(scala.Tuple2 ), applyOrElse$$anonfun$2(scala.Tuple2 )}, serializedLambda);
            }
        };
    }

    public void com$sksamuel$elastic4s$streams$BulkActor$$checkCompleteOrRequestNext(int n, boolean requestNext) {
        if (this.com$sksamuel$elastic4s$streams$BulkActor$$completed) {
            this.com$sksamuel$elastic4s$streams$BulkActor$$shutdownIfAllConfirmed();
            return;
        }
        if (requestNext) {
            this.self().$bang((Object)BulkActor$Request$.MODULE$.apply(n), this.self());
            return;
        }
    }

    public void postStop() {
        this.flushIntervalScheduler.map((Function1 & Serializable)_$3 -> _$3.cancel());
        this.flushAfterScheduler.map((Function1 & Serializable)_$4 -> _$4.cancel());
        if (this.com$sksamuel$elastic4s$streams$BulkActor$$failed == 0L) {
            this.com$sksamuel$elastic4s$streams$BulkActor$$config.successFn().apply$mcV$sp();
        }
        this.com$sksamuel$elastic4s$streams$BulkActor$$config.completionFn().apply$mcV$sp();
    }

    public void com$sksamuel$elastic4s$streams$BulkActor$$shutdownIfAllConfirmed() {
        if (this.com$sksamuel$elastic4s$streams$BulkActor$$confirmed + this.com$sksamuel$elastic4s$streams$BulkActor$$failed == this.sent) {
            this.context().stop(this.self());
            return;
        }
    }

    public void com$sksamuel$elastic4s$streams$BulkActor$$send(BulkRequest req, Seq<T> originals, int attempts) {
        Predef$.MODULE$.require(req.requests().size() == originals.size(), BulkActor::send$$anonfun$1);
        Future f = (Future)this.client.execute((Object)req, Executor$.MODULE$.FutureExecutor((ExecutionContext)this.context().dispatcher()), Functor$.MODULE$.FutureFunctor((ExecutionContext)this.context().dispatcher()), (Handler)ElasticDsl$.MODULE$.BulkHandler(), JavaTypeable$.MODULE$.gen0JavaTypeable(ClassTag$.MODULE$.apply(BulkResponse.class)), CommonRequestOptions$.MODULE$.defaults());
        f.onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                this.self().$bang((Object)e, this.self());
                return;
            }
            if (try_ instanceof Success) {
                Response response2 = (Response)((Success)try_).value();
                if (response2 instanceof RequestFailure) {
                    RequestFailure failure2 = (RequestFailure)response2;
                    this.self().$bang((Object)new RuntimeException(failure2.toString()), this.self());
                    return;
                }
                if (response2 instanceof RequestSuccess) {
                    RequestSuccess requestSuccess = RequestSuccess$.MODULE$.unapply((RequestSuccess)response2);
                    int n = requestSuccess._1();
                    Option option = requestSuccess._2();
                    Map map = requestSuccess._3();
                    Object object = requestSuccess._4();
                    BulkResponse result = (BulkResponse)object;
                    if (result.hasSuccesses()) {
                        this.self().$bang(BulkActor$Result$.MODULE$.apply((Seq<BulkResponseItem>)result.successes(), (Seq)result.successes().map((Function1 & Serializable)response -> BulkActor.getOriginalForResponse$1(originals, response)), !result.errors()), this.self());
                    }
                    if (result.errors()) {
                        Seq seq;
                        if (attempts > 0) {
                            Tuple2 tuple2 = result.failures().partition((Function1 & Serializable)failure -> BoxesRunTime.unboxToBoolean((Object)this.com$sksamuel$elastic4s$streams$BulkActor$$config.retryFailure().apply(failure, BulkActor.getOriginalForResponse$1(originals, failure))));
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            Seq retriable = (Seq)tuple2._1();
                            Seq nonRetriable = (Seq)tuple2._2();
                            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)retriable, (Object)nonRetriable);
                            Seq retriable2 = (Seq)tuple22._1();
                            Seq nonRetriable2 = (Seq)tuple22._2();
                            if (retriable2.nonEmpty()) {
                                Tuple2 tuple23 = this.getRetryDef$1(req, originals, retriable2);
                                if (tuple23 == null) {
                                    throw new MatchError((Object)tuple23);
                                }
                                BulkRequest retryDef = (BulkRequest)tuple23._1();
                                Seq originals = (Seq)tuple23._2();
                                Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)retryDef, (Object)originals);
                                BulkRequest retryDef2 = (BulkRequest)tuple24._1();
                                Seq originals2 = (Seq)tuple24._2();
                                this.context().system().scheduler().scheduleOnce(this.com$sksamuel$elastic4s$streams$BulkActor$$config.failureWait(), this.self(), BulkActor$Send$.MODULE$.apply(retryDef2, originals2, attempts - 1), (ExecutionContext)this.context().dispatcher(), this.self());
                            }
                            seq = nonRetriable2;
                        } else {
                            seq = result.failures();
                        }
                        Seq failures = seq;
                        this.self().$bang(BulkActor$FailedResult$.MODULE$.apply((Seq<BulkResponseItem>)failures, (Seq)failures.map((Function1 & Serializable)response -> BulkActor.getOriginalForResponse$1(originals, response)), attempts == 0), this.self());
                        return;
                    }
                    return;
                }
            }
            throw new MatchError((Object)try_);
        }, (ExecutionContext)this.context().dispatcher());
    }

    public void com$sksamuel$elastic4s$streams$BulkActor$$handleError(Throwable t) {
        this.com$sksamuel$elastic4s$streams$BulkActor$$subscription.cancel();
        this.com$sksamuel$elastic4s$streams$BulkActor$$config.errorFn().apply((Object)t);
        this.com$sksamuel$elastic4s$streams$BulkActor$$buffer.clear();
        this.context().stop(this.self());
    }

    public void com$sksamuel$elastic4s$streams$BulkActor$$index() {
        this.sent += (long)this.com$sksamuel$elastic4s$streams$BulkActor$$buffer.size();
        this.self().$bang(BulkActor$Send$.MODULE$.apply(this.bulkDef$1(), this.com$sksamuel$elastic4s$streams$BulkActor$$buffer.toList(), this.com$sksamuel$elastic4s$streams$BulkActor$$config.maxAttempts()), this.self());
        this.com$sksamuel$elastic4s$streams$BulkActor$$buffer.clear();
        this.flushAfterScheduler.foreach((Function1 & Serializable)_$6 -> _$6.cancel());
        this.flushAfterScheduler = None$.MODULE$;
    }

    private static final String send$$anonfun$1() {
        return "Requests size does not match originals size";
    }

    private static final Seq filterByIndexes$1(Seq sequence, Set indexes) {
        return (Seq)((IterableOps)((IterableOps)sequence.zipWithIndex()).filter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return indexes.contains((Object)BoxesRunTime.boxToInteger((int)index));
            }
            throw new MatchError((Object)tuple2);
        })).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object seqItem = tuple2._1();
                return seqItem;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private static final Object getOriginalForResponse$1(Seq originals$1, BulkResponseItem response) {
        return originals$1.apply(response.itemId());
    }

    private final Tuple2 getRetryDef$1(BulkRequest req$1, Seq originals$2, Seq failures) {
        RefreshPolicy policy = (RefreshPolicy)(this.com$sksamuel$elastic4s$streams$BulkActor$$config.refreshAfterOp() ? RefreshPolicy.Immediate$.MODULE$ : RefreshPolicy$.MODULE$.NONE());
        Set failureIds = ((IterableOnceOps)failures.map((Function1 & Serializable)_$5 -> _$5.itemId())).toSet();
        Seq retryOriginals = BulkActor.filterByIndexes$1(originals$2, failureIds);
        Seq failedReqs = BulkActor.filterByIndexes$1(req$1.requests(), failureIds);
        return Tuple2$.MODULE$.apply((Object)BulkRequest$.MODULE$.apply(failedReqs, BulkRequest$.MODULE$.$lessinit$greater$default$2(), BulkRequest$.MODULE$.$lessinit$greater$default$3()).refresh(policy), (Object)retryOriginals);
    }

    private final BulkRequest bulkDef$1() {
        Seq defs = ((IterableOnceOps)this.com$sksamuel$elastic4s$streams$BulkActor$$buffer.map((Function1 & Serializable)t -> this.builder.request(t))).toSeq();
        RefreshPolicy policy = (RefreshPolicy)(this.com$sksamuel$elastic4s$streams$BulkActor$$config.refreshAfterOp() ? RefreshPolicy.Immediate$.MODULE$ : RefreshPolicy$.MODULE$.NONE());
        return BulkRequest$.MODULE$.apply(defs, BulkRequest$.MODULE$.$lessinit$greater$default$2(), BulkRequest$.MODULE$.$lessinit$greater$default$3()).refresh(policy);
    }

    public static class FailedResult<T>
    implements Product,
    Serializable {
        private final Seq items;
        private final Seq originals;
        private final boolean requestNext;

        public static <T> FailedResult<T> apply(Seq<BulkResponseItem> seq, Seq<T> seq2, boolean bl) {
            return BulkActor$FailedResult$.MODULE$.apply(seq, seq2, bl);
        }

        public static FailedResult<?> fromProduct(Product product) {
            return BulkActor$FailedResult$.MODULE$.fromProduct(product);
        }

        public static <T> FailedResult<T> unapply(FailedResult<T> failedResult) {
            return BulkActor$FailedResult$.MODULE$.unapply(failedResult);
        }

        public FailedResult(Seq<BulkResponseItem> items, Seq<T> originals, boolean requestNext) {
            this.items = items;
            this.originals = originals;
            this.requestNext = requestNext;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.items()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.originals()));
            n = Statics.mix((int)n, (int)(this.requestNext() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FailedResult)) return false;
            FailedResult failedResult = (FailedResult)object;
            if (this.requestNext() != failedResult.requestNext()) return false;
            Seq<BulkResponseItem> seq = this.items();
            Seq<BulkResponseItem> seq2 = failedResult.items();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<T> seq3 = this.originals();
            Seq<T> seq4 = failedResult.originals();
            if (seq3 == null) {
                if (seq4 != null) {
                    return false;
                }
            } else if (!seq3.equals(seq4)) return false;
            if (!failedResult.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FailedResult;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "FailedResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "items";
                }
                case 1: {
                    return "originals";
                }
                case 2: {
                    return "requestNext";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Seq<BulkResponseItem> items() {
            return this.items;
        }

        public Seq<T> originals() {
            return this.originals;
        }

        public boolean requestNext() {
            return this.requestNext;
        }

        public <T> FailedResult<T> copy(Seq<BulkResponseItem> items, Seq<T> originals, boolean requestNext) {
            return new FailedResult<T>(items, originals, requestNext);
        }

        public <T> Seq<BulkResponseItem> copy$default$1() {
            return this.items();
        }

        public <T> Seq<T> copy$default$2() {
            return this.originals();
        }

        public boolean copy$default$3() {
            return this.requestNext();
        }

        public Seq<BulkResponseItem> _1() {
            return this.items();
        }

        public Seq<T> _2() {
            return this.originals();
        }

        public boolean _3() {
            return this.requestNext();
        }
    }

    public static class Request
    implements Product,
    Serializable {
        private final int n;

        public static Request apply(int n) {
            return BulkActor$Request$.MODULE$.apply(n);
        }

        public static Request fromProduct(Product product) {
            return BulkActor$Request$.MODULE$.fromProduct(product);
        }

        public static Request unapply(Request request) {
            return BulkActor$Request$.MODULE$.unapply(request);
        }

        public Request(int n) {
            this.n = n;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.n());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Request)) return false;
            Request request = (Request)object;
            if (this.n() != request.n()) return false;
            if (!request.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Request;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Request";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "n";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int n() {
            return this.n;
        }

        public Request copy(int n) {
            return new Request(n);
        }

        public int copy$default$1() {
            return this.n();
        }

        public int _1() {
            return this.n();
        }
    }

    public static class Result<T>
    implements Product,
    Serializable {
        private final Seq items;
        private final Seq originals;
        private final boolean requestNext;

        public static <T> Result<T> apply(Seq<BulkResponseItem> seq, Seq<T> seq2, boolean bl) {
            return BulkActor$Result$.MODULE$.apply(seq, seq2, bl);
        }

        public static Result<?> fromProduct(Product product) {
            return BulkActor$Result$.MODULE$.fromProduct(product);
        }

        public static <T> Result<T> unapply(Result<T> result) {
            return BulkActor$Result$.MODULE$.unapply(result);
        }

        public Result(Seq<BulkResponseItem> items, Seq<T> originals, boolean requestNext) {
            this.items = items;
            this.originals = originals;
            this.requestNext = requestNext;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.items()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.originals()));
            n = Statics.mix((int)n, (int)(this.requestNext() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Result)) return false;
            Result result = (Result)object;
            if (this.requestNext() != result.requestNext()) return false;
            Seq<BulkResponseItem> seq = this.items();
            Seq<BulkResponseItem> seq2 = result.items();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            Seq<T> seq3 = this.originals();
            Seq<T> seq4 = result.originals();
            if (seq3 == null) {
                if (seq4 != null) {
                    return false;
                }
            } else if (!seq3.equals(seq4)) return false;
            if (!result.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Result;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Result";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToBoolean((boolean)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "items";
                }
                case 1: {
                    return "originals";
                }
                case 2: {
                    return "requestNext";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Seq<BulkResponseItem> items() {
            return this.items;
        }

        public Seq<T> originals() {
            return this.originals;
        }

        public boolean requestNext() {
            return this.requestNext;
        }

        public <T> Result<T> copy(Seq<BulkResponseItem> items, Seq<T> originals, boolean requestNext) {
            return new Result<T>(items, originals, requestNext);
        }

        public <T> Seq<BulkResponseItem> copy$default$1() {
            return this.items();
        }

        public <T> Seq<T> copy$default$2() {
            return this.originals();
        }

        public boolean copy$default$3() {
            return this.requestNext();
        }

        public Seq<BulkResponseItem> _1() {
            return this.items();
        }

        public Seq<T> _2() {
            return this.originals();
        }

        public boolean _3() {
            return this.requestNext();
        }
    }

    public static class Send<T>
    implements Product,
    Serializable {
        private final BulkRequest req;
        private final Seq originals;
        private final int attempts;

        public static <T> Send<T> apply(BulkRequest bulkRequest, Seq<T> seq, int n) {
            return BulkActor$Send$.MODULE$.apply(bulkRequest, seq, n);
        }

        public static Send<?> fromProduct(Product product) {
            return BulkActor$Send$.MODULE$.fromProduct(product);
        }

        public static <T> Send<T> unapply(Send<T> send) {
            return BulkActor$Send$.MODULE$.unapply(send);
        }

        public Send(BulkRequest req, Seq<T> originals, int attempts) {
            this.req = req;
            this.originals = originals;
            this.attempts = attempts;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.req()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.originals()));
            n = Statics.mix((int)n, (int)this.attempts());
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Send)) return false;
            Send send = (Send)object;
            if (this.attempts() != send.attempts()) return false;
            BulkRequest bulkRequest = this.req();
            BulkRequest bulkRequest2 = send.req();
            if (bulkRequest == null) {
                if (bulkRequest2 != null) {
                    return false;
                }
            } else if (!bulkRequest.equals(bulkRequest2)) return false;
            Seq<T> seq = this.originals();
            Seq<T> seq2 = send.originals();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!send.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Send;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Send";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "req";
                }
                case 1: {
                    return "originals";
                }
                case 2: {
                    return "attempts";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public BulkRequest req() {
            return this.req;
        }

        public Seq<T> originals() {
            return this.originals;
        }

        public int attempts() {
            return this.attempts;
        }

        public <T> Send<T> copy(BulkRequest req, Seq<T> originals, int attempts) {
            return new Send<T>(req, originals, attempts);
        }

        public <T> BulkRequest copy$default$1() {
            return this.req();
        }

        public <T> Seq<T> copy$default$2() {
            return this.originals();
        }

        public int copy$default$3() {
            return this.attempts();
        }

        public BulkRequest _1() {
            return this.req();
        }

        public Seq<T> _2() {
            return this.originals();
        }

        public int _3() {
            return this.attempts();
        }
    }
}

