/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.elastic4s.http;

import com.sksamuel.elastic4s.ElasticProperties;
import com.sksamuel.elastic4s.ElasticRequest;
import com.sksamuel.elastic4s.ElasticRequest$;
import com.sksamuel.elastic4s.HttpClient;
import com.sksamuel.elastic4s.HttpEntity;
import com.sksamuel.elastic4s.HttpResponse;
import com.sksamuel.elastic4s.Show$;
import com.sksamuel.elastic4s.http.JavaClient$;
import com.sksamuel.elastic4s.http.JavaClientExceptionWrapper;
import com.sksamuel.exts.Logging;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.io.Codec;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005ub\u0001\u0002\b\u0010\u0001aA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\u0006[\u0001!\tA\f\u0005\u0006e\u0001!\ta\r\u0005\u0006\u0003\u0002!\tA\u0011\u0005\u0006\u0017\u0002!\t\u0005\u0014\u0005\u0006S\u0002!\tE\u001b\u0005\u0006W\u0002!I\u0001\\\u0004\u0006i>A\t!\u001e\u0004\u0006\u001d=A\tA\u001e\u0005\u0006[%!\t! \u0005\u0006}&!\ta \u0005\b\u0003\u0007IA\u0011AA\u0003\u0011\u001d\t\u0019!\u0003C\u0001\u0003#\u0011!BS1wC\u000ec\u0017.\u001a8u\u0015\t\u0001\u0012#\u0001\u0003iiR\u0004(B\u0001\n\u0014\u0003%)G.Y:uS\u000e$4O\u0003\u0002\u0015+\u0005A1o[:b[V,GNC\u0001\u0017\u0003\r\u0019w.\\\u0002\u0001'\r\u0001\u0011d\b\t\u00035ui\u0011a\u0007\u0006\u00029\u0005)1oY1mC&\u0011ad\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0001\nS\"A\t\n\u0005\t\n\"A\u0003%uiB\u001cE.[3oi\u000611\r\\5f]R\u0004\"!J\u0016\u000e\u0003\u0019R!aI\u0014\u000b\u0005!J\u0013!D3mCN$\u0018nY:fCJ\u001c\u0007NC\u0001+\u0003\ry'oZ\u0005\u0003Y\u0019\u0012!BU3ti\u000ec\u0017.\u001a8u\u0003\u0019a\u0014N\\5u}Q\u0011q&\r\t\u0003a\u0001i\u0011a\u0004\u0005\u0006G\t\u0001\r\u0001J\u0001\rCB\f7\r[3F]RLG/\u001f\u000b\u0003iu\u0002\"!N\u001e\u000e\u0003YR!a\u000e\u001d\u0002\r\u0015tG/\u001b;z\u0015\t\u0001\u0012H\u0003\u0002;S\u00051\u0011\r]1dQ\u0016L!\u0001\u0010\u001c\u0003%\u0005\u00137\u000f\u001e:bGRDE\u000f\u001e9F]RLG/\u001f\u0005\u0006o\r\u0001\rA\u0010\t\u0003A}J!\u0001Q\t\u0003\u0015!#H\u000f]#oi&$\u00180\u0001\u0007ge>l'+Z:q_:\u001cX\r\u0006\u0002D\rB\u0011\u0001\u0005R\u0005\u0003\u000bF\u0011A\u0002\u0013;uaJ+7\u000f]8og\u0016DQa\u0012\u0003A\u0002!\u000b\u0011A\u001d\t\u0003K%K!A\u0013\u0014\u0003\u0011I+7\u000f]8og\u0016\fAa]3oIR\u0019Q\nU+\u0011\u0005iq\u0015BA(\u001c\u0005\u0011)f.\u001b;\t\u000bE+\u0001\u0019\u0001*\u0002\u0007I,\u0017\u000f\u0005\u0002!'&\u0011A+\u0005\u0002\u000f\u000b2\f7\u000f^5d%\u0016\fX/Z:u\u0011\u00151V\u00011\u0001X\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0007\u0003\u0002\u000eY56K!!W\u000e\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003B.dM\u000es!\u0001X1\u000f\u0005u\u0003W\"\u00010\u000b\u0005};\u0012A\u0002\u001fs_>$h(C\u0001\u001d\u0013\t\u00117$A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0011,'AB#ji\",'O\u0003\u0002c7A\u00111lZ\u0005\u0003Q\u0016\u0014\u0011\u0002\u00165s_^\f'\r\\3\u0002\u000b\rdwn]3\u0015\u00035\u000ba\"[:F]RLG/_${SB,G\r\u0006\u0002naB\u0011!D\\\u0005\u0003_n\u0011qAQ8pY\u0016\fg\u000eC\u00038\u000f\u0001\u0007\u0011\u000f\u0005\u0002sg6\t\u0001(\u0003\u0002Aq\u0005Q!*\u0019<b\u00072LWM\u001c;\u0011\u0005AJ1cA\u0005\u001aoB\u0011\u0001p_\u0007\u0002s*\u0011!pE\u0001\u0005Kb$8/\u0003\u0002}s\n9Aj\\4hS:<G#A;\u0002\u001d\u0019\u0014x.\u001c*fgR\u001cE.[3oiR\u0019q&!\u0001\t\u000b\rZ\u0001\u0019\u0001\u0013\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007=\n9\u0001C\u0004\u0002\n1\u0001\r!a\u0003\u0002\u000bA\u0014x\u000e]:\u0011\u0007\u0001\ni!C\u0002\u0002\u0010E\u0011\u0011#\u00127bgRL7\r\u0015:pa\u0016\u0014H/[3t)\u001dy\u00131CA\u000b\u0003gAq!!\u0003\u000e\u0001\u0004\tY\u0001C\u0004\u0002\u00185\u0001\r!!\u0007\u0002+I,\u0017/^3ti\u000e{gNZ5h\u0007\u0006dGNY1dWB!\u00111DA\u0017\u001d\u0011\ti\"!\u000b\u000f\t\u0005}\u0011q\u0005\b\u0005\u0003C\t)CD\u0002^\u0003GI\u0011AK\u0005\u0003Q%J!aI\u0014\n\u0007\u0005-b%A\tSKN$8\t\\5f]R\u0014U/\u001b7eKJLA!a\f\u00022\t)\"+Z9vKN$8i\u001c8gS\u001e\u001c\u0015\r\u001c7cC\u000e\\'bAA\u0016M!9\u0011QG\u0007A\u0002\u0005]\u0012\u0001\u00075uiB\u001cE.[3oi\u000e{gNZ5h\u0007\u0006dGNY1dWB!\u00111DA\u001d\u0013\u0011\tY$!\r\u00031!#H\u000f]\"mS\u0016tGoQ8oM&<7)\u00197mE\u0006\u001c7\u000e")
public class JavaClient
implements HttpClient {
    private final RestClient client;
    private Logger logger;

    public static JavaClient apply(ElasticProperties elasticProperties, RestClientBuilder.RequestConfigCallback requestConfigCallback, RestClientBuilder.HttpClientConfigCallback httpClientConfigCallback) {
        return JavaClient$.MODULE$.apply(elasticProperties, requestConfigCallback, httpClientConfigCallback);
    }

    public static JavaClient apply(ElasticProperties elasticProperties) {
        return JavaClient$.MODULE$.apply(elasticProperties);
    }

    public static JavaClient fromRestClient(RestClient restClient) {
        return JavaClient$.MODULE$.fromRestClient(restClient);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$sksamuel$exts$Logging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public AbstractHttpEntity apacheEntity(HttpEntity entity) {
        ByteArrayEntity byteArrayEntity;
        HttpEntity httpEntity = entity;
        if (httpEntity instanceof HttpEntity.StringEntity) {
            HttpEntity.StringEntity stringEntity = (HttpEntity.StringEntity)httpEntity;
            this.logger().debug(stringEntity.content());
            byteArrayEntity = new StringEntity(stringEntity.content(), ContentType.APPLICATION_JSON);
        } else if (httpEntity instanceof HttpEntity.ByteArrayEntity) {
            HttpEntity.ByteArrayEntity byteArrayEntity2 = (HttpEntity.ByteArrayEntity)httpEntity;
            byteArrayEntity = new ByteArrayEntity(byteArrayEntity2.content(), ContentType.APPLICATION_JSON);
        } else if (httpEntity instanceof HttpEntity.InputStreamEntity) {
            HttpEntity.InputStreamEntity inputStreamEntity = (HttpEntity.InputStreamEntity)httpEntity;
            this.logger().debug(inputStreamEntity.content().toString());
            byteArrayEntity = new InputStreamEntity(inputStreamEntity.content(), ContentType.APPLICATION_JSON);
        } else if (httpEntity instanceof HttpEntity.FileEntity) {
            HttpEntity.FileEntity fileEntity = (HttpEntity.FileEntity)httpEntity;
            this.logger().debug(fileEntity.content().toString());
            byteArrayEntity = new FileEntity(fileEntity.content(), ContentType.APPLICATION_JSON);
        } else {
            throw new MatchError((Object)httpEntity);
        }
        return byteArrayEntity;
    }

    public HttpResponse fromResponse(Response r) {
        Option entity2 = Option$.MODULE$.apply((Object)r.getEntity()).map((Function1 & Serializable)entity -> {
            Charset contentCharset = (Charset)Option$.MODULE$.apply((Object)ContentType.get((org.apache.http.HttpEntity)entity)).fold((Function0 & Serializable)() -> Charset.forName("UTF-8"), (Function1 & Serializable)x$1 -> x$1.getCharset());
            Codec codec = Codec$.MODULE$.apply(contentCharset);
            InputStream contentStream = this.isEntityGziped((org.apache.http.HttpEntity)entity) ? new GZIPInputStream(entity.getContent()) : entity.getContent();
            String body = Source$.MODULE$.fromInputStream(contentStream, codec).mkString();
            return new HttpEntity.StringEntity(body, (Option)new Some((Object)contentCharset.name()));
        });
        Map headers = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])r.getHeaders()), (Function1 & Serializable)header -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)header.getName()), (Object)header.getValue()), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.logger().debug("Http Response {}", (Object)r);
        return new HttpResponse(r.getStatusLine().getStatusCode(), entity2, headers);
    }

    public void send(ElasticRequest req, Function1<Either<Throwable, HttpResponse>, BoxedUnit> callback) {
        if (this.logger().isDebugEnabled()) {
            this.logger().debug("Executing elastic request {}", (Object)Show$.MODULE$.apply(ElasticRequest$.MODULE$.ElasticRequestShow()).show((Object)req));
        }
        ResponseListener l = new ResponseListener(this, callback){
            private final /* synthetic */ JavaClient $outer;
            private final Function1 callback$1;

            public void onSuccess(Response r) {
                this.callback$1.apply((Object)package$.MODULE$.Right().apply((Object)this.$outer.fromResponse(r)));
            }

            public void onFailure(Exception e) {
                Exception exception = e;
                if (exception instanceof ResponseException) {
                    ResponseException responseException = (ResponseException)exception;
                    BoxedUnit boxedUnit = (BoxedUnit)this.callback$1.apply((Object)package$.MODULE$.Right().apply((Object)this.$outer.fromResponse(responseException.getResponse())));
                } else {
                    BoxedUnit boxedUnit = (BoxedUnit)this.callback$1.apply((Object)package$.MODULE$.Left().apply((Object)new JavaClientExceptionWrapper(exception)));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.callback$1 = callback$1;
            }
        };
        Request request = new Request(req.method(), req.endpoint());
        req.params().foreach((Function1 & Serializable)x0$1 -> {
            JavaClient.$anonfun$send$1(request, x0$1);
            return BoxedUnit.UNIT;
        });
        req.entity().map((Function1 & Serializable)entity -> this.apacheEntity((HttpEntity)entity)).foreach((Function1 & Serializable)x$1 -> {
            request.setEntity(x$1);
            return BoxedUnit.UNIT;
        });
        this.client.performRequestAsync(request, l);
    }

    public void close() {
        this.client.close();
    }

    private boolean isEntityGziped(org.apache.http.HttpEntity entity) {
        return Option$.MODULE$.apply((Object)entity.getContentEncoding()).flatMap((Function1 & Serializable)x -> Option$.MODULE$.apply((Object)x.getValue())).contains((Object)"gzip");
    }

    public static final /* synthetic */ void $anonfun$send$1(Request request$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        request$1.addParameter(key, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public JavaClient(RestClient client) {
        this.client = client;
        Logging.$init$((Logging)this);
        Statics.releaseFence();
    }
}

