/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.LogicalExpression;
import com.redhat.lightblue.query.QueryExpression;
import com.redhat.lightblue.query.UnaryLogicalOperator;
import com.redhat.lightblue.util.Error;

public class UnaryLogicalExpression
extends LogicalExpression {
    private static final long serialVersionUID = 1L;
    private final UnaryLogicalOperator op;
    private final QueryExpression query;

    public UnaryLogicalExpression(UnaryLogicalOperator op, QueryExpression query) {
        this.op = op;
        this.query = query;
    }

    public UnaryLogicalOperator getOp() {
        return this.op;
    }

    public QueryExpression getQuery() {
        return this.query;
    }

    public JsonNode toJson() {
        return UnaryLogicalExpression.getFactory().objectNode().set(this.op.toString(), this.query.toJson());
    }

    public static UnaryLogicalExpression fromJson(ObjectNode node) {
        if (node.size() != 1) {
            throw Error.get((String)"query-api:InvalidLogicalExpression", (String)node.toString());
        }
        String fieldName = (String)node.fieldNames().next();
        UnaryLogicalOperator op = UnaryLogicalOperator.fromString(fieldName);
        if (op == null) {
            throw Error.get((String)"query-api:InvalidLogicalExpression", (String)node.toString());
        }
        QueryExpression q = QueryExpression.fromJson(node.get(fieldName));
        return new UnaryLogicalExpression(op, q);
    }
}

