/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.CompositeSortKey;
import com.redhat.lightblue.query.SortKey;
import com.redhat.lightblue.util.JsonObject;
import com.redhat.lightblue.util.Path;

public abstract class Sort
extends JsonObject {
    private static final long serialVersionUID = 1L;

    public static Sort fromJson(JsonNode node) {
        if (node instanceof ArrayNode) {
            return CompositeSortKey.fromJson((ArrayNode)node);
        }
        return SortKey.fromJson((ObjectNode)node);
    }

    public boolean isRequired(Path field) {
        return this.isRequired(field, Path.EMPTY);
    }

    public boolean isRequired(Path field, Path ctx) {
        if (this instanceof SortKey) {
            return Sort.isRequired(field, (SortKey)this, ctx);
        }
        if (this instanceof CompositeSortKey) {
            return Sort.isRequired(field, (CompositeSortKey)this, ctx);
        }
        return false;
    }

    private static boolean isRequired(Path field, CompositeSortKey sort, Path ctx) {
        for (SortKey key : sort.getKeys()) {
            if (!Sort.isRequired(field, key, ctx)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRequired(Path field, SortKey sort, Path ctx) {
        Path absField = new Path(ctx, field);
        return sort.getField().matchingPrefix(absField);
    }
}

