/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.FieldAndRValue;
import com.redhat.lightblue.query.PrimitiveUpdateExpression;
import com.redhat.lightblue.query.RValueExpression;
import com.redhat.lightblue.query.UpdateOperator;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SetExpression
extends PrimitiveUpdateExpression {
    private static final long serialVersionUID = 1L;
    private final List<FieldAndRValue> fields;
    private UpdateOperator op;

    public SetExpression(UpdateOperator op, List<FieldAndRValue> list) {
        this.fields = list;
        if (op != UpdateOperator._set && op != UpdateOperator._add) {
            throw new IllegalArgumentException("query-api:UnsupportedOperator" + (Object)((Object)op));
        }
        this.op = op;
    }

    public SetExpression(UpdateOperator op, FieldAndRValue ... l) {
        this.fields = Arrays.asList(l);
        if (op != UpdateOperator._set && op != UpdateOperator._add) {
            throw new IllegalArgumentException("query-api:UnsupportedOperator" + (Object)((Object)op));
        }
        this.op = op;
    }

    public List<FieldAndRValue> getFields() {
        return this.fields;
    }

    public UpdateOperator getOp() {
        return this.op;
    }

    public JsonNode toJson() {
        ObjectNode node = SetExpression.getFactory().objectNode();
        ObjectNode values = SetExpression.getFactory().objectNode();
        for (FieldAndRValue x : this.fields) {
            values.set(x.getField().toString(), x.getRValue().toJson());
        }
        node.set(this.op.toString(), (JsonNode)values);
        return node;
    }

    public static SetExpression fromJson(ObjectNode node) {
        if (node.size() == 1) {
            UpdateOperator op = null;
            if (node.has(UpdateOperator._add.toString())) {
                op = UpdateOperator._add;
            } else if (node.has(UpdateOperator._set.toString())) {
                op = UpdateOperator._set;
            }
            if (op != null) {
                ObjectNode arg = (ObjectNode)node.get(op.toString());
                ArrayList<FieldAndRValue> list = new ArrayList<FieldAndRValue>();
                Iterator itr = arg.fields();
                while (itr.hasNext()) {
                    Map.Entry entry = (Map.Entry)itr.next();
                    Path field = new Path((String)entry.getKey());
                    RValueExpression rvalue = RValueExpression.fromJson((JsonNode)entry.getValue());
                    list.add(new FieldAndRValue(field, rvalue));
                }
                return new SetExpression(op, list);
            }
        }
        throw Error.get((String)"query-api:InvalidSetExpression", (String)node.toString());
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.fields);
        hash = 79 * hash + Objects.hashCode((Object)this.op);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SetExpression other = (SetExpression)((Object)obj);
        if (!Objects.equals(this.fields, other.fields)) {
            return false;
        }
        return this.op == other.op;
    }
}

