/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.Value;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.JsonObject;
import com.redhat.lightblue.util.Path;
import java.util.Objects;

public class RValueExpression
extends JsonObject {
    private static final long serialVersionUID = 1L;
    private final Value value;
    private final Path path;
    private final RValueType type;
    public static final RValueExpression NULL = new RValueExpression(null, null, RValueType._null);

    public RValueExpression(Value value) {
        if (value == null || value.getValue() == null) {
            this.value = null;
            this.path = null;
            this.type = RValueType._null;
        } else {
            this.value = value;
            this.path = null;
            this.type = RValueType._value;
        }
    }

    public RValueExpression(Path p) {
        this(null, p, RValueType._dereference);
    }

    public static RValueExpression nullRValue() {
        return NULL;
    }

    private RValueExpression(Value value, Path path, RValueType type) {
        this.value = value;
        this.path = path;
        this.type = type;
    }

    public Value getValue() {
        return this.value;
    }

    public Path getPath() {
        return this.path;
    }

    public RValueType getType() {
        return this.type;
    }

    public JsonNode toJson() {
        switch (this.type) {
            case _value: {
                return this.value.toJson();
            }
            case _dereference: {
                ObjectNode node = RValueExpression.getFactory().objectNode();
                node.put("$valueof", this.path.toString());
                return node;
            }
        }
        return RValueExpression.getFactory().nullNode();
    }

    public static RValueExpression fromJson(JsonNode node) {
        if (node instanceof ObjectNode) {
            if (node.size() == 1) {
                JsonNode path = node.get("$valueof");
                if (path != null && path.isValueNode()) {
                    return new RValueExpression(new Path(path.asText()));
                }
                return new RValueExpression(new Value(node));
            }
            return new RValueExpression(new Value(node));
        }
        if (node instanceof ArrayNode) {
            return new RValueExpression(new Value(node));
        }
        if (node.isValueNode()) {
            if (node.asText().equals("$null")) {
                return NULL;
            }
            return new RValueExpression(Value.fromJson(node));
        }
        throw Error.get((String)"query-api:InvalidRValueExpression", (String)node.toString());
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode((Object)this.value);
        hash = 79 * hash + Objects.hashCode(this.path);
        hash = 79 * hash + Objects.hashCode((Object)this.type);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RValueExpression other = (RValueExpression)((Object)obj);
        if (!Objects.equals((Object)this.value, (Object)other.value)) {
            return false;
        }
        if (!Objects.equals(this.path, other.path)) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum RValueType {
        _value,
        _dereference,
        _null;

    }
}

