/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.redhat.lightblue.query.AllMatchExpression;
import com.redhat.lightblue.query.ArrayContainsExpression;
import com.redhat.lightblue.query.ArrayMatchExpression;
import com.redhat.lightblue.query.FieldComparisonExpression;
import com.redhat.lightblue.query.NaryFieldRelationalExpression;
import com.redhat.lightblue.query.NaryLogicalExpression;
import com.redhat.lightblue.query.NaryValueRelationalExpression;
import com.redhat.lightblue.query.QueryExpression;
import com.redhat.lightblue.query.QueryIteratorSkeleton;
import com.redhat.lightblue.query.RegexMatchExpression;
import com.redhat.lightblue.query.UnaryLogicalExpression;
import com.redhat.lightblue.query.ValueComparisonExpression;
import com.redhat.lightblue.util.CopyOnWriteIterator;
import com.redhat.lightblue.util.Path;

public abstract class QueryIterator
extends QueryIteratorSkeleton<QueryExpression> {
    @Override
    protected QueryExpression itrAllMatchExpression(AllMatchExpression q, Path context) {
        return q;
    }

    @Override
    protected QueryExpression itrValueComparisonExpression(ValueComparisonExpression q, Path context) {
        return q;
    }

    @Override
    protected QueryExpression itrFieldComparisonExpression(FieldComparisonExpression q, Path context) {
        return q;
    }

    @Override
    protected QueryExpression itrRegexMatchExpression(RegexMatchExpression q, Path context) {
        return q;
    }

    @Override
    protected QueryExpression itrNaryValueRelationalExpression(NaryValueRelationalExpression q, Path context) {
        return q;
    }

    @Override
    protected QueryExpression itrNaryFieldRelationalExpression(NaryFieldRelationalExpression q, Path context) {
        return q;
    }

    @Override
    protected QueryExpression itrArrayContainsExpression(ArrayContainsExpression q, Path context) {
        return q;
    }

    @Override
    protected QueryExpression itrUnaryLogicalExpression(UnaryLogicalExpression q, Path context) {
        QueryExpression newq = (QueryExpression)((Object)this.iterate(q.getQuery(), context));
        if (newq != q.getQuery()) {
            return new UnaryLogicalExpression(q.getOp(), newq);
        }
        return q;
    }

    @Override
    protected QueryExpression itrNaryLogicalExpression(NaryLogicalExpression q, Path context) {
        CopyOnWriteIterator itr = new CopyOnWriteIterator(q.getQueries());
        while (itr.hasNext()) {
            QueryExpression nestedq = (QueryExpression)((Object)itr.next());
            QueryExpression newq = (QueryExpression)((Object)this.iterate(nestedq, context));
            if (newq == nestedq) continue;
            itr.set((Object)newq);
        }
        if (itr.isCopied()) {
            return new NaryLogicalExpression(q.getOp(), itr.getCopiedList());
        }
        return q;
    }

    @Override
    protected QueryExpression itrArrayMatchExpression(ArrayMatchExpression q, Path context) {
        QueryExpression newq = (QueryExpression)((Object)this.iterate(q.getElemMatch(), new Path(new Path(context, q.getArray()), Path.ANYPATH)));
        if (newq != q.getElemMatch()) {
            return new ArrayMatchExpression(q.getArray(), newq);
        }
        return q;
    }
}

