/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.ArrayContainsExpression;
import com.redhat.lightblue.query.ArrayMatchExpression;
import com.redhat.lightblue.query.ComparisonExpression;
import com.redhat.lightblue.query.FieldComparisonExpression;
import com.redhat.lightblue.query.NaryLogicalExpression;
import com.redhat.lightblue.query.NaryLogicalOperator;
import com.redhat.lightblue.query.NaryRelationalExpression;
import com.redhat.lightblue.query.RegexMatchExpression;
import com.redhat.lightblue.query.UnaryLogicalExpression;
import com.redhat.lightblue.query.UnaryLogicalOperator;
import com.redhat.lightblue.query.ValueComparisonExpression;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.JsonObject;
import com.redhat.lightblue.util.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryExpression
extends JsonObject {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryExpression.class);

    public static QueryExpression fromJson(JsonNode node) {
        if (node instanceof ObjectNode) {
            ObjectNode onode = (ObjectNode)node;
            String firstField = (String)onode.fieldNames().next();
            if (UnaryLogicalOperator.fromString(firstField) != null) {
                return UnaryLogicalExpression.fromJson(onode);
            }
            if (NaryLogicalOperator.fromString(firstField) != null) {
                return NaryLogicalExpression.fromJson(onode);
            }
            return ComparisonExpression.fromJson(onode);
        }
        throw Error.get((String)"query-api:InvalidQuery", (String)node.toString());
    }

    public boolean isRequired(Path field) {
        LOGGER.debug("Checking if {} is queried", (Object)field);
        boolean ret = this.isRequired(field, Path.EMPTY);
        LOGGER.debug("{} queried:{}", (Object)field, (Object)ret);
        return ret;
    }

    public boolean isRequired(Path field, Path ctx) {
        if (this instanceof ValueComparisonExpression) {
            return QueryExpression.isFieldQueried(field, (ValueComparisonExpression)this, ctx);
        }
        if (this instanceof FieldComparisonExpression) {
            return QueryExpression.isFieldQueried(field, (FieldComparisonExpression)this, ctx);
        }
        if (this instanceof RegexMatchExpression) {
            return QueryExpression.isFieldQueried(field, (RegexMatchExpression)this, ctx);
        }
        if (this instanceof NaryRelationalExpression) {
            return QueryExpression.isFieldQueried(field, (NaryRelationalExpression)this, ctx);
        }
        if (this instanceof UnaryLogicalExpression) {
            return QueryExpression.isFieldQueried(field, (UnaryLogicalExpression)this, ctx);
        }
        if (this instanceof NaryLogicalExpression) {
            return QueryExpression.isFieldQueried(field, (NaryLogicalExpression)this, ctx);
        }
        if (this instanceof ArrayContainsExpression) {
            return QueryExpression.isFieldQueried(field, (ArrayContainsExpression)this, ctx);
        }
        if (this instanceof ArrayMatchExpression) {
            return QueryExpression.isFieldQueried(field, (ArrayMatchExpression)this, ctx);
        }
        return false;
    }

    private static boolean isFieldQueried(Path field, Path qField, Path context) {
        Path absField;
        LOGGER.debug("Checking if field {} is included in qfield={} with context={}", new Object[]{field, qField, context});
        Path path = absField = context.isEmpty() ? qField : new Path(context, qField);
        if (field.matchingPrefix(absField)) {
            LOGGER.debug("Field {} is queried", (Object)absField);
            return true;
        }
        LOGGER.debug("Field {} is not queried", (Object)absField);
        return false;
    }

    private static boolean isFieldQueried(Path field, ValueComparisonExpression q, Path context) {
        LOGGER.debug("Checking if field {} is queried by value comparison {}", (Object)field, (Object)q);
        return QueryExpression.isFieldQueried(field, q.getField(), context);
    }

    private static boolean isFieldQueried(Path field, FieldComparisonExpression q, Path context) {
        LOGGER.debug("Checking if field {} is queried by field comparison {}", (Object)field, (Object)q);
        return QueryExpression.isFieldQueried(field, q.getField(), context) || QueryExpression.isFieldQueried(field, q.getRfield(), context);
    }

    private static boolean isFieldQueried(Path field, RegexMatchExpression q, Path context) {
        LOGGER.debug("Checking if field {} is queried by regex {}", (Object)field, (Object)q);
        return QueryExpression.isFieldQueried(field, q.getField(), context);
    }

    private static boolean isFieldQueried(Path field, NaryRelationalExpression q, Path context) {
        LOGGER.debug("Checking if field {} is queried by expr {}", (Object)field, (Object)q);
        return QueryExpression.isFieldQueried(field, q.getField(), context);
    }

    private static boolean isFieldQueried(Path field, UnaryLogicalExpression q, Path context) {
        return q.getQuery().isRequired(field, context);
    }

    private static boolean isFieldQueried(Path field, NaryLogicalExpression q, Path context) {
        for (QueryExpression x : q.getQueries()) {
            if (!x.isRequired(field, context)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFieldQueried(Path field, ArrayContainsExpression q, Path context) {
        LOGGER.debug("Checking if field {} is queried by array expression {}", (Object)field, (Object)q);
        return QueryExpression.isFieldQueried(field, q.getArray(), context);
    }

    private static boolean isFieldQueried(Path field, ArrayMatchExpression q, Path context) {
        LOGGER.debug("Checking if field {} is queried by array expression {}", (Object)field, (Object)q);
        if (QueryExpression.isFieldQueried(field, q.getArray(), context)) {
            return true;
        }
        return q.getElemMatch().isRequired(field, new Path(new Path(context, q.getArray()), Path.ANYPATH));
    }
}

