/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.redhat.lightblue.query.ArrayProjection;
import com.redhat.lightblue.query.ArrayQueryMatchProjection;
import com.redhat.lightblue.query.ArrayRangeProjection;
import com.redhat.lightblue.query.BasicProjection;
import com.redhat.lightblue.query.FieldProjection;
import com.redhat.lightblue.query.ProjectionList;
import com.redhat.lightblue.util.JsonObject;
import com.redhat.lightblue.util.MutablePath;
import com.redhat.lightblue.util.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Projection
extends JsonObject {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Projection.class);

    public static Projection fromJson(JsonNode node) {
        if (node instanceof ArrayNode) {
            return ProjectionList.fromJson((ArrayNode)node);
        }
        return BasicProjection.fromJson((ObjectNode)node);
    }

    public static Projection add(Projection p1, Projection p2) {
        ArrayList<Projection> list = new ArrayList<Projection>();
        if (p1 instanceof ProjectionList) {
            list.addAll(((ProjectionList)p1).getItems());
        } else if (p1 != null) {
            list.add(p1);
        }
        if (p2 instanceof ProjectionList) {
            list.addAll(((ProjectionList)p2).getItems());
        } else if (p2 != null) {
            list.add(p2);
        }
        return list.isEmpty() ? null : new ProjectionList(list);
    }

    public static Boolean fieldMatchesPattern(Path field, Path pattern, boolean inclusion) {
        if (field.matches(pattern)) {
            return inclusion;
        }
        return null;
    }

    public static Boolean fieldAncestorOfPattern(Path field, Path pattern, boolean inclusion) {
        if (field.matchingPrefix(pattern)) {
            if (inclusion) {
                return Boolean.TRUE;
            }
            return null;
        }
        return null;
    }

    public static Boolean impliedInclusion(Path field, Path pattern, boolean inclusion) {
        if (field.numSegments() > pattern.numSegments() && field.prefix(pattern.numSegments()).matches(pattern)) {
            return inclusion ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    public static Inclusion isFieldIncluded(Path field, Path pattern, boolean inclusion, boolean recursive) {
        Boolean v = Projection.fieldMatchesPattern(field, pattern, inclusion);
        if (v != null) {
            if (pattern.tail(0).equals("*")) {
                return v != false ? Inclusion.implicit_inclusion : Inclusion.implicit_exclusion;
            }
            return v != false ? Inclusion.explicit_inclusion : Inclusion.explicit_exclusion;
        }
        v = Projection.fieldAncestorOfPattern(field, pattern, inclusion);
        if (v != null) {
            return v != false ? Inclusion.explicit_inclusion : Inclusion.explicit_exclusion;
        }
        if (recursive && (v = Projection.impliedInclusion(field, pattern, inclusion)) != null) {
            return v != false ? Inclusion.implicit_inclusion : Inclusion.implicit_exclusion;
        }
        return Inclusion.undecided;
    }

    public Inclusion getFieldInclusion(Path field) {
        LOGGER.debug("Checking if {} is projected", (Object)field);
        Inclusion ret = this.getFieldInclusion(field, Path.EMPTY);
        LOGGER.debug("Inclusion {}={}", (Object)field, (Object)ret);
        return ret;
    }

    public Inclusion getFieldInclusion(Path field, Path ctx) {
        Path mfield = Projection.toMask(field);
        ctx = Projection.toMask(ctx);
        if (this instanceof FieldProjection) {
            return this.getFieldInclusion(mfield, (FieldProjection)this, ctx);
        }
        if (this instanceof ArrayProjection) {
            return this.getFieldInclusion(mfield, (ArrayProjection)this, ctx);
        }
        if (this instanceof ProjectionList) {
            return this.getFieldInclusion(mfield, (ProjectionList)this, ctx);
        }
        return Inclusion.undecided;
    }

    public boolean isFieldRequiredToEvaluateProjection(Path field) {
        LOGGER.debug("Checking if {} is referenced in projection", (Object)field);
        return this.isFieldRequiredToEvaluateProjection(field, Path.EMPTY);
    }

    public boolean isFieldRequiredToEvaluateProjection(Path field, Path ctx) {
        Path mfield = Projection.toMask(field);
        ctx = Projection.toMask(ctx);
        if (this instanceof FieldProjection) {
            switch (this.getFieldInclusion(mfield, (FieldProjection)this, ctx)) {
                case implicit_inclusion: 
                case explicit_inclusion: {
                    return true;
                }
            }
            return false;
        }
        if (this instanceof ArrayQueryMatchProjection) {
            if (this.getFieldInclusion(mfield, (ArrayProjection)this, ctx) == Inclusion.undecided) {
                LOGGER.debug("whether to include {} is Undecided, checking projection query", (Object)mfield);
                Path absField = new Path(ctx, Projection.toMask(((ArrayQueryMatchProjection)this).getField()));
                Path nestedCtx = new Path(absField, Path.ANYPATH);
                boolean ret = ((ArrayQueryMatchProjection)this).getMatch().isRequired(field, nestedCtx);
                LOGGER.debug("isRequired({},{}.*={}", new Object[]{field, absField, ret});
                if (ret) {
                    return true;
                }
                LOGGER.debug("Query does not require {}, checking nested projection", (Object)mfield);
                if (((ArrayProjection)this).getProject() != null) {
                    ret = ((ArrayProjection)this).getProject().isFieldRequiredToEvaluateProjection(field, nestedCtx);
                }
                LOGGER.debug("result:{}", (Object)ret);
                return ret;
            }
            return true;
        }
        if (this instanceof ArrayRangeProjection) {
            return this.getFieldInclusion(mfield, (ArrayProjection)this, ctx) != Inclusion.undecided;
        }
        if (this instanceof ProjectionList) {
            for (Projection x : ((ProjectionList)this).getItems()) {
                if (!x.isFieldRequiredToEvaluateProjection(field, ctx)) continue;
                return true;
            }
        }
        return false;
    }

    private Inclusion getFieldInclusion(Path field, ArrayProjection p, Path context) {
        Path absField = new Path(context, Projection.toMask(p.getField()));
        LOGGER.debug("Checking if array projection on {} projects {}", (Object)absField, (Object)field);
        Inclusion inc = Projection.isFieldIncluded(field, absField, p.isInclude(), false);
        Inclusion inc2 = p.getProject().getFieldInclusion(field, new Path(absField, Path.ANYPATH));
        Inclusion ret = inc == Inclusion.explicit_inclusion || inc2 == Inclusion.explicit_inclusion ? Inclusion.explicit_inclusion : (inc == Inclusion.implicit_inclusion || inc2 == Inclusion.implicit_inclusion ? Inclusion.implicit_inclusion : (inc == Inclusion.explicit_exclusion || inc2 == Inclusion.explicit_exclusion ? Inclusion.explicit_exclusion : (inc == Inclusion.implicit_exclusion || inc2 == Inclusion.implicit_exclusion ? Inclusion.implicit_exclusion : Inclusion.undecided)));
        LOGGER.debug("array projection on {} projects {}: {}", new Object[]{absField, field, ret});
        return ret;
    }

    private Inclusion getFieldInclusion(Path field, ProjectionList p, Path context) {
        LOGGER.debug("Checking if a projection list projects {}", (Object)field);
        Inclusion lastResult = Inclusion.undecided;
        List<Projection> items = p.getItems();
        ListIterator<Projection> itemsItr = items.listIterator(items.size());
        while (itemsItr.hasPrevious()) {
            Inclusion ret = itemsItr.previous().getFieldInclusion(field, context);
            if (ret == Inclusion.undecided) continue;
            if (ret == Inclusion.explicit_inclusion || ret == Inclusion.explicit_exclusion) {
                lastResult = ret;
                break;
            }
            if (lastResult != Inclusion.undecided) continue;
            lastResult = ret;
        }
        LOGGER.debug("Projection list projects {}: {}", (Object)field, (Object)lastResult);
        return lastResult;
    }

    private Inclusion getFieldInclusion(Path field, FieldProjection p, Path context) {
        Path projectionField = new Path(context, Projection.toMask(p.getField()));
        LOGGER.debug("Checking if field projection on {} projects {}", (Object)projectionField, (Object)field);
        Inclusion inc = Projection.isFieldIncluded(field, projectionField, p.isInclude(), p.isRecursive());
        LOGGER.debug("Field projection on {} projects {}: {}", new Object[]{projectionField, field, inc});
        return inc;
    }

    private static Path toMask(Path p) {
        int n = p.numSegments();
        MutablePath mp = null;
        for (int i = 0; i < n; ++i) {
            if (!p.isIndex(i)) continue;
            if (mp == null) {
                mp = p.mutableCopy();
            }
            mp.set(i, "*");
        }
        return mp == null ? p : mp.immutableCopy();
    }

    protected static Path getNonRelativePath(Path p) {
        ArrayList<String> segments = new ArrayList<String>();
        int numberOfParentsOnPath = 0;
        for (int i = p.numSegments() - 1; i >= 0; --i) {
            if ("$this".equals(p.head(i))) continue;
            if ("$parent".equals(p.head(i))) {
                ++numberOfParentsOnPath;
                continue;
            }
            if (numberOfParentsOnPath > 0) {
                --numberOfParentsOnPath;
                continue;
            }
            segments.add(p.head(i));
        }
        Collections.reverse(segments);
        return new Path(Joiner.on((String)".").join(segments));
    }

    public static enum Inclusion {
        explicit_exclusion,
        implicit_exclusion,
        explicit_inclusion,
        implicit_inclusion,
        undecided;

    }
}

