/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.LogicalExpression;
import com.redhat.lightblue.query.NaryLogicalOperator;
import com.redhat.lightblue.query.QueryExpression;
import com.redhat.lightblue.util.Error;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NaryLogicalExpression
extends LogicalExpression {
    private static final long serialVersionUID = 1L;
    private final NaryLogicalOperator op;
    private final List<QueryExpression> queries;

    public NaryLogicalExpression(NaryLogicalOperator op, List<QueryExpression> queries) {
        this.op = op;
        this.queries = queries;
    }

    public NaryLogicalExpression(NaryLogicalOperator op, QueryExpression ... queries) {
        this(op, new ArrayList<QueryExpression>(queries.length));
        for (QueryExpression q : queries) {
            this.queries.add(q);
        }
    }

    public NaryLogicalOperator getOp() {
        return this.op;
    }

    public List<QueryExpression> getQueries() {
        return this.queries;
    }

    public JsonNode toJson() {
        ArrayNode arr = NaryLogicalExpression.getFactory().arrayNode();
        for (QueryExpression x : this.queries) {
            arr.add(x.toJson());
        }
        return NaryLogicalExpression.getFactory().objectNode().set(this.op.toString(), (JsonNode)arr);
    }

    public static NaryLogicalExpression fromJson(ObjectNode node) {
        if (node.size() != 1) {
            throw Error.get((String)"query-api:InvalidLogicalExpression", (String)node.toString());
        }
        String fieldName = (String)node.fieldNames().next();
        NaryLogicalOperator op = NaryLogicalOperator.fromString(fieldName);
        if (op == null) {
            throw Error.get((String)"query-api:InvalidLogicalExpression", (String)node.toString());
        }
        JsonNode x = node.get(fieldName);
        if (x instanceof ArrayNode) {
            ArrayList<QueryExpression> list = new ArrayList<QueryExpression>(((ArrayNode)x).size());
            Iterator itr = ((ArrayNode)x).elements();
            while (itr.hasNext()) {
                list.add(QueryExpression.fromJson((JsonNode)itr.next()));
            }
            return new NaryLogicalExpression(op, list);
        }
        throw Error.get((String)"query-api:InvalidLogicalExpression", (String)node.toString());
    }
}

