/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.NaryRelationalExpression;
import com.redhat.lightblue.query.NaryRelationalOperator;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.Path;

public class NaryFieldRelationalExpression
extends NaryRelationalExpression {
    private final Path rfield;

    public NaryFieldRelationalExpression(Path field, NaryRelationalOperator op, Path rfield) {
        super(field, op);
        this.rfield = rfield;
    }

    public Path getRfield() {
        return this.rfield;
    }

    public JsonNode toJson() {
        return NaryFieldRelationalExpression.getFactory().objectNode().put("field", this.getField().toString()).put("op", this.getOp().toString()).put("rfield", this.rfield.toString());
    }

    public static NaryFieldRelationalExpression fromJson(ObjectNode node) {
        NaryRelationalOperator op;
        JsonNode x;
        if (node.size() == 3 && (x = node.get("op")) != null && (op = NaryRelationalOperator.fromString(x.asText())) != null && (x = node.get("field")) != null) {
            Path field = new Path(x.asText());
            x = node.get("rfield");
            if (x != null) {
                return new NaryFieldRelationalExpression(field, op, new Path(x.asText()));
            }
        }
        throw Error.get((String)"query-api:InvalidComparisonExpression", (String)node.toString());
    }
}

