/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.redhat.lightblue.query.ArrayContainsExpression;
import com.redhat.lightblue.query.ArrayMatchExpression;
import com.redhat.lightblue.query.FieldComparisonExpression;
import com.redhat.lightblue.query.NaryFieldRelationalExpression;
import com.redhat.lightblue.query.NaryValueRelationalExpression;
import com.redhat.lightblue.query.QueryExpression;
import com.redhat.lightblue.query.QueryIterator;
import com.redhat.lightblue.query.RegexMatchExpression;
import com.redhat.lightblue.query.ValueComparisonExpression;
import com.redhat.lightblue.util.Path;

public class MapQueryFieldsIterator
extends QueryIterator {
    protected Path map(Path p) {
        return p;
    }

    @Override
    protected QueryExpression itrValueComparisonExpression(ValueComparisonExpression q, Path context) {
        Path p = this.map(this.applyContext(context, q.getField()));
        if (p != null) {
            return new ValueComparisonExpression(this.removeContext(context, p, q.getField()), q.getOp(), q.getRvalue());
        }
        return q;
    }

    @Override
    protected QueryExpression itrFieldComparisonExpression(FieldComparisonExpression q, Path context) {
        Path r = this.map(this.applyContext(context, q.getRfield()));
        Path l = this.map(this.applyContext(context, q.getField()));
        if (r != null || l != null) {
            return new FieldComparisonExpression(l == null ? q.getField() : this.removeContext(context, l, q.getField()), q.getOp(), r == null ? q.getRfield() : this.removeContext(context, r, q.getRfield()));
        }
        return q;
    }

    @Override
    protected QueryExpression itrRegexMatchExpression(RegexMatchExpression q, Path context) {
        Path p = this.map(this.applyContext(context, q.getField()));
        if (p != null) {
            return new RegexMatchExpression(this.removeContext(context, p, q.getField()), q.getRegex(), q.isCaseInsensitive(), q.isMultiline(), q.isExtended(), q.isDotAll());
        }
        return q;
    }

    @Override
    protected QueryExpression itrNaryValueRelationalExpression(NaryValueRelationalExpression q, Path context) {
        Path p = this.map(this.applyContext(context, q.getField()));
        if (p != null) {
            return new NaryValueRelationalExpression(this.removeContext(context, p, q.getField()), q.getOp(), q.getValues());
        }
        return q;
    }

    @Override
    protected QueryExpression itrNaryFieldRelationalExpression(NaryFieldRelationalExpression q, Path context) {
        Path r = this.map(this.applyContext(context, q.getRfield()));
        Path l = this.map(this.applyContext(context, q.getField()));
        if (r != null || l != null) {
            return new NaryFieldRelationalExpression(l == null ? q.getField() : this.removeContext(context, l, q.getField()), q.getOp(), r == null ? q.getRfield() : this.removeContext(context, r, q.getRfield()));
        }
        return q;
    }

    @Override
    protected QueryExpression itrArrayContainsExpression(ArrayContainsExpression q, Path context) {
        Path p = this.applyContext(context, q.getArray());
        if (p != null) {
            return new ArrayContainsExpression(this.removeContext(context, p, q.getArray()), q.getOp(), q.getValues());
        }
        return q;
    }

    @Override
    protected QueryExpression itrArrayMatchExpression(ArrayMatchExpression q, Path context) {
        ArrayMatchExpression x = (ArrayMatchExpression)super.itrArrayMatchExpression(q, context);
        Path p = this.map(this.applyContext(context, x.getArray()));
        if (p != null) {
            return new ArrayMatchExpression(this.removeContext(context, p, x.getArray()), x.getElemMatch());
        }
        return x;
    }

    private Path applyContext(Path context, Path p) {
        if (context.isEmpty()) {
            return p;
        }
        return new Path(context, p);
    }

    private Path removeContext(Path context, Path p, Path original) {
        if (context.isEmpty()) {
            return p;
        }
        if (context.matchingPrefix(p)) {
            return p.suffix(-context.numSegments());
        }
        return original;
    }
}

