/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.ArrayProjection;
import com.redhat.lightblue.query.Projection;
import com.redhat.lightblue.query.Sort;
import com.redhat.lightblue.util.Path;

public class ArrayRangeProjection
extends ArrayProjection {
    private static final long serialVersionUID = 1L;
    private final Integer from;
    private final Integer to;

    public ArrayRangeProjection(Path field, boolean include, Projection project, Sort sort, Integer from, Integer to) {
        super(field, include, project, sort);
        this.from = from;
        this.to = to;
    }

    public ArrayRangeProjection(Path field, boolean include, Projection project, Integer from, Integer to) {
        this(field, include, project, null, from, to);
    }

    public Integer getFrom() {
        return this.from;
    }

    public Integer getTo() {
        return this.to;
    }

    @Override
    public JsonNode toJson() {
        ArrayNode arr = ArrayRangeProjection.getFactory().arrayNode();
        if (this.from == null) {
            arr.add((JsonNode)ArrayRangeProjection.getFactory().nullNode());
            if (this.to == null) {
                arr.add((JsonNode)ArrayRangeProjection.getFactory().nullNode());
            } else {
                arr.add((JsonNode)ArrayRangeProjection.getFactory().numberNode(this.to));
            }
        } else if (this.from != null) {
            arr.add((JsonNode)ArrayRangeProjection.getFactory().numberNode(this.from));
            if (this.to == null) {
                arr.add((JsonNode)ArrayRangeProjection.getFactory().nullNode());
            } else {
                arr.add((JsonNode)ArrayRangeProjection.getFactory().numberNode(this.to));
            }
        }
        return ((ObjectNode)super.toJson()).set("range", (JsonNode)arr);
    }
}

