/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.BasicProjection;
import com.redhat.lightblue.query.FieldProjection;
import com.redhat.lightblue.query.Projection;
import com.redhat.lightblue.query.Sort;
import com.redhat.lightblue.util.Path;

public abstract class ArrayProjection
extends BasicProjection {
    private static final long serialVersionUID = 1L;
    private final Path field;
    private final boolean include;
    private final Projection project;
    private final Sort sort;

    public ArrayProjection(Path field, boolean include, Projection project, Sort sort) {
        this.field = field;
        this.include = include;
        this.project = project == null ? FieldProjection.ALL : project;
        this.sort = sort;
    }

    public Path getField() {
        return this.field;
    }

    public boolean isInclude() {
        return this.include;
    }

    public Projection getProject() {
        return this.project;
    }

    public Sort getSort() {
        return this.sort;
    }

    public JsonNode toJson() {
        ObjectNode node = ArrayProjection.getFactory().objectNode().put("field", this.field.toString()).put("include", this.include);
        node.set("projection", this.project.toJson());
        if (this.sort != null) {
            node.set("sort", this.sort.toJson());
        }
        return node;
    }
}

