/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.ArrayComparisonExpression;
import com.redhat.lightblue.query.QueryExpression;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.Path;

public class ArrayMatchExpression
extends ArrayComparisonExpression {
    private static final long serialVersionUID = 1L;
    private final Path array;
    private final QueryExpression elemMatch;

    public ArrayMatchExpression(Path array, QueryExpression elemMatch) {
        this.array = array;
        this.elemMatch = elemMatch;
    }

    public Path getArray() {
        return this.array;
    }

    public QueryExpression getElemMatch() {
        return this.elemMatch;
    }

    public JsonNode toJson() {
        return ArrayMatchExpression.getFactory().objectNode().put("array", this.array.toString()).set("elemMatch", this.elemMatch.toJson());
    }

    public static ArrayMatchExpression fromJson(ObjectNode node) {
        JsonNode x = node.get("array");
        if (x != null) {
            Path field = new Path(x.asText());
            x = node.get("elemMatch");
            if (x != null) {
                return new ArrayMatchExpression(field, QueryExpression.fromJson(x));
            }
        }
        throw Error.get((String)"query-api:InvalidArrayComparisonExpression", (String)node.toString());
    }
}

