/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.ArrayUpdateExpression;
import com.redhat.lightblue.query.RValueExpression;
import com.redhat.lightblue.query.UpdateOperator;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ArrayAddExpression
extends ArrayUpdateExpression {
    private static final long serialVersionUID = 1L;
    private final List<RValueExpression> values;
    private final UpdateOperator op;
    private final Path field;

    public ArrayAddExpression(Path field, UpdateOperator op, List<RValueExpression> list) {
        this.op = op;
        this.values = list;
        this.field = field;
    }

    public Path getField() {
        return this.field;
    }

    public List<RValueExpression> getValues() {
        return this.values;
    }

    public UpdateOperator getOp() {
        return this.op;
    }

    public JsonNode toJson() {
        ObjectNode node = ArrayAddExpression.getFactory().objectNode();
        ObjectNode args = ArrayAddExpression.getFactory().objectNode();
        if (this.values.size() == 1) {
            args.set(this.field.toString(), this.values.get(0).toJson());
        } else {
            ArrayNode arr = ArrayAddExpression.getFactory().arrayNode();
            for (RValueExpression v : this.values) {
                arr.add(v.toJson());
            }
            args.set(this.field.toString(), (JsonNode)arr);
        }
        node.set(this.op.toString(), (JsonNode)args);
        return node;
    }

    public static ArrayAddExpression fromJson(ObjectNode node) {
        if (node.size() == 1) {
            ObjectNode objArg;
            UpdateOperator op = UpdateOperator._append;
            JsonNode arg = node.get(UpdateOperator._append.toString());
            if (arg == null) {
                arg = node.get(UpdateOperator._insert.toString());
                op = UpdateOperator._insert;
            }
            if (arg instanceof ObjectNode && (objArg = (ObjectNode)arg).size() == 1) {
                Map.Entry item = (Map.Entry)objArg.fields().next();
                Path field = new Path((String)item.getKey());
                JsonNode valueNode = (JsonNode)item.getValue();
                ArrayList<RValueExpression> rvalues = new ArrayList<RValueExpression>();
                if (valueNode instanceof ArrayNode) {
                    Iterator itr = ((ArrayNode)valueNode).elements();
                    while (itr.hasNext()) {
                        rvalues.add(RValueExpression.fromJson((JsonNode)itr.next()));
                    }
                } else {
                    rvalues.add(RValueExpression.fromJson(valueNode));
                }
                return new ArrayAddExpression(field, op, rvalues);
            }
        }
        throw Error.get((String)"query-api:InvalidArrayUpdateExpression", (String)node.toString());
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.values);
        hash = 89 * hash + Objects.hashCode((Object)this.op);
        hash = 89 * hash + Objects.hashCode(this.field);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ArrayAddExpression other = (ArrayAddExpression)((Object)obj);
        if (!Objects.equals(this.values, other.values)) {
            return false;
        }
        if (this.op != other.op) {
            return false;
        }
        return Objects.equals(this.field, other.field);
    }
}

