/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.JsonObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

public class Value
extends JsonObject {
    private static final long serialVersionUID = 1L;
    protected Object value;

    public Value(Object o) {
        this.value = o;
    }

    public Object getValue() {
        return this.value;
    }

    public JsonNode toJson() {
        if (this.value instanceof Number) {
            if (this.value instanceof BigDecimal) {
                return Value.getFactory().numberNode((BigDecimal)this.value);
            }
            if (this.value instanceof BigInteger) {
                return Value.getFactory().numberNode((BigInteger)this.value);
            }
            if (this.value instanceof Double) {
                return Value.getFactory().numberNode((Double)this.value);
            }
            if (this.value instanceof Float) {
                return Value.getFactory().numberNode((Float)this.value);
            }
            if (this.value instanceof Long) {
                return Value.getFactory().numberNode((Long)this.value);
            }
            return Value.getFactory().numberNode(((Number)this.value).intValue());
        }
        if (this.value instanceof Boolean) {
            return Value.getFactory().booleanNode(((Boolean)this.value).booleanValue());
        }
        if (this.value == null) {
            return Value.getFactory().nullNode();
        }
        return Value.getFactory().textNode(this.value.toString());
    }

    public static Value fromJson(JsonNode node) {
        if (node.isValueNode()) {
            Object v = null;
            v = node.isNumber() ? (node.isBigDecimal() || node.isDouble() || node.isFloat() ? node.decimalValue() : (node.isBigInteger() ? node.bigIntegerValue() : (node.isLong() ? (Number)node.longValue() : (Number)node.intValue()))) : (node.isBoolean() ? Boolean.valueOf(node.booleanValue()) : node.textValue());
            return new Value(v);
        }
        throw Error.get((String)"query-api:InvalidValue", (String)node.toString());
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + Objects.hashCode(this.value);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Value other = (Value)((Object)obj);
        return Objects.equals(this.value, other.value);
    }
}

