/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.PrimitiveUpdateExpression;
import com.redhat.lightblue.query.UpdateOperator;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class UnsetExpression
extends PrimitiveUpdateExpression {
    private static final long serialVersionUID = 1L;
    private final List<Path> fields;

    public UnsetExpression(List<Path> list) {
        this.fields = list;
    }

    public List<Path> getFields() {
        return this.fields;
    }

    public JsonNode toJson() {
        ObjectNode node = UnsetExpression.getFactory().objectNode();
        ArrayNode fieldArr = UnsetExpression.getFactory().arrayNode();
        for (Path x : this.fields) {
            fieldArr.add((JsonNode)UnsetExpression.getFactory().textNode(x.toString()));
        }
        node.set(UpdateOperator._unset.toString(), (JsonNode)fieldArr);
        return node;
    }

    public static UnsetExpression fromJson(ObjectNode node) {
        JsonNode val;
        if (node.size() == 1 && (val = node.get(UpdateOperator._unset.toString())) != null) {
            ArrayList<Path> fields = new ArrayList<Path>();
            if (val instanceof ArrayNode) {
                Iterator itr = ((ArrayNode)val).elements();
                while (itr.hasNext()) {
                    fields.add(new Path(((JsonNode)itr.next()).asText()));
                }
            } else if (val.isValueNode()) {
                fields.add(new Path(val.asText()));
            }
            return new UnsetExpression(fields);
        }
        throw Error.get((String)"query-api:InvalidUnsetExpression", (String)node.toString());
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash + Objects.hashCode(this.fields);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        UnsetExpression other = (UnsetExpression)((Object)obj);
        return Objects.equals(this.fields, other.fields);
    }
}

