/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.Sort;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.Path;

public class SortKey
extends Sort {
    private static final long serialVersionUID = 1L;
    private final Path field;
    private final boolean desc;

    public SortKey(Path field, boolean desc) {
        this.field = field;
        this.desc = desc;
    }

    public Path getField() {
        return this.field;
    }

    public boolean isDesc() {
        return this.desc;
    }

    public JsonNode toJson() {
        return SortKey.getFactory().objectNode().put(this.field.toString(), this.desc ? "$desc" : "$asc");
    }

    public static SortKey fromJson(ObjectNode node) {
        if (node.size() != 1) {
            throw Error.get((String)"query-api:InvalidSort", (String)node.toString());
        }
        String fieldString = (String)node.fieldNames().next();
        String dir = node.get(fieldString).asText();
        Path field = new Path(fieldString);
        boolean desc = false;
        switch (dir) {
            case "$asc": {
                desc = false;
                break;
            }
            case "$desc": {
                desc = true;
                break;
            }
            default: {
                throw Error.get((String)"query-api:InvalidSort", (String)node.toString());
            }
        }
        return new SortKey(field, desc);
    }
}

