/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.redhat.lightblue.query.ArrayContainsExpression;
import com.redhat.lightblue.query.ArrayMatchExpression;
import com.redhat.lightblue.query.FieldComparisonExpression;
import com.redhat.lightblue.query.NaryFieldRelationalExpression;
import com.redhat.lightblue.query.NaryValueRelationalExpression;
import com.redhat.lightblue.query.QueryExpression;
import com.redhat.lightblue.query.QueryIterator;
import com.redhat.lightblue.query.RegexMatchExpression;
import com.redhat.lightblue.query.ValueComparisonExpression;
import com.redhat.lightblue.util.Path;

public class RelativeRewriteIterator
extends QueryIterator {
    private Path relativeTo;

    public RelativeRewriteIterator(Path relativeTo) {
        this.relativeTo = relativeTo;
    }

    @Override
    protected QueryExpression itrValueComparisonExpression(ValueComparisonExpression q, Path context) {
        return new ValueComparisonExpression(this.toRelative(q.getField(), context), q.getOp(), q.getRvalue());
    }

    @Override
    protected QueryExpression itrFieldComparisonExpression(FieldComparisonExpression q, Path context) {
        return new FieldComparisonExpression(this.toRelative(q.getField(), context), q.getOp(), this.toRelative(q.getRfield(), context));
    }

    @Override
    protected QueryExpression itrRegexMatchExpression(RegexMatchExpression q, Path context) {
        return new RegexMatchExpression(this.toRelative(q.getField(), context), q.getRegex(), q.isCaseInsensitive(), q.isMultiline(), q.isExtended(), q.isDotAll());
    }

    @Override
    protected QueryExpression itrNaryValueRelationalExpression(NaryValueRelationalExpression q, Path context) {
        return new NaryValueRelationalExpression(this.toRelative(q.getField(), context), q.getOp(), q.getValues());
    }

    @Override
    protected QueryExpression itrNaryFieldRelationalExpression(NaryFieldRelationalExpression q, Path context) {
        return new NaryFieldRelationalExpression(this.toRelative(q.getField(), context), q.getOp(), this.toRelative(q.getRfield(), context));
    }

    @Override
    protected QueryExpression itrArrayContainsExpression(ArrayContainsExpression q, Path context) {
        return new ArrayContainsExpression(this.toRelative(q.getArray(), context), q.getOp(), q.getValues());
    }

    @Override
    protected QueryExpression itrArrayMatchExpression(ArrayMatchExpression q, Path context) {
        return new ArrayMatchExpression(this.toRelative(q.getArray(), context), q.getElemMatch());
    }

    private Path toRelative(Path field, Path context) {
        Path abs;
        Path path = abs = context.isEmpty() ? field : new Path(context, field);
        if (this.relativeTo.matchingPrefix(abs)) {
            return abs.suffix(-this.relativeTo.numSegments());
        }
        throw new IllegalArgumentException("Cannot write " + abs + " relative to " + this.relativeTo);
    }
}

