/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.BinaryComparisonOperator;
import com.redhat.lightblue.query.BinaryRelationalExpression;
import com.redhat.lightblue.query.ComparisonExpression;
import com.redhat.lightblue.query.NaryRelationalExpression;
import com.redhat.lightblue.query.NaryRelationalOperator;
import com.redhat.lightblue.query.RegexMatchExpression;
import com.redhat.lightblue.util.Error;

public abstract class RelationalExpression
extends ComparisonExpression {
    private static final long serialVersionUID = 1L;

    public static RelationalExpression fromJson(ObjectNode node) {
        JsonNode x = node.get("regex");
        if (x != null) {
            return RegexMatchExpression.fromJson(node);
        }
        x = node.get("op");
        if (x != null) {
            String op = x.asText();
            if (BinaryComparisonOperator.fromString(op) != null) {
                return BinaryRelationalExpression.fromJson(node);
            }
            if (NaryRelationalOperator.fromString(op) != null) {
                return NaryRelationalExpression.fromJson(node);
            }
        }
        throw Error.get((String)"query-api:InvalidComparisonExpression", (String)node.toString());
    }
}

