/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.RelationalExpression;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.Path;

public class RegexMatchExpression
extends RelationalExpression {
    private static final long serialVersionUID = 1L;
    private final Path field;
    private final String regex;
    private final boolean caseInsensitive;
    private final boolean multiline;
    private final boolean extended;
    private final boolean dotall;

    public RegexMatchExpression(Path field, String regex, boolean caseInsensitive, boolean multiline, boolean extended, boolean dotall) {
        this.field = field;
        this.regex = regex;
        this.caseInsensitive = caseInsensitive;
        this.multiline = multiline;
        this.extended = extended;
        this.dotall = dotall;
    }

    public Path getField() {
        return this.field;
    }

    public String getRegex() {
        return this.regex;
    }

    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public boolean isExtended() {
        return this.extended;
    }

    public boolean isDotAll() {
        return this.dotall;
    }

    public JsonNode toJson() {
        ObjectNode node = RegexMatchExpression.getFactory().objectNode().put("field", this.field.toString()).put("regex", this.regex);
        if (this.caseInsensitive) {
            node.put("caseInsensitive", true);
        }
        if (this.multiline) {
            node.put("multiline", true);
        }
        if (this.extended) {
            node.put("extended", true);
        }
        if (this.dotall) {
            node.put("dotall", true);
        }
        return node;
    }

    public static RegexMatchExpression fromJson(ObjectNode node) {
        JsonNode x = node.get("field");
        if (x != null) {
            Path field = new Path(x.asText());
            x = node.get("regex");
            if (x != null) {
                String regex = x.asText();
                return new RegexMatchExpression(field, regex, RegexMatchExpression.asBoolean(node.get("caseInsensitive")), RegexMatchExpression.asBoolean(node.get("multiline")), RegexMatchExpression.asBoolean(node.get("extended")), RegexMatchExpression.asBoolean(node.get("dotall")));
            }
        }
        throw Error.get((String)"query-api:InvalidRegexExpression", (String)node.toString());
    }

    private static boolean asBoolean(JsonNode node) {
        if (node != null) {
            return node.asBoolean();
        }
        return false;
    }
}

