/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.Value;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.JsonObject;
import com.redhat.lightblue.util.Path;
import java.util.Objects;

public class RValueExpression
extends JsonObject {
    private static final long serialVersionUID = 1L;
    private final Value value;
    private final Path path;
    private final RValueType type;

    public RValueExpression(Value value) {
        this.value = value;
        this.path = null;
        this.type = RValueType._value;
    }

    public RValueExpression(Path p) {
        this.type = RValueType._dereference;
        this.path = p;
        this.value = null;
    }

    public RValueExpression() {
        this.type = RValueType._emptyObject;
        this.path = null;
        this.value = null;
    }

    public RValueExpression(RValueType type) {
        this.type = type;
        this.path = null;
        this.value = null;
    }

    public Value getValue() {
        return this.value;
    }

    public Path getPath() {
        return this.path;
    }

    public RValueType getType() {
        return this.type;
    }

    public JsonNode toJson() {
        switch (this.type) {
            case _value: {
                return this.value.toJson();
            }
            case _dereference: {
                ObjectNode node = RValueExpression.getFactory().objectNode();
                node.put("$valueof", this.path.toString());
                return node;
            }
            case _null: {
                return RValueExpression.getFactory().nullNode();
            }
        }
        return RValueExpression.getFactory().objectNode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RValueExpression fromJson(JsonNode node) {
        if (node instanceof ObjectNode) {
            if (node.size() != 1) return new RValueExpression();
            JsonNode path = node.get("$valueof");
            if (path == null || !path.isValueNode()) throw Error.get((String)"query-api:InvalidRValueExpression", (String)node.toString());
            return new RValueExpression(new Path(path.asText()));
        }
        if (!node.isValueNode()) throw Error.get((String)"query-api:InvalidRValueExpression", (String)node.toString());
        if (!node.asText().equals("$null")) return new RValueExpression(Value.fromJson(node));
        return new RValueExpression(RValueType._null);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode((Object)this.value);
        hash = 79 * hash + Objects.hashCode(this.path);
        hash = 79 * hash + Objects.hashCode((Object)this.type);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RValueExpression other = (RValueExpression)((Object)obj);
        if (!Objects.equals((Object)this.value, (Object)other.value)) {
            return false;
        }
        if (!Objects.equals(this.path, other.path)) {
            return false;
        }
        return this.type == other.type;
    }

    public static enum RValueType {
        _value,
        _dereference,
        _emptyObject,
        _null;

    }
}

