/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.ArrayContainsExpression;
import com.redhat.lightblue.query.ArrayMatchExpression;
import com.redhat.lightblue.query.BinaryRelationalExpression;
import com.redhat.lightblue.query.BoundValue;
import com.redhat.lightblue.query.BoundValueList;
import com.redhat.lightblue.query.ComparisonExpression;
import com.redhat.lightblue.query.ContainsOperator;
import com.redhat.lightblue.query.FieldBinding;
import com.redhat.lightblue.query.FieldComparisonExpression;
import com.redhat.lightblue.query.FieldInfo;
import com.redhat.lightblue.query.ListBinding;
import com.redhat.lightblue.query.NaryFieldRelationalExpression;
import com.redhat.lightblue.query.NaryLogicalExpression;
import com.redhat.lightblue.query.NaryLogicalOperator;
import com.redhat.lightblue.query.NaryRelationalExpression;
import com.redhat.lightblue.query.NaryRelationalOperator;
import com.redhat.lightblue.query.NaryValueRelationalExpression;
import com.redhat.lightblue.query.QueryInContext;
import com.redhat.lightblue.query.QueryIterator;
import com.redhat.lightblue.query.RegexMatchExpression;
import com.redhat.lightblue.query.UnaryLogicalExpression;
import com.redhat.lightblue.query.UnaryLogicalOperator;
import com.redhat.lightblue.query.Value;
import com.redhat.lightblue.query.ValueBinding;
import com.redhat.lightblue.query.ValueComparisonExpression;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.JsonObject;
import com.redhat.lightblue.util.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryExpression
extends JsonObject {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryExpression.class);

    public List<FieldInfo> getQueryFields() {
        ArrayList<FieldInfo> list = new ArrayList<FieldInfo>(16);
        this.getQueryFields(list);
        return list;
    }

    public void getQueryFields(List<FieldInfo> fields) {
        this.getQueryFields(fields, Path.EMPTY);
    }

    public void getQueryFields(List<FieldInfo> fields, Path ctx) {
        new GetQueryFieldsItr(fields).iterate(this, ctx);
    }

    public List<QueryInContext> getBindableClauses() {
        ArrayList<QueryInContext> list = new ArrayList<QueryInContext>();
        this.getBindableClauses(list, Path.EMPTY);
        return list;
    }

    public void getBindableClauses(List<QueryInContext> list, Path ctx) {
        new BindableClausesItr(list).iterate(this, ctx);
    }

    public QueryExpression bind(List<FieldBinding> bindingResult, Set<Path> bindRequest) {
        return this.bind(Path.EMPTY, bindingResult, bindRequest);
    }

    public QueryExpression bind(Path ctx, List<FieldBinding> bindingResult, Set<Path> bindRequest) {
        return (QueryExpression)((Object)new BindItr(bindingResult, bindRequest).iterate(this, ctx));
    }

    public static QueryExpression fromJson(JsonNode node) {
        if (node instanceof ObjectNode) {
            ObjectNode onode = (ObjectNode)node;
            String firstField = (String)onode.fieldNames().next();
            if (UnaryLogicalOperator.fromString(firstField) != null) {
                return UnaryLogicalExpression.fromJson(onode);
            }
            if (NaryLogicalOperator.fromString(firstField) != null) {
                return NaryLogicalExpression.fromJson(onode);
            }
            return ComparisonExpression.fromJson(onode);
        }
        throw Error.get((String)"query-api:InvalidQuery", (String)node.toString());
    }

    public boolean isRequired(Path field) {
        LOGGER.debug("Checking if {} is queried", (Object)field);
        return this.isRequired(field, Path.EMPTY);
    }

    public boolean isRequired(Path field, Path ctx) {
        if (this instanceof ValueComparisonExpression) {
            return QueryExpression.isFieldQueried(field, (ValueComparisonExpression)this, ctx);
        }
        if (this instanceof FieldComparisonExpression) {
            return QueryExpression.isFieldQueried(field, (FieldComparisonExpression)this, ctx);
        }
        if (this instanceof RegexMatchExpression) {
            return QueryExpression.isFieldQueried(field, (RegexMatchExpression)this, ctx);
        }
        if (this instanceof NaryRelationalExpression) {
            return QueryExpression.isFieldQueried(field, (NaryRelationalExpression)this, ctx);
        }
        if (this instanceof UnaryLogicalExpression) {
            return QueryExpression.isFieldQueried(field, (UnaryLogicalExpression)this, ctx);
        }
        if (this instanceof NaryLogicalExpression) {
            return QueryExpression.isFieldQueried(field, (NaryLogicalExpression)this, ctx);
        }
        if (this instanceof ArrayContainsExpression) {
            return QueryExpression.isFieldQueried(field, (ArrayContainsExpression)this, ctx);
        }
        if (this instanceof ArrayMatchExpression) {
            return QueryExpression.isFieldQueried(field, (ArrayMatchExpression)this, ctx);
        }
        return false;
    }

    private static boolean isFieldQueried(Path field, Path qField, Path context) {
        Path absField = new Path(context, qField);
        if (field.matchingPrefix(absField)) {
            LOGGER.debug("Field {} is queried", (Object)absField);
            return true;
        }
        LOGGER.debug("Field {} is not queried", (Object)absField);
        return false;
    }

    private static boolean isFieldQueried(Path field, ValueComparisonExpression q, Path context) {
        LOGGER.debug("Checking if field {} is queried by value comparison {}", (Object)field, (Object)q);
        return QueryExpression.isFieldQueried(field, q.getField(), context);
    }

    private static boolean isFieldQueried(Path field, FieldComparisonExpression q, Path context) {
        LOGGER.debug("Checking if field {} is queried by field comparison {}", (Object)field, (Object)q);
        return QueryExpression.isFieldQueried(field, q.getField(), context) || QueryExpression.isFieldQueried(field, q.getRfield(), context);
    }

    private static boolean isFieldQueried(Path field, RegexMatchExpression q, Path context) {
        LOGGER.debug("Checking if field {} is queried by regex {}", (Object)field, (Object)q);
        return QueryExpression.isFieldQueried(field, q.getField(), context);
    }

    private static boolean isFieldQueried(Path field, NaryRelationalExpression q, Path context) {
        LOGGER.debug("Checking if field {} is queried by expr {}", (Object)field, (Object)q);
        return QueryExpression.isFieldQueried(field, q.getField(), context);
    }

    private static boolean isFieldQueried(Path field, UnaryLogicalExpression q, Path context) {
        return q.getQuery().isRequired(field, context);
    }

    private static boolean isFieldQueried(Path field, NaryLogicalExpression q, Path context) {
        for (QueryExpression x : q.getQueries()) {
            if (!x.isRequired(field, context)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFieldQueried(Path field, ArrayContainsExpression q, Path context) {
        LOGGER.debug("Checking if field {} is queried by array expression {}", (Object)field, (Object)q);
        return QueryExpression.isFieldQueried(field, q.getArray(), context);
    }

    private static boolean isFieldQueried(Path field, ArrayMatchExpression q, Path context) {
        LOGGER.debug("Checking if field {} is queried by array expression {}", (Object)field, (Object)q);
        if (QueryExpression.isFieldQueried(field, q.getArray(), context)) {
            return true;
        }
        return q.getElemMatch().isRequired(field, new Path(new Path(context, field), Path.ANYPATH));
    }

    private static final class BindItr
    extends QueryIterator {
        private List<FieldBinding> bindingResult;
        private Set<Path> bindRequest;

        public BindItr(List<FieldBinding> bindingResult, Set<Path> bindRequest) {
            this.bindingResult = bindingResult;
            this.bindRequest = bindRequest;
        }

        private QueryExpression checkError(QueryExpression q, Path field, Path ctx) {
            if (this.bindRequest.contains(new Path(ctx, field))) {
                throw Error.get((String)"query-api:InvalidValueBinding", (String)q.toString());
            }
            return q;
        }

        @Override
        protected QueryExpression itrArrayContainsExpression(ArrayContainsExpression q, Path ctx) {
            return this.checkError(q, q.getArray(), ctx);
        }

        @Override
        protected QueryExpression itrValueComparisonExpression(ValueComparisonExpression q, Path ctx) {
            return this.checkError(q, q.getField(), ctx);
        }

        @Override
        protected QueryExpression itrRegexMatchExpression(RegexMatchExpression q, Path ctx) {
            return this.checkError(q, q.getField(), ctx);
        }

        @Override
        protected QueryExpression itrNaryValueRelationalExpression(NaryValueRelationalExpression q, Path ctx) {
            return this.checkError(q, q.getField(), ctx);
        }

        @Override
        protected QueryExpression itrNaryFieldRelationalExpression(NaryFieldRelationalExpression q, Path ctx) {
            ComparisonExpression newq = q;
            Path l = new Path(ctx, q.getField());
            Path r = new Path(ctx, q.getRfield());
            boolean bindl = this.bindRequest.contains(l);
            boolean bindr = this.bindRequest.contains(r);
            if (bindl && bindr) {
                throw Error.get((String)"query-api:InvalidValueBinding", (String)q.toString());
            }
            if (bindl || bindr) {
                if (bindr) {
                    BoundValueList newValue = new BoundValueList();
                    newq = new NaryValueRelationalExpression(q.getField(), q.getOp(), newValue);
                    this.bindingResult.add(new ListBinding(r, newValue, q, newq));
                } else {
                    BoundValue newValue = new BoundValue();
                    ArrayList<Value> list = new ArrayList<Value>(1);
                    list.add(newValue);
                    newq = new ArrayContainsExpression(q.getRfield(), q.getOp() == NaryRelationalOperator._in ? ContainsOperator._all : ContainsOperator._none, list);
                    this.bindingResult.add(new ValueBinding(l, newValue, q, newq));
                }
            }
            return newq;
        }

        @Override
        protected QueryExpression itrArrayMatchExpression(ArrayMatchExpression q, Path ctx) {
            this.checkError(q, q.getArray(), ctx);
            return super.itrArrayMatchExpression(q, ctx);
        }

        @Override
        protected QueryExpression itrFieldComparisonExpression(FieldComparisonExpression q, Path ctx) {
            BinaryRelationalExpression newq = q;
            Path l = new Path(ctx, q.getField());
            Path r = new Path(ctx, q.getRfield());
            boolean bindl = this.bindRequest.contains(l);
            boolean bindr = this.bindRequest.contains(r);
            if (bindl && bindr) {
                throw Error.get((String)"query-api:InvalidValueBinding", (String)q.toString());
            }
            if (bindl || bindr) {
                BoundValue newValue = new BoundValue();
                if (bindr) {
                    newq = new ValueComparisonExpression(q.getField(), q.getOp(), newValue);
                    this.bindingResult.add(new ValueBinding(r, newValue, q, newq));
                } else {
                    newq = new ValueComparisonExpression(q.getRfield(), q.getOp().invert(), newValue);
                    this.bindingResult.add(new ValueBinding(l, newValue, q, newq));
                }
            }
            return newq;
        }
    }

    private static final class GetQueryFieldsItr
    extends QueryIterator {
        private List<FieldInfo> fields;

        public GetQueryFieldsItr(List<FieldInfo> fields) {
            this.fields = fields;
        }

        @Override
        protected QueryExpression itrArrayContainsExpression(ArrayContainsExpression q, Path ctx) {
            this.fields.add(new FieldInfo(new Path(ctx, q.getArray()), ctx, q));
            return q;
        }

        @Override
        protected QueryExpression itrArrayMatchExpression(ArrayMatchExpression q, Path ctx) {
            this.fields.add(new FieldInfo(new Path(ctx, q.getArray()), ctx, q));
            return super.itrArrayMatchExpression(q, ctx);
        }

        @Override
        protected QueryExpression itrFieldComparisonExpression(FieldComparisonExpression q, Path ctx) {
            this.fields.add(new FieldInfo(new Path(ctx, q.getField()), ctx, q));
            this.fields.add(new FieldInfo(new Path(ctx, q.getRfield()), ctx, q));
            return q;
        }

        @Override
        protected QueryExpression itrNaryValueRelationalExpression(NaryValueRelationalExpression q, Path ctx) {
            this.fields.add(new FieldInfo(new Path(ctx, q.getField()), ctx, q));
            return q;
        }

        @Override
        protected QueryExpression itrNaryFieldRelationalExpression(NaryFieldRelationalExpression q, Path ctx) {
            this.fields.add(new FieldInfo(new Path(ctx, q.getField()), ctx, q));
            this.fields.add(new FieldInfo(new Path(ctx, q.getRfield()), ctx, q));
            return q;
        }

        @Override
        protected QueryExpression itrRegexMatchExpression(RegexMatchExpression q, Path ctx) {
            this.fields.add(new FieldInfo(new Path(ctx, q.getField()), ctx, q));
            return q;
        }

        @Override
        protected QueryExpression itrValueComparisonExpression(ValueComparisonExpression q, Path ctx) {
            this.fields.add(new FieldInfo(new Path(ctx, q.getField()), ctx, q));
            return q;
        }
    }

    private static final class BindableClausesItr
    extends QueryIterator {
        private List<QueryInContext> list;

        public BindableClausesItr(List<QueryInContext> l) {
            this.list = l;
        }

        @Override
        protected QueryExpression itrFieldComparisonExpression(FieldComparisonExpression q, Path ctx) {
            this.list.add(new QueryInContext(ctx, q));
            return q;
        }

        @Override
        protected QueryExpression itrNaryFieldRelationalExpression(NaryFieldRelationalExpression q, Path ctx) {
            this.list.add(new QueryInContext(ctx, q));
            return q;
        }
    }
}

