/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.NaryRelationalExpression;
import com.redhat.lightblue.query.NaryRelationalOperator;
import com.redhat.lightblue.query.Value;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NaryValueRelationalExpression
extends NaryRelationalExpression {
    private final List<Value> values;

    public NaryValueRelationalExpression(Path field, NaryRelationalOperator op, List<Value> values) {
        super(field, op);
        this.values = values;
    }

    public NaryValueRelationalExpression(Path field, NaryRelationalOperator op, Value ... values) {
        this(field, op, new ArrayList<Value>(values.length));
        for (Value x : values) {
            this.values.add(x);
        }
    }

    public List<Value> getValues() {
        return this.values;
    }

    public JsonNode toJson() {
        ArrayNode arr = NaryValueRelationalExpression.getFactory().arrayNode();
        for (Value x : this.values) {
            arr.add(x.toJson());
        }
        return NaryValueRelationalExpression.getFactory().objectNode().put("field", this.getField().toString()).put("op", this.getOp().toString()).set("values", (JsonNode)arr);
    }

    public static NaryValueRelationalExpression fromJson(ObjectNode node) {
        NaryRelationalOperator op;
        JsonNode x;
        if (node.size() == 3 && (x = node.get("op")) != null && (op = NaryRelationalOperator.fromString(x.asText())) != null && (x = node.get("field")) != null) {
            Path field = new Path(x.asText());
            x = node.get("values");
            if (x instanceof ArrayNode) {
                ArrayList<Value> values = new ArrayList<Value>(((ArrayNode)x).size());
                Iterator itr = ((ArrayNode)x).elements();
                while (itr.hasNext()) {
                    values.add(Value.fromJson((JsonNode)itr.next()));
                }
                return new NaryValueRelationalExpression(field, op, values);
            }
        }
        throw Error.get((String)"query-api:InvalidComparisonExpression", (String)node.toString());
    }
}

