/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.ArrayUpdateExpression;
import com.redhat.lightblue.query.ForEachUpdateExpression;
import com.redhat.lightblue.query.QueryExpression;
import com.redhat.lightblue.query.UpdateExpression;
import com.redhat.lightblue.query.UpdateQueryExpression;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class ForEachExpression
extends ArrayUpdateExpression {
    private static final long serialVersionUID = 1L;
    private final Path field;
    private final QueryExpression query;
    private final UpdateExpression update;

    public ForEachExpression(Path field, QueryExpression query, UpdateExpression update) {
        this.field = field;
        this.query = query;
        this.update = update;
    }

    public Path getField() {
        return this.field;
    }

    public QueryExpression getQuery() {
        return this.query;
    }

    public UpdateExpression getUpdate() {
        return this.update;
    }

    public JsonNode toJson() {
        ObjectNode node = ForEachExpression.getFactory().objectNode();
        ObjectNode opNode = ForEachExpression.getFactory().objectNode();
        opNode.set(this.field.toString(), this.query.toJson());
        opNode.set("$update", this.update.toJson());
        node.set("$foreach", (JsonNode)opNode);
        return node;
    }

    public static ForEachExpression fromJson(ObjectNode node) {
        ObjectNode objArg;
        JsonNode argNode;
        if (node.size() == 1 && (argNode = node.get("$foreach")) instanceof ObjectNode && (objArg = (ObjectNode)argNode).size() == 2) {
            JsonNode updateNode = null;
            JsonNode queryNode = null;
            Path field = null;
            Iterator itr = objArg.fields();
            while (itr.hasNext()) {
                Map.Entry entry = (Map.Entry)itr.next();
                if ("$update".equals(entry.getKey())) {
                    updateNode = (JsonNode)entry.getValue();
                    continue;
                }
                field = new Path((String)entry.getKey());
                queryNode = (JsonNode)entry.getValue();
            }
            if (queryNode != null && updateNode != null && field != null) {
                return new ForEachExpression(field, UpdateQueryExpression.fromJson(queryNode), ForEachUpdateExpression.fromJson(updateNode));
            }
        }
        throw Error.get((String)"query-api:InvalidArrayUpdateExpression", (String)node.toString());
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + Objects.hashCode(this.field);
        hash = 97 * hash + Objects.hashCode((Object)this.query);
        hash = 97 * hash + Objects.hashCode((Object)this.update);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ForEachExpression other = (ForEachExpression)((Object)obj);
        if (!Objects.equals(this.field, other.field)) {
            return false;
        }
        if (!Objects.equals((Object)this.query, (Object)other.query)) {
            return false;
        }
        return Objects.equals((Object)this.update, (Object)other.update);
    }
}

