/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import java.util.HashMap;
import java.util.Map;

public enum BinaryComparisonOperator {
    _eq("$eq", "="),
    _neq("$neq", "!="),
    _lt("$lt", "<"),
    _gt("$gt", ">"),
    _lte("$lte", "<="),
    _gte("$gte", ">=");

    private final String[] ops;
    private static final Map<String, BinaryComparisonOperator> MAP;

    private void init(Map<String, BinaryComparisonOperator> map) {
        for (String x : this.ops) {
            map.put(x, this);
        }
    }

    private BinaryComparisonOperator(String ... op) {
        this.ops = op;
    }

    public boolean apply(int cmp) {
        if (cmp < 0) {
            return this == _neq || this == _lt || this == _lte;
        }
        if (cmp == 0) {
            return this == _eq || this == _lte || this == _gte;
        }
        return this == _neq || this == _gt || this == _gte;
    }

    public BinaryComparisonOperator invert() {
        if (this == _eq || this == _neq) {
            return this;
        }
        if (this == _lt) {
            return _gt;
        }
        if (this == _gt) {
            return _lt;
        }
        if (this == _lte) {
            return _gte;
        }
        return _lte;
    }

    public BinaryComparisonOperator negate() {
        switch (this) {
            case _eq: {
                return _neq;
            }
            case _neq: {
                return _eq;
            }
            case _lt: {
                return _gte;
            }
            case _gt: {
                return _lte;
            }
            case _lte: {
                return _gt;
            }
        }
        return _lt;
    }

    public String toString() {
        return this.ops[0];
    }

    public static BinaryComparisonOperator fromString(String s) {
        return MAP.get(s);
    }

    static {
        MAP = new HashMap<String, BinaryComparisonOperator>();
        _eq.init(MAP);
        _neq.init(MAP);
        _lt.init(MAP);
        _gt.init(MAP);
        _lte.init(MAP);
        _gte.init(MAP);
    }
}

