/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.ArrayQueryMatchProjection;
import com.redhat.lightblue.query.ArrayRangeProjection;
import com.redhat.lightblue.query.FieldProjection;
import com.redhat.lightblue.query.Projection;
import com.redhat.lightblue.query.QueryExpression;
import com.redhat.lightblue.query.Sort;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.Path;

public abstract class BasicProjection
extends Projection {
    private static final long serialVersionUID = 1L;

    public static BasicProjection fromJson(ObjectNode node) {
        String field = node.get("field").asText();
        if (field == null) {
            throw Error.get((String)"query-api:InvalidProjection", (String)"field");
        }
        Path path = BasicProjection.getNonRelativePath(new Path(field));
        JsonNode x = node.get("include");
        boolean include = x == null ? true : x.asBoolean();
        x = node.get("project");
        Projection projection = x != null ? Projection.fromJson(x) : null;
        x = node.get("sort");
        Sort sort = x != null ? Sort.fromJson(x) : null;
        x = node.get("range");
        if (x != null) {
            if (x instanceof ArrayNode && ((ArrayNode)x).size() == 2) {
                int from = ((ArrayNode)x).get(0).asInt();
                int to = ((ArrayNode)x).get(1).asInt();
                return new ArrayRangeProjection(path, include, projection, sort, from, to);
            }
            throw Error.get((String)"query-api:InvalidArrayRangeProjection", (String)node.toString());
        }
        x = node.get("match");
        if (x != null) {
            return new ArrayQueryMatchProjection(path, include, projection, sort, QueryExpression.fromJson(x));
        }
        x = node.get("recursive");
        return new FieldProjection(path, include, x == null ? false : x.asBoolean());
    }
}

