/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.ArrayProjection;
import com.redhat.lightblue.query.Projection;
import com.redhat.lightblue.query.Sort;
import com.redhat.lightblue.util.Path;

public class ArrayRangeProjection
extends ArrayProjection {
    private static final long serialVersionUID = 1L;
    private final int from;
    private final int to;

    public ArrayRangeProjection(Path field, boolean include, Projection project, Sort sort, int from, int to) {
        super(field, include, project, sort);
        this.from = from;
        this.to = to;
    }

    public ArrayRangeProjection(Path field, boolean include, Projection project, int from, int to) {
        this(field, include, project, null, from, to);
    }

    public int getFrom() {
        return this.from;
    }

    public int getTo() {
        return this.to;
    }

    @Override
    public JsonNode toJson() {
        ArrayNode arr = ArrayRangeProjection.getFactory().arrayNode();
        arr.add((JsonNode)ArrayRangeProjection.getFactory().numberNode(this.from)).add((JsonNode)ArrayRangeProjection.getFactory().numberNode(this.to));
        return ((ObjectNode)super.toJson()).set("range", (JsonNode)arr);
    }
}

