/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.query;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.query.ArrayComparisonExpression;
import com.redhat.lightblue.query.ContainsOperator;
import com.redhat.lightblue.query.Value;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ArrayContainsExpression
extends ArrayComparisonExpression {
    private static final long serialVersionUID = 1L;
    private final Path array;
    private final ContainsOperator op;
    private final List<Value> values;

    public ArrayContainsExpression(Path array, ContainsOperator op, List<Value> values) {
        this.array = array;
        this.op = op;
        this.values = values;
    }

    public Path getArray() {
        return this.array;
    }

    public ContainsOperator getOp() {
        return this.op;
    }

    public List<Value> getValues() {
        return this.values;
    }

    public JsonNode toJson() {
        ArrayNode arr = ArrayContainsExpression.getFactory().arrayNode();
        for (Value x : this.values) {
            arr.add(x.toJson());
        }
        return ArrayContainsExpression.getFactory().objectNode().put("array", this.array.toString()).put("contains", this.op.toString()).set("values", (JsonNode)arr);
    }

    public static ArrayContainsExpression fromJson(ObjectNode node) {
        JsonNode x = node.get("array");
        if (x != null) {
            ContainsOperator op;
            Path field = new Path(x.asText());
            x = node.get("contains");
            if (x != null && (op = ContainsOperator.fromString(x.asText())) != null && (x = node.get("values")) instanceof ArrayNode) {
                ArrayList<Value> values = new ArrayList<Value>(((ArrayNode)x).size());
                Iterator itr = ((ArrayNode)x).elements();
                while (itr.hasNext()) {
                    values.add(Value.fromJson((JsonNode)itr.next()));
                }
                return new ArrayContainsExpression(field, op, values);
            }
        }
        throw Error.get((String)"query-api:InvalidArrayComparisonExpression", (String)node.toString());
    }
}

