/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.generator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.redhat.lightblue.generator.Cli;
import com.redhat.lightblue.generator.MetadataGenerator;
import com.redhat.lightblue.generator.Reflector;
import com.redhat.lightblue.generator.javabeans.JavaBeansReflector;
import com.redhat.lightblue.metadata.EntityInfo;
import com.redhat.lightblue.metadata.EntityMetadata;
import com.redhat.lightblue.metadata.TypeResolver;
import com.redhat.lightblue.metadata.parser.DataStoreParser;
import com.redhat.lightblue.metadata.parser.Extensions;
import com.redhat.lightblue.metadata.parser.JSONMetadataParser;
import com.redhat.lightblue.metadata.types.DefaultTypes;
import com.redhat.lightblue.mongo.metadata.MongoDataStoreParser;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

public class Main {
    private static Extensions<JsonNode> extensions = new Extensions();
    private static JsonNodeFactory factory;
    private static JSONMetadataParser parser;
    private static MetadataGenerator generator;
    private static ObjectMapper mapper;
    private static final Charset UTF_8;

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Cli cli = new Cli(args);
        if (cli.helpRequested()) {
            cli.printHelpTo(System.out);
            System.exit(1);
        }
        ClassLoader classLoader = Main.getClassLoaderToSearch(cli.jarPath());
        Path outputDirectory = cli.outputDirectory().map(x$0 -> Paths.get(x$0, new String[0])).orElse(Paths.get("./", new String[0]));
        if (cli.entityClasses().isEmpty()) {
            Main.println("No entity classes provided.");
            Main.println("");
            cli.printHelpTo(System.out);
            System.exit(1);
        }
        for (String className : cli.entityClasses()) {
            Class<?> classForName = classLoader.loadClass(className);
            EntityInfo info = generator.generateInfo(classForName);
            Path metadataJsonPath = outputDirectory.resolve(info.getName() + ".json").toAbsolutePath();
            EntityMetadata metadata = Main.generateMetadata(classForName, metadataJsonPath);
            JsonNode metadataJson = (JsonNode)parser.convert(metadata);
            mapper.writerWithDefaultPrettyPrinter().writeValue((Writer)Files.newBufferedWriter(metadataJsonPath, UTF_8, new OpenOption[0]), (Object)metadataJson);
            Main.println("Wrote " + metadataJsonPath);
        }
    }

    private static EntityMetadata generateMetadata(Class classForName, Path metadataJsonPath) {
        if (Files.exists(metadataJsonPath, new LinkOption[0])) {
            EntityMetadata existing;
            Main.println(metadataJsonPath + " already exists, updating...");
            try {
                JsonNode existingJsonNode = mapper.readTree(Files.readAllBytes(metadataJsonPath));
                existing = parser.parseEntityMetadata((Object)existingJsonNode);
            }
            catch (Exception e) {
                e.printStackTrace();
                Main.println("Failed to parse existing metadata.");
                Main.println("Generating new metadata instead of updating.");
                return generator.generateMetadata(classForName);
            }
            return generator.updateMetadata(existing, classForName);
        }
        return generator.generateMetadata(classForName);
    }

    private static ClassLoader getClassLoaderToSearch(Optional<String> maybeJarPath) throws MalformedURLException {
        if (maybeJarPath.isPresent()) {
            String jarPath = maybeJarPath.get();
            URL jarUrl = Paths.get(jarPath, new String[0]).toUri().toURL();
            return new URLClassLoader(new URL[]{jarUrl}, Main.class.getClassLoader());
        }
        return Main.class.getClassLoader();
    }

    static void println(Object line) {
        System.out.println(line);
    }

    static {
        extensions.addDefaultExtensions();
        extensions.registerDataStoreParser("mongo", (DataStoreParser)new MongoDataStoreParser());
        factory = JsonNodeFactory.withExactBigDecimals((boolean)true);
        parser = new JSONMetadataParser(extensions, (TypeResolver)new DefaultTypes(), factory);
        generator = new MetadataGenerator((Reflector)new JavaBeansReflector());
        mapper = new ObjectMapper();
        UTF_8 = Charset.forName("UTF-8");
    }
}

