/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue.generator;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

public class Cli {
    private static OptionParser parser = new OptionParser();
    private static OptionSpec<String> jarOption;
    private static OptionSpec<String> outputDirOption;
    private static final OptionSpec<Void> helpOption;
    private final OptionSet optionSet;

    public Cli(String[] args) {
        this.optionSet = parser.parse(args);
    }

    public boolean helpRequested() {
        return this.optionSet.has(helpOption);
    }

    public Optional<String> jarPath() {
        if (!this.optionSet.has(jarOption)) {
            return Optional.empty();
        }
        return Optional.of(this.optionSet.valueOf(jarOption));
    }

    public Optional<String> outputDirectory() {
        if (!this.optionSet.has(outputDirOption)) {
            return Optional.empty();
        }
        return Optional.of(((String)this.optionSet.valueOf(outputDirOption)).trim());
    }

    public Collection<String> entityClasses() {
        return this.optionSet.nonOptionArguments();
    }

    public void printHelpTo(OutputStream out) throws IOException {
        PrintStream printStream = new PrintStream(out);
        printStream.println("Usage: lightblue-java-generator [options] com.redhat.Entity1 com.redhat.Entity2");
        printStream.println();
        parser.printHelpOn(out);
    }

    static {
        parser.nonOptions("Fully-qualified entity class names to generate entity metadata for.");
        jarOption = parser.acceptsAll(Arrays.asList("j", "jar"), "Path to jar to search for entity classes. If not provided, the current classpath is searched instead.").withRequiredArg();
        outputDirOption = parser.acceptsAll(Arrays.asList("o", "output-to"), "Path to directory to dump output metadata json to. If a metadata file already exists for an entity at the given path, it will be updated.").withRequiredArg();
        helpOption = parser.acceptsAll(Arrays.asList("h", "?", "help"), "Displays this message.").forHelp();
    }
}

