/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.DataError;
import com.redhat.lightblue.JsonNodeBuilder;
import com.redhat.lightblue.OperationStatus;
import com.redhat.lightblue.SessionInfo;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Response
extends JsonObject {
    private static final long serialVersionUID = 1L;
    private static final String PROPERTY_STATUS = "status";
    private static final String PROPERTY_MOD_COUNT = "modifiedCount";
    private static final String PROPERTY_MATCH_COUNT = "matchCount";
    private static final String PROPERTY_TASK_HANDLE = "taskHandle";
    private static final String PROPERTY_SESSION = "session";
    private static final String PROPERTY_PROCESSED = "processed";
    private static final String PROPERTY_DATA_ERRORS = "dataErrors";
    private static final String PROPERTY_ERRORS = "errors";
    private OperationStatus status;
    private long modifiedCount;
    private long matchCount;
    private String taskHandle;
    private SessionInfo session;
    private transient JsonNode entityData;
    private final List<DataError> dataErrors = new ArrayList<DataError>();
    private final List<Error> errors = new ArrayList<Error>();

    public OperationStatus getStatus() {
        return this.status;
    }

    public void setStatus(OperationStatus s) {
        this.status = s;
    }

    public long getModifiedCount() {
        return this.modifiedCount;
    }

    public void setModifiedCount(long l) {
        this.modifiedCount = l;
    }

    public long getMatchCount() {
        return this.matchCount;
    }

    public void setMatchCount(long l) {
        this.matchCount = l;
    }

    public String getTaskHandle() {
        return this.taskHandle;
    }

    public void setTaskHandle(String t) {
        this.taskHandle = t;
    }

    public SessionInfo getSessionInfo() {
        return this.session;
    }

    public void setSessionInfo(SessionInfo s) {
        this.session = s;
    }

    public JsonNode getEntityData() {
        return this.entityData;
    }

    public void setEntityData(JsonNode node) {
        this.entityData = node;
    }

    public List<DataError> getDataErrors() {
        return this.dataErrors;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public static Response fromJson(ObjectNode node) {
        ResponseBuilder builder = new ResponseBuilder();
        builder.withStatus(node.get(PROPERTY_STATUS));
        builder.withModifiedCount(node.get(PROPERTY_MOD_COUNT));
        builder.withMatchCount(node.get(PROPERTY_MATCH_COUNT));
        builder.withTaskHandle(node.get(PROPERTY_TASK_HANDLE));
        builder.withSession(node.get(PROPERTY_SESSION));
        builder.withEntityData(node.get(PROPERTY_PROCESSED));
        builder.withDataErrors(node.get(PROPERTY_DATA_ERRORS));
        builder.withErrors(node.get(PROPERTY_ERRORS));
        return builder.buildResponse();
    }

    public JsonNode toJson() {
        JsonNodeBuilder builder = new JsonNodeBuilder();
        builder.add(PROPERTY_STATUS, this.status);
        builder.add(PROPERTY_MOD_COUNT, this.modifiedCount);
        builder.add(PROPERTY_MATCH_COUNT, this.matchCount);
        builder.add(PROPERTY_TASK_HANDLE, this.taskHandle);
        builder.add(PROPERTY_SESSION, this.session);
        builder.add(PROPERTY_PROCESSED, this.entityData);
        builder.addJsonObjectsList(PROPERTY_DATA_ERRORS, this.dataErrors);
        builder.addErrorsList(PROPERTY_ERRORS, this.errors);
        return builder.build();
    }

    public static class ResponseBuilder {
        private OperationStatus status;
        private long modifiedCount;
        private long matchCount;
        private String taskHandle;
        private SessionInfo session;
        private JsonNode entityData;
        private List<DataError> dataErrors = new ArrayList<DataError>();
        private List<Error> errors = new ArrayList<Error>();

        public ResponseBuilder() {
        }

        public ResponseBuilder(Response response) {
            this.status = response.getStatus();
            this.modifiedCount = response.getModifiedCount();
            this.matchCount = response.getMatchCount();
            this.taskHandle = response.getTaskHandle();
            this.session = response.getSessionInfo();
            this.entityData = response.getEntityData();
            this.dataErrors = response.getDataErrors();
            this.errors = response.getErrors();
        }

        public ResponseBuilder withStatus(JsonNode node) {
            if (node != null) {
                try {
                    this.status = OperationStatus.valueOf(node.asText().toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    this.status = OperationStatus.ERROR;
                }
            }
            return this;
        }

        public ResponseBuilder withModifiedCount(JsonNode node) {
            if (node != null) {
                this.modifiedCount = node.asLong();
            }
            return this;
        }

        public ResponseBuilder withMatchCount(JsonNode node) {
            if (node != null) {
                this.matchCount = node.asLong();
            }
            return this;
        }

        public ResponseBuilder withTaskHandle(JsonNode node) {
            if (node != null) {
                this.taskHandle = node.asText();
            }
            return this;
        }

        public ResponseBuilder withSession(JsonNode node) {
            return this;
        }

        public ResponseBuilder withEntityData(JsonNode node) {
            if (node != null) {
                this.entityData = node;
            }
            return this;
        }

        public ResponseBuilder withDataErrors(JsonNode node) {
            if (node instanceof ArrayNode) {
                Iterator itr = ((ArrayNode)node).elements();
                while (itr.hasNext()) {
                    this.dataErrors.add(DataError.fromJson((ObjectNode)itr.next()));
                }
            }
            return this;
        }

        public ResponseBuilder withErrors(JsonNode node) {
            if (node instanceof ArrayNode) {
                Iterator itr = ((ArrayNode)node).elements();
                while (itr.hasNext()) {
                    this.errors.add(Error.fromJson((JsonNode)((JsonNode)itr.next())));
                }
            }
            return this;
        }

        public Response buildResponse() {
            Response response = new Response();
            response.setStatus(this.status);
            response.setModifiedCount(this.modifiedCount);
            response.setMatchCount(this.matchCount);
            response.setTaskHandle(this.taskHandle);
            response.setSessionInfo(this.session);
            response.setEntityData(this.entityData);
            response.getDataErrors().addAll(this.dataErrors);
            response.getErrors().addAll(this.errors);
            return response;
        }
    }
}

