/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.ClientIdentification;
import com.redhat.lightblue.EntityVersion;
import com.redhat.lightblue.ExecutionOptions;
import com.redhat.lightblue.util.JsonObject;

public abstract class Request
extends JsonObject {
    private EntityVersion entityVersion;
    private ClientIdentification client;
    private ExecutionOptions execution;

    public EntityVersion getEntityVersion() {
        return this.entityVersion;
    }

    public void setEntityVersion(EntityVersion e) {
        this.entityVersion = e;
    }

    public ClientIdentification getClientId() {
        return this.client;
    }

    public void setClientId(ClientIdentification c) {
        this.client = c;
    }

    public ExecutionOptions getExecution() {
        return this.execution;
    }

    public void setExecution(ExecutionOptions e) {
        this.execution = e;
    }

    public JsonNode toJson() {
        ObjectNode node = Request.getFactory().objectNode();
        node.put("entity", this.entityVersion.getEntity());
        node.put("entityVersion", this.entityVersion.getVersion());
        if (this.client != null) {
            node.set("client", this.client.toJson());
        }
        if (this.execution != null) {
            node.set("execution", this.execution.toJson());
        }
        return node;
    }

    protected void parse(ObjectNode node) {
        this.entityVersion = new EntityVersion();
        JsonNode x = node.get("entity");
        if (x != null) {
            this.entityVersion.setEntity(x.asText());
        }
        if ((x = node.get("entityVersion")) != null) {
            this.entityVersion.setVersion(x.asText());
        }
        if ((x = node.get("execution")) != null) {
            this.execution = ExecutionOptions.fromJson((ObjectNode)x);
        }
    }
}

