/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.OperationStatus;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.JsonObject;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;

public class JsonNodeBuilder {
    private final ObjectNode root = JsonObject.getFactory().objectNode();
    private boolean includeNulls = false;

    protected ObjectNode getRoot() {
        return this.root;
    }

    public boolean includeNulls() {
        return this.includeNulls;
    }

    public void includeNulls(boolean include) {
        this.includeNulls = include;
    }

    public JsonNodeBuilder add(String key, JsonNode value) {
        if (this.include(value)) {
            this.root.put(key, value);
        }
        return this;
    }

    public JsonNodeBuilder add(String key, Comparator value) {
        if (this.include(value)) {
            this.root.put(key, value.toString());
        }
        return this;
    }

    public JsonNodeBuilder add(String key, Long value) {
        if (this.include(value)) {
            this.root.put(key, value);
        }
        return this;
    }

    public JsonNodeBuilder add(String key, Boolean value) {
        if (this.include(value)) {
            this.root.put(key, value);
        }
        return this;
    }

    public JsonNodeBuilder add(String key, OperationStatus value) {
        if (this.include((Object)value)) {
            this.root.put(key, value.name().toString());
        }
        return this;
    }

    public JsonNodeBuilder add(String key, JsonObject value) {
        if (this.include(value)) {
            this.root.put(key, value.toJson());
        }
        return this;
    }

    public <T> JsonNodeBuilder add(String key, List<T> values) {
        if (this.includes(values)) {
            ArrayNode arr = JsonObject.getFactory().arrayNode();
            this.root.set(key, (JsonNode)arr);
            for (T err : values) {
                arr.add(err.toString());
            }
        }
        return this;
    }

    public <T> JsonNodeBuilder addJsonObjectsList(String key, List<? extends JsonObject> values) {
        if (this.includes(values)) {
            ArrayNode arr = JsonObject.getFactory().arrayNode();
            this.root.set(key, (JsonNode)arr);
            for (JsonObject jsonObject : values) {
                arr.add(jsonObject.toJson());
            }
        }
        return this;
    }

    public <T> JsonNodeBuilder addErrorsList(String key, List<Error> values) {
        if (this.includes(values)) {
            ArrayNode arr = JsonObject.getFactory().arrayNode();
            this.root.set(key, (JsonNode)arr);
            for (Error err : values) {
                arr.add(err.toJson());
            }
        }
        return this;
    }

    protected boolean include(Object object) {
        return object != null || this.includeNulls;
    }

    private <T> boolean includes(Collection<T> collection) {
        if (this.includeNulls) {
            return true;
        }
        return collection != null && !collection.isEmpty();
    }

    public JsonNodeBuilder add(String key, String value) {
        if (value != null) {
            this.root.put(key, value);
        }
        return this;
    }

    public JsonNode build() {
        return this.root;
    }
}

