/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.lightblue;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.redhat.lightblue.util.Error;
import com.redhat.lightblue.util.JsonObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DataError
extends JsonObject {
    private JsonNode entityData;
    private List<Error> errors;

    public DataError() {
    }

    public DataError(JsonNode entityData, List<Error> errors) {
        this.entityData = entityData;
        this.errors = errors;
    }

    public JsonNode getEntityData() {
        return this.entityData;
    }

    public void setEntityData(JsonNode node) {
        this.entityData = node;
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public void setErrors(List<Error> e) {
        this.errors = e;
    }

    public JsonNode toJson() {
        ObjectNode node = DataError.getFactory().objectNode();
        if (this.entityData != null) {
            node.set("data", this.entityData);
        }
        if (this.errors != null && !this.errors.isEmpty()) {
            ArrayNode arr = DataError.getFactory().arrayNode();
            node.set("errors", (JsonNode)arr);
            for (Error x : this.errors) {
                arr.add(x.toJson());
            }
        }
        return node;
    }

    public static DataError fromJson(ObjectNode node) {
        DataError error = new DataError();
        JsonNode x = node.get("data");
        if (x != null) {
            error.entityData = x;
        }
        if ((x = node.get("errors")) instanceof ArrayNode) {
            error.errors = new ArrayList<Error>();
            Iterator itr = ((ArrayNode)x).elements();
            while (itr.hasNext()) {
                error.errors.add(Error.fromJson((JsonNode)((JsonNode)itr.next())));
            }
        }
        return error;
    }

    public static DataError findErrorForDoc(List<DataError> list, JsonNode node) {
        for (DataError x : list) {
            if (x.entityData != node) continue;
            return x;
        }
        return null;
    }
}

