/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.cloud.api.kas.auth.api.v1.topics.item;

import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestHeaders;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.RequestOption;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import com.openshift.cloud.api.kas.auth.api.v1.topics.item.records.RecordsRequestBuilder;
import com.openshift.cloud.api.kas.auth.models.Error;
import com.openshift.cloud.api.kas.auth.models.Topic;
import com.openshift.cloud.api.kas.auth.models.TopicSettings;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WithTopicNameItemRequestBuilder {
    private HashMap<String, Object> pathParameters;
    private RequestAdapter requestAdapter;
    private String urlTemplate;

    @Nonnull
    public RecordsRequestBuilder records() {
        return new RecordsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nullable
    public WithTopicNameItemRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        Objects.requireNonNull(pathParameters);
        Objects.requireNonNull(requestAdapter);
        this.urlTemplate = "{+baseurl}/api/v1/topics/{topicName}";
        HashMap<String, Object> urlTplParams = new HashMap<String, Object>(pathParameters);
        this.pathParameters = urlTplParams;
        this.requestAdapter = requestAdapter;
    }

    @Nullable
    public WithTopicNameItemRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        this.urlTemplate = "{+baseurl}/api/v1/topics/{topicName}";
        HashMap<String, String> urlTplParams = new HashMap<String, String>();
        urlTplParams.put("request-raw-url", rawUrl);
        this.pathParameters = urlTplParams;
        this.requestAdapter = requestAdapter;
    }

    @Nonnull
    public CompletableFuture<Void> delete() {
        try {
            RequestInformation requestInfo = this.toDeleteRequestInformation(null);
            HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
            errorMapping.put("401", Error::createFromDiscriminatorValue);
            errorMapping.put("403", Error::createFromDiscriminatorValue);
            errorMapping.put("404", Error::createFromDiscriminatorValue);
            errorMapping.put("500", Error::createFromDiscriminatorValue);
            errorMapping.put("503", Error::createFromDiscriminatorValue);
            return this.requestAdapter.sendPrimitiveAsync(requestInfo, Void.class, errorMapping);
        }
        catch (URISyntaxException ex) {
            CompletableFuture<Void> executionException = new CompletableFuture<Void>();
            executionException.completeExceptionally(ex);
            return executionException;
        }
    }

    @Nonnull
    public CompletableFuture<Void> delete(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        try {
            RequestInformation requestInfo = this.toDeleteRequestInformation(requestConfiguration);
            HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
            errorMapping.put("401", Error::createFromDiscriminatorValue);
            errorMapping.put("403", Error::createFromDiscriminatorValue);
            errorMapping.put("404", Error::createFromDiscriminatorValue);
            errorMapping.put("500", Error::createFromDiscriminatorValue);
            errorMapping.put("503", Error::createFromDiscriminatorValue);
            return this.requestAdapter.sendPrimitiveAsync(requestInfo, Void.class, errorMapping);
        }
        catch (URISyntaxException ex) {
            CompletableFuture<Void> executionException = new CompletableFuture<Void>();
            executionException.completeExceptionally(ex);
            return executionException;
        }
    }

    @Nonnull
    public CompletableFuture<Topic> get() {
        try {
            RequestInformation requestInfo = this.toGetRequestInformation(null);
            HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
            errorMapping.put("401", Error::createFromDiscriminatorValue);
            errorMapping.put("403", Error::createFromDiscriminatorValue);
            errorMapping.put("404", Error::createFromDiscriminatorValue);
            errorMapping.put("500", Error::createFromDiscriminatorValue);
            errorMapping.put("503", Error::createFromDiscriminatorValue);
            return this.requestAdapter.sendAsync(requestInfo, Topic::createFromDiscriminatorValue, errorMapping);
        }
        catch (URISyntaxException ex) {
            CompletableFuture<Topic> executionException = new CompletableFuture<Topic>();
            executionException.completeExceptionally(ex);
            return executionException;
        }
    }

    @Nonnull
    public CompletableFuture<Topic> get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        try {
            RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
            HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
            errorMapping.put("401", Error::createFromDiscriminatorValue);
            errorMapping.put("403", Error::createFromDiscriminatorValue);
            errorMapping.put("404", Error::createFromDiscriminatorValue);
            errorMapping.put("500", Error::createFromDiscriminatorValue);
            errorMapping.put("503", Error::createFromDiscriminatorValue);
            return this.requestAdapter.sendAsync(requestInfo, Topic::createFromDiscriminatorValue, errorMapping);
        }
        catch (URISyntaxException ex) {
            CompletableFuture<Topic> executionException = new CompletableFuture<Topic>();
            executionException.completeExceptionally(ex);
            return executionException;
        }
    }

    @Nonnull
    public CompletableFuture<Topic> patch(@Nonnull TopicSettings body) {
        try {
            RequestInformation requestInfo = this.toPatchRequestInformation(body, null);
            HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
            errorMapping.put("400", Error::createFromDiscriminatorValue);
            errorMapping.put("401", Error::createFromDiscriminatorValue);
            errorMapping.put("403", Error::createFromDiscriminatorValue);
            errorMapping.put("404", Error::createFromDiscriminatorValue);
            errorMapping.put("500", Error::createFromDiscriminatorValue);
            errorMapping.put("503", Error::createFromDiscriminatorValue);
            return this.requestAdapter.sendAsync(requestInfo, Topic::createFromDiscriminatorValue, errorMapping);
        }
        catch (URISyntaxException ex) {
            CompletableFuture<Topic> executionException = new CompletableFuture<Topic>();
            executionException.completeExceptionally(ex);
            return executionException;
        }
    }

    @Nonnull
    public CompletableFuture<Topic> patch(@Nonnull TopicSettings body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        try {
            RequestInformation requestInfo = this.toPatchRequestInformation(body, requestConfiguration);
            HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
            errorMapping.put("400", Error::createFromDiscriminatorValue);
            errorMapping.put("401", Error::createFromDiscriminatorValue);
            errorMapping.put("403", Error::createFromDiscriminatorValue);
            errorMapping.put("404", Error::createFromDiscriminatorValue);
            errorMapping.put("500", Error::createFromDiscriminatorValue);
            errorMapping.put("503", Error::createFromDiscriminatorValue);
            return this.requestAdapter.sendAsync(requestInfo, Topic::createFromDiscriminatorValue, errorMapping);
        }
        catch (URISyntaxException ex) {
            CompletableFuture<Topic> executionException = new CompletableFuture<Topic>();
            executionException.completeExceptionally(ex);
            return executionException;
        }
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation() throws URISyntaxException {
        return this.toDeleteRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) throws URISyntaxException {
        RequestInformation requestInfo = new RequestInformation();
        requestInfo.httpMethod = HttpMethod.DELETE;
        requestInfo.urlTemplate = this.urlTemplate;
        requestInfo.pathParameters = this.pathParameters;
        if (requestConfiguration != null) {
            DeleteRequestConfiguration requestConfig = new DeleteRequestConfiguration();
            requestConfiguration.accept(requestConfig);
            requestInfo.headers.putAll((Map)requestConfig.headers);
            requestInfo.addRequestOptions(requestConfig.options);
        }
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() throws URISyntaxException {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) throws URISyntaxException {
        RequestInformation requestInfo = new RequestInformation();
        requestInfo.httpMethod = HttpMethod.GET;
        requestInfo.urlTemplate = this.urlTemplate;
        requestInfo.pathParameters = this.pathParameters;
        requestInfo.headers.add("Accept", "application/json");
        if (requestConfiguration != null) {
            GetRequestConfiguration requestConfig = new GetRequestConfiguration();
            requestConfiguration.accept(requestConfig);
            requestInfo.headers.putAll((Map)requestConfig.headers);
            requestInfo.addRequestOptions(requestConfig.options);
        }
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull TopicSettings body) throws URISyntaxException {
        return this.toPatchRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPatchRequestInformation(@Nonnull TopicSettings body, @Nullable Consumer<PatchRequestConfiguration> requestConfiguration) throws URISyntaxException {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation();
        requestInfo.httpMethod = HttpMethod.PATCH;
        requestInfo.urlTemplate = this.urlTemplate;
        requestInfo.pathParameters = this.pathParameters;
        requestInfo.headers.add("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        if (requestConfiguration != null) {
            PatchRequestConfiguration requestConfig = new PatchRequestConfiguration();
            requestConfiguration.accept(requestConfig);
            requestInfo.headers.putAll((Map)requestConfig.headers);
            requestInfo.addRequestOptions(requestConfig.options);
        }
        return requestInfo;
    }

    public class PatchRequestConfiguration {
        @Nullable
        public RequestHeaders headers = new RequestHeaders();
        @Nullable
        public List<RequestOption> options = Collections.emptyList();

        @Nullable
        public PatchRequestConfiguration() {
        }
    }

    public class GetRequestConfiguration {
        @Nullable
        public RequestHeaders headers = new RequestHeaders();
        @Nullable
        public List<RequestOption> options = Collections.emptyList();

        @Nullable
        public GetRequestConfiguration() {
        }
    }

    public class DeleteRequestConfiguration {
        @Nullable
        public RequestHeaders headers = new RequestHeaders();
        @Nullable
        public List<RequestOption> options = Collections.emptyList();

        @Nullable
        public DeleteRequestConfiguration() {
        }
    }
}

