/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.cloud.api.kas.auth.api.v1.errors;

import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestHeaders;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.RequestOption;
import com.microsoft.kiota.serialization.ParsableFactory;
import com.openshift.cloud.api.kas.auth.models.Error;
import com.openshift.cloud.api.kas.auth.models.ErrorList;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ErrorsRequestBuilder {
    private HashMap<String, Object> pathParameters;
    private RequestAdapter requestAdapter;
    private String urlTemplate;

    @Nullable
    public ErrorsRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        Objects.requireNonNull(pathParameters);
        Objects.requireNonNull(requestAdapter);
        this.urlTemplate = "{+baseurl}/api/v1/errors";
        HashMap<String, Object> urlTplParams = new HashMap<String, Object>(pathParameters);
        this.pathParameters = urlTplParams;
        this.requestAdapter = requestAdapter;
    }

    @Nullable
    public ErrorsRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        this.urlTemplate = "{+baseurl}/api/v1/errors";
        HashMap<String, String> urlTplParams = new HashMap<String, String>();
        urlTplParams.put("request-raw-url", rawUrl);
        this.pathParameters = urlTplParams;
        this.requestAdapter = requestAdapter;
    }

    @Nonnull
    public CompletableFuture<ErrorList> get() {
        try {
            RequestInformation requestInfo = this.toGetRequestInformation(null);
            HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
            errorMapping.put("500", Error::createFromDiscriminatorValue);
            return this.requestAdapter.sendAsync(requestInfo, ErrorList::createFromDiscriminatorValue, errorMapping);
        }
        catch (URISyntaxException ex) {
            CompletableFuture<ErrorList> executionException = new CompletableFuture<ErrorList>();
            executionException.completeExceptionally(ex);
            return executionException;
        }
    }

    @Nonnull
    public CompletableFuture<ErrorList> get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        try {
            RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
            HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
            errorMapping.put("500", Error::createFromDiscriminatorValue);
            return this.requestAdapter.sendAsync(requestInfo, ErrorList::createFromDiscriminatorValue, errorMapping);
        }
        catch (URISyntaxException ex) {
            CompletableFuture<ErrorList> executionException = new CompletableFuture<ErrorList>();
            executionException.completeExceptionally(ex);
            return executionException;
        }
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() throws URISyntaxException {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) throws URISyntaxException {
        RequestInformation requestInfo = new RequestInformation();
        requestInfo.httpMethod = HttpMethod.GET;
        requestInfo.urlTemplate = this.urlTemplate;
        requestInfo.pathParameters = this.pathParameters;
        requestInfo.headers.add("Accept", "application/json");
        if (requestConfiguration != null) {
            GetRequestConfiguration requestConfig = new GetRequestConfiguration();
            requestConfiguration.accept(requestConfig);
            requestInfo.headers.putAll((Map)requestConfig.headers);
            requestInfo.addRequestOptions(requestConfig.options);
        }
        return requestInfo;
    }

    public class GetRequestConfiguration {
        @Nullable
        public RequestHeaders headers = new RequestHeaders();
        @Nullable
        public List<RequestOption> options = Collections.emptyList();

        @Nullable
        public GetRequestConfiguration() {
        }
    }
}

