/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.cloud.api.kas.auth.api.v1.consumergroups.item.resetoffset;

import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestHeaders;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.RequestOption;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import com.openshift.cloud.api.kas.auth.models.ConsumerGroupResetOffsetParameters;
import com.openshift.cloud.api.kas.auth.models.ConsumerGroupResetOffsetResult;
import com.openshift.cloud.api.kas.auth.models.Error;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ResetOffsetRequestBuilder {
    private HashMap<String, Object> pathParameters;
    private RequestAdapter requestAdapter;
    private String urlTemplate;

    @Nullable
    public ResetOffsetRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        Objects.requireNonNull(pathParameters);
        Objects.requireNonNull(requestAdapter);
        this.urlTemplate = "{+baseurl}/api/v1/consumer-groups/{consumerGroupId}/reset-offset";
        HashMap<String, Object> urlTplParams = new HashMap<String, Object>(pathParameters);
        this.pathParameters = urlTplParams;
        this.requestAdapter = requestAdapter;
    }

    @Nullable
    public ResetOffsetRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        this.urlTemplate = "{+baseurl}/api/v1/consumer-groups/{consumerGroupId}/reset-offset";
        HashMap<String, String> urlTplParams = new HashMap<String, String>();
        urlTplParams.put("request-raw-url", rawUrl);
        this.pathParameters = urlTplParams;
        this.requestAdapter = requestAdapter;
    }

    @Nonnull
    public CompletableFuture<ConsumerGroupResetOffsetResult> post(@Nonnull ConsumerGroupResetOffsetParameters body) {
        try {
            RequestInformation requestInfo = this.toPostRequestInformation(body, null);
            HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
            errorMapping.put("400", Error::createFromDiscriminatorValue);
            errorMapping.put("401", Error::createFromDiscriminatorValue);
            errorMapping.put("403", Error::createFromDiscriminatorValue);
            errorMapping.put("404", Error::createFromDiscriminatorValue);
            errorMapping.put("500", Error::createFromDiscriminatorValue);
            errorMapping.put("503", Error::createFromDiscriminatorValue);
            return this.requestAdapter.sendAsync(requestInfo, ConsumerGroupResetOffsetResult::createFromDiscriminatorValue, errorMapping);
        }
        catch (URISyntaxException ex) {
            CompletableFuture<ConsumerGroupResetOffsetResult> executionException = new CompletableFuture<ConsumerGroupResetOffsetResult>();
            executionException.completeExceptionally(ex);
            return executionException;
        }
    }

    @Nonnull
    public CompletableFuture<ConsumerGroupResetOffsetResult> post(@Nonnull ConsumerGroupResetOffsetParameters body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        try {
            RequestInformation requestInfo = this.toPostRequestInformation(body, requestConfiguration);
            HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
            errorMapping.put("400", Error::createFromDiscriminatorValue);
            errorMapping.put("401", Error::createFromDiscriminatorValue);
            errorMapping.put("403", Error::createFromDiscriminatorValue);
            errorMapping.put("404", Error::createFromDiscriminatorValue);
            errorMapping.put("500", Error::createFromDiscriminatorValue);
            errorMapping.put("503", Error::createFromDiscriminatorValue);
            return this.requestAdapter.sendAsync(requestInfo, ConsumerGroupResetOffsetResult::createFromDiscriminatorValue, errorMapping);
        }
        catch (URISyntaxException ex) {
            CompletableFuture<ConsumerGroupResetOffsetResult> executionException = new CompletableFuture<ConsumerGroupResetOffsetResult>();
            executionException.completeExceptionally(ex);
            return executionException;
        }
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull ConsumerGroupResetOffsetParameters body) throws URISyntaxException {
        return this.toPostRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull ConsumerGroupResetOffsetParameters body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) throws URISyntaxException {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation();
        requestInfo.httpMethod = HttpMethod.POST;
        requestInfo.urlTemplate = this.urlTemplate;
        requestInfo.pathParameters = this.pathParameters;
        requestInfo.headers.add("Accept", "application/json");
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        if (requestConfiguration != null) {
            PostRequestConfiguration requestConfig = new PostRequestConfiguration();
            requestConfiguration.accept(requestConfig);
            requestInfo.headers.putAll((Map)requestConfig.headers);
            requestInfo.addRequestOptions(requestConfig.options);
        }
        return requestInfo;
    }

    public class PostRequestConfiguration {
        @Nullable
        public RequestHeaders headers = new RequestHeaders();
        @Nullable
        public List<RequestOption> options = Collections.emptyList();

        @Nullable
        public PostRequestConfiguration() {
        }
    }
}

