/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.cloud.api.kas.auth.api.v1.consumergroups;

import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.QueryParameter;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestHeaders;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.RequestOption;
import com.microsoft.kiota.serialization.ParsableFactory;
import com.openshift.cloud.api.kas.auth.models.ConsumerGroupList;
import com.openshift.cloud.api.kas.auth.models.Error;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConsumerGroupsRequestBuilder {
    private HashMap<String, Object> pathParameters;
    private RequestAdapter requestAdapter;
    private String urlTemplate;

    @Nullable
    public ConsumerGroupsRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        Objects.requireNonNull(pathParameters);
        Objects.requireNonNull(requestAdapter);
        this.urlTemplate = "{+baseurl}/api/v1/consumer-groups{?offset*,limit*,size*,page*,topic*,group%2Did%2Dfilter*,order*,orderKey*}";
        HashMap<String, Object> urlTplParams = new HashMap<String, Object>(pathParameters);
        this.pathParameters = urlTplParams;
        this.requestAdapter = requestAdapter;
    }

    @Nullable
    public ConsumerGroupsRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        this.urlTemplate = "{+baseurl}/api/v1/consumer-groups{?offset*,limit*,size*,page*,topic*,group%2Did%2Dfilter*,order*,orderKey*}";
        HashMap<String, String> urlTplParams = new HashMap<String, String>();
        urlTplParams.put("request-raw-url", rawUrl);
        this.pathParameters = urlTplParams;
        this.requestAdapter = requestAdapter;
    }

    @Nonnull
    public CompletableFuture<ConsumerGroupList> get() {
        try {
            RequestInformation requestInfo = this.toGetRequestInformation(null);
            HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
            errorMapping.put("400", Error::createFromDiscriminatorValue);
            errorMapping.put("401", Error::createFromDiscriminatorValue);
            errorMapping.put("403", Error::createFromDiscriminatorValue);
            errorMapping.put("500", Error::createFromDiscriminatorValue);
            errorMapping.put("503", Error::createFromDiscriminatorValue);
            return this.requestAdapter.sendAsync(requestInfo, ConsumerGroupList::createFromDiscriminatorValue, errorMapping);
        }
        catch (URISyntaxException ex) {
            CompletableFuture<ConsumerGroupList> executionException = new CompletableFuture<ConsumerGroupList>();
            executionException.completeExceptionally(ex);
            return executionException;
        }
    }

    @Nonnull
    public CompletableFuture<ConsumerGroupList> get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        try {
            RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
            HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
            errorMapping.put("400", Error::createFromDiscriminatorValue);
            errorMapping.put("401", Error::createFromDiscriminatorValue);
            errorMapping.put("403", Error::createFromDiscriminatorValue);
            errorMapping.put("500", Error::createFromDiscriminatorValue);
            errorMapping.put("503", Error::createFromDiscriminatorValue);
            return this.requestAdapter.sendAsync(requestInfo, ConsumerGroupList::createFromDiscriminatorValue, errorMapping);
        }
        catch (URISyntaxException ex) {
            CompletableFuture<ConsumerGroupList> executionException = new CompletableFuture<ConsumerGroupList>();
            executionException.completeExceptionally(ex);
            return executionException;
        }
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() throws URISyntaxException {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) throws URISyntaxException {
        RequestInformation requestInfo = new RequestInformation();
        requestInfo.httpMethod = HttpMethod.GET;
        requestInfo.urlTemplate = this.urlTemplate;
        requestInfo.pathParameters = this.pathParameters;
        requestInfo.headers.add("Accept", "application/json");
        if (requestConfiguration != null) {
            GetRequestConfiguration requestConfig = new GetRequestConfiguration();
            requestConfiguration.accept(requestConfig);
            requestInfo.addQueryParameters((Object)requestConfig.queryParameters);
            requestInfo.headers.putAll((Map)requestConfig.headers);
            requestInfo.addRequestOptions(requestConfig.options);
        }
        return requestInfo;
    }

    public class GetRequestConfiguration {
        @Nullable
        public RequestHeaders headers = new RequestHeaders();
        @Nullable
        public List<RequestOption> options = Collections.emptyList();
        @Nullable
        public GetQueryParameters queryParameters = new GetQueryParameters();

        @Nullable
        public GetRequestConfiguration() {
        }
    }

    public class GetQueryParameters {
        @QueryParameter(name="group%2Did%2Dfilter")
        @Nullable
        public String groupIdFilter;
        @Nullable
        public Integer limit;
        @Nullable
        public Integer offset;
        @Nullable
        public String order;
        @Nullable
        public String orderKey;
        @Nullable
        public Integer page;
        @Nullable
        public Integer size;
        @Nullable
        public String topic;
    }
}

