/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.cloud.api.kas.auth.api.v1.acls;

import com.microsoft.kiota.HttpMethod;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.RequestHeaders;
import com.microsoft.kiota.RequestInformation;
import com.microsoft.kiota.RequestOption;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import com.openshift.cloud.api.kas.auth.api.v1.acls.resourceoperations.ResourceOperationsRequestBuilder;
import com.openshift.cloud.api.kas.auth.models.AclBinding;
import com.openshift.cloud.api.kas.auth.models.AclBindingListPage;
import com.openshift.cloud.api.kas.auth.models.Error;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AclsRequestBuilder {
    private HashMap<String, Object> pathParameters;
    private RequestAdapter requestAdapter;
    private String urlTemplate;

    @Nonnull
    public ResourceOperationsRequestBuilder resourceOperations() {
        return new ResourceOperationsRequestBuilder(this.pathParameters, this.requestAdapter);
    }

    @Nullable
    public AclsRequestBuilder(@Nonnull HashMap<String, Object> pathParameters, @Nonnull RequestAdapter requestAdapter) {
        Objects.requireNonNull(pathParameters);
        Objects.requireNonNull(requestAdapter);
        this.urlTemplate = "{+baseurl}/api/v1/acls{?resourceType*,resourceName*,patternType*,principal*,operation*,permission*,page*,size*,order*,orderKey*,resourceType*,resourceName*,patternType*,principal*,operation*,permission*}";
        HashMap<String, Object> urlTplParams = new HashMap<String, Object>(pathParameters);
        this.pathParameters = urlTplParams;
        this.requestAdapter = requestAdapter;
    }

    @Nullable
    public AclsRequestBuilder(@Nonnull String rawUrl, @Nonnull RequestAdapter requestAdapter) {
        this.urlTemplate = "{+baseurl}/api/v1/acls{?resourceType*,resourceName*,patternType*,principal*,operation*,permission*,page*,size*,order*,orderKey*,resourceType*,resourceName*,patternType*,principal*,operation*,permission*}";
        HashMap<String, String> urlTplParams = new HashMap<String, String>();
        urlTplParams.put("request-raw-url", rawUrl);
        this.pathParameters = urlTplParams;
        this.requestAdapter = requestAdapter;
    }

    @Nonnull
    public CompletableFuture<AclBindingListPage> delete() {
        try {
            RequestInformation requestInfo = this.toDeleteRequestInformation(null);
            HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
            errorMapping.put("400", Error::createFromDiscriminatorValue);
            errorMapping.put("401", Error::createFromDiscriminatorValue);
            errorMapping.put("403", Error::createFromDiscriminatorValue);
            errorMapping.put("500", Error::createFromDiscriminatorValue);
            errorMapping.put("503", Error::createFromDiscriminatorValue);
            return this.requestAdapter.sendAsync(requestInfo, AclBindingListPage::createFromDiscriminatorValue, errorMapping);
        }
        catch (URISyntaxException ex) {
            CompletableFuture<AclBindingListPage> executionException = new CompletableFuture<AclBindingListPage>();
            executionException.completeExceptionally(ex);
            return executionException;
        }
    }

    @Nonnull
    public CompletableFuture<AclBindingListPage> delete(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) {
        try {
            RequestInformation requestInfo = this.toDeleteRequestInformation(requestConfiguration);
            HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
            errorMapping.put("400", Error::createFromDiscriminatorValue);
            errorMapping.put("401", Error::createFromDiscriminatorValue);
            errorMapping.put("403", Error::createFromDiscriminatorValue);
            errorMapping.put("500", Error::createFromDiscriminatorValue);
            errorMapping.put("503", Error::createFromDiscriminatorValue);
            return this.requestAdapter.sendAsync(requestInfo, AclBindingListPage::createFromDiscriminatorValue, errorMapping);
        }
        catch (URISyntaxException ex) {
            CompletableFuture<AclBindingListPage> executionException = new CompletableFuture<AclBindingListPage>();
            executionException.completeExceptionally(ex);
            return executionException;
        }
    }

    @Nonnull
    public CompletableFuture<AclBindingListPage> get() {
        try {
            RequestInformation requestInfo = this.toGetRequestInformation(null);
            HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
            errorMapping.put("400", Error::createFromDiscriminatorValue);
            errorMapping.put("401", Error::createFromDiscriminatorValue);
            errorMapping.put("403", Error::createFromDiscriminatorValue);
            errorMapping.put("500", Error::createFromDiscriminatorValue);
            errorMapping.put("503", Error::createFromDiscriminatorValue);
            return this.requestAdapter.sendAsync(requestInfo, AclBindingListPage::createFromDiscriminatorValue, errorMapping);
        }
        catch (URISyntaxException ex) {
            CompletableFuture<AclBindingListPage> executionException = new CompletableFuture<AclBindingListPage>();
            executionException.completeExceptionally(ex);
            return executionException;
        }
    }

    @Nonnull
    public CompletableFuture<AclBindingListPage> get(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) {
        try {
            RequestInformation requestInfo = this.toGetRequestInformation(requestConfiguration);
            HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
            errorMapping.put("400", Error::createFromDiscriminatorValue);
            errorMapping.put("401", Error::createFromDiscriminatorValue);
            errorMapping.put("403", Error::createFromDiscriminatorValue);
            errorMapping.put("500", Error::createFromDiscriminatorValue);
            errorMapping.put("503", Error::createFromDiscriminatorValue);
            return this.requestAdapter.sendAsync(requestInfo, AclBindingListPage::createFromDiscriminatorValue, errorMapping);
        }
        catch (URISyntaxException ex) {
            CompletableFuture<AclBindingListPage> executionException = new CompletableFuture<AclBindingListPage>();
            executionException.completeExceptionally(ex);
            return executionException;
        }
    }

    @Nonnull
    public CompletableFuture<Void> post(@Nonnull AclBinding body) {
        try {
            RequestInformation requestInfo = this.toPostRequestInformation(body, null);
            HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
            errorMapping.put("400", Error::createFromDiscriminatorValue);
            errorMapping.put("401", Error::createFromDiscriminatorValue);
            errorMapping.put("403", Error::createFromDiscriminatorValue);
            errorMapping.put("500", Error::createFromDiscriminatorValue);
            errorMapping.put("503", Error::createFromDiscriminatorValue);
            return this.requestAdapter.sendPrimitiveAsync(requestInfo, Void.class, errorMapping);
        }
        catch (URISyntaxException ex) {
            CompletableFuture<Void> executionException = new CompletableFuture<Void>();
            executionException.completeExceptionally(ex);
            return executionException;
        }
    }

    @Nonnull
    public CompletableFuture<Void> post(@Nonnull AclBinding body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) {
        Objects.requireNonNull(body);
        try {
            RequestInformation requestInfo = this.toPostRequestInformation(body, requestConfiguration);
            HashMap<String, ParsableFactory> errorMapping = new HashMap<String, ParsableFactory>();
            errorMapping.put("400", Error::createFromDiscriminatorValue);
            errorMapping.put("401", Error::createFromDiscriminatorValue);
            errorMapping.put("403", Error::createFromDiscriminatorValue);
            errorMapping.put("500", Error::createFromDiscriminatorValue);
            errorMapping.put("503", Error::createFromDiscriminatorValue);
            return this.requestAdapter.sendPrimitiveAsync(requestInfo, Void.class, errorMapping);
        }
        catch (URISyntaxException ex) {
            CompletableFuture<Void> executionException = new CompletableFuture<Void>();
            executionException.completeExceptionally(ex);
            return executionException;
        }
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation() throws URISyntaxException {
        return this.toDeleteRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toDeleteRequestInformation(@Nullable Consumer<DeleteRequestConfiguration> requestConfiguration) throws URISyntaxException {
        RequestInformation requestInfo = new RequestInformation();
        requestInfo.httpMethod = HttpMethod.DELETE;
        requestInfo.urlTemplate = this.urlTemplate;
        requestInfo.pathParameters = this.pathParameters;
        requestInfo.headers.add("Accept", "application/json");
        if (requestConfiguration != null) {
            DeleteRequestConfiguration requestConfig = new DeleteRequestConfiguration();
            requestConfiguration.accept(requestConfig);
            requestInfo.addQueryParameters((Object)requestConfig.queryParameters);
            requestInfo.headers.putAll((Map)requestConfig.headers);
            requestInfo.addRequestOptions(requestConfig.options);
        }
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toGetRequestInformation() throws URISyntaxException {
        return this.toGetRequestInformation(null);
    }

    @Nonnull
    public RequestInformation toGetRequestInformation(@Nullable Consumer<GetRequestConfiguration> requestConfiguration) throws URISyntaxException {
        RequestInformation requestInfo = new RequestInformation();
        requestInfo.httpMethod = HttpMethod.GET;
        requestInfo.urlTemplate = this.urlTemplate;
        requestInfo.pathParameters = this.pathParameters;
        requestInfo.headers.add("Accept", "application/json");
        if (requestConfiguration != null) {
            GetRequestConfiguration requestConfig = new GetRequestConfiguration();
            requestConfiguration.accept(requestConfig);
            requestInfo.addQueryParameters((Object)requestConfig.queryParameters);
            requestInfo.headers.putAll((Map)requestConfig.headers);
            requestInfo.addRequestOptions(requestConfig.options);
        }
        return requestInfo;
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull AclBinding body) throws URISyntaxException {
        return this.toPostRequestInformation(body, null);
    }

    @Nonnull
    public RequestInformation toPostRequestInformation(@Nonnull AclBinding body, @Nullable Consumer<PostRequestConfiguration> requestConfiguration) throws URISyntaxException {
        Objects.requireNonNull(body);
        RequestInformation requestInfo = new RequestInformation();
        requestInfo.httpMethod = HttpMethod.POST;
        requestInfo.urlTemplate = this.urlTemplate;
        requestInfo.pathParameters = this.pathParameters;
        requestInfo.setContentFromParsable(this.requestAdapter, "application/json", (Parsable)body);
        if (requestConfiguration != null) {
            PostRequestConfiguration requestConfig = new PostRequestConfiguration();
            requestConfiguration.accept(requestConfig);
            requestInfo.headers.putAll((Map)requestConfig.headers);
            requestInfo.addRequestOptions(requestConfig.options);
        }
        return requestInfo;
    }

    public class PostRequestConfiguration {
        @Nullable
        public RequestHeaders headers = new RequestHeaders();
        @Nullable
        public List<RequestOption> options = Collections.emptyList();

        @Nullable
        public PostRequestConfiguration() {
        }
    }

    public class GetRequestConfiguration {
        @Nullable
        public RequestHeaders headers = new RequestHeaders();
        @Nullable
        public List<RequestOption> options = Collections.emptyList();
        @Nullable
        public GetQueryParameters queryParameters = new GetQueryParameters();

        @Nullable
        public GetRequestConfiguration() {
        }
    }

    public class GetQueryParameters {
        @Nullable
        public String operation;
        @Nullable
        public String order;
        @Nullable
        public String orderKey;
        @Nullable
        public Integer page;
        @Nullable
        public String patternType;
        @Nullable
        public String permission;
        @Nullable
        public String principal;
        @Nullable
        public String resourceName;
        @Nullable
        public String resourceType;
        @Nullable
        public Integer size;
    }

    public class DeleteRequestConfiguration {
        @Nullable
        public RequestHeaders headers = new RequestHeaders();
        @Nullable
        public List<RequestOption> options = Collections.emptyList();
        @Nullable
        public DeleteQueryParameters queryParameters = new DeleteQueryParameters();

        @Nullable
        public DeleteRequestConfiguration() {
        }
    }

    public class DeleteQueryParameters {
        @Nullable
        public String operation;
        @Nullable
        public String patternType;
        @Nullable
        public String permission;
        @Nullable
        public String principal;
        @Nullable
        public String resourceName;
        @Nullable
        public String resourceType;
    }
}

