/*
 * Kafka Admin REST API
 * An API to provide REST endpoints for query Kafka for admin operations
 *
 * The version of the OpenAPI document: 0.3.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.openshift.cloud.api.kas.auth.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.openshift.cloud.api.kas.auth.models.TopicsToResetOffset;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * ConsumerGroupResetOffsetParameters
 */
@JsonPropertyOrder({
  ConsumerGroupResetOffsetParameters.JSON_PROPERTY_VALUE,
  ConsumerGroupResetOffsetParameters.JSON_PROPERTY_OFFSET,
  ConsumerGroupResetOffsetParameters.JSON_PROPERTY_TOPICS
})
@JsonTypeName("ConsumerGroupResetOffsetParameters")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ConsumerGroupResetOffsetParameters {
  public static final String JSON_PROPERTY_VALUE = "value";
  private String value;

  /**
   * Gets or Sets offset
   */
  public enum OffsetEnum {
    TIMESTAMP("timestamp"),
    
    ABSOLUTE("absolute"),
    
    LATEST("latest"),
    
    EARLIEST("earliest");

    private String value;

    OffsetEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static OffsetEnum fromValue(String value) {
      for (OffsetEnum b : OffsetEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_OFFSET = "offset";
  private OffsetEnum offset;

  public static final String JSON_PROPERTY_TOPICS = "topics";
  private List<TopicsToResetOffset> topics = null;

  public ConsumerGroupResetOffsetParameters() { 
  }

  public ConsumerGroupResetOffsetParameters value(String value) {
    
    this.value = value;
    return this;
  }

   /**
   * Get value
   * @return value
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getValue() {
    return value;
  }


  @JsonProperty(JSON_PROPERTY_VALUE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setValue(String value) {
    this.value = value;
  }


  public ConsumerGroupResetOffsetParameters offset(OffsetEnum offset) {
    
    this.offset = offset;
    return this;
  }

   /**
   * Get offset
   * @return offset
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "")
  @JsonProperty(JSON_PROPERTY_OFFSET)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public OffsetEnum getOffset() {
    return offset;
  }


  @JsonProperty(JSON_PROPERTY_OFFSET)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOffset(OffsetEnum offset) {
    this.offset = offset;
  }


  public ConsumerGroupResetOffsetParameters topics(List<TopicsToResetOffset> topics) {
    
    this.topics = topics;
    return this;
  }

  public ConsumerGroupResetOffsetParameters addTopicsItem(TopicsToResetOffset topicsItem) {
    if (this.topics == null) {
      this.topics = new ArrayList<>();
    }
    this.topics.add(topicsItem);
    return this;
  }

   /**
   * Get topics
   * @return topics
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_TOPICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TopicsToResetOffset> getTopics() {
    return topics;
  }


  @JsonProperty(JSON_PROPERTY_TOPICS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTopics(List<TopicsToResetOffset> topics) {
    this.topics = topics;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConsumerGroupResetOffsetParameters consumerGroupResetOffsetParameters = (ConsumerGroupResetOffsetParameters) o;
    return Objects.equals(this.value, consumerGroupResetOffsetParameters.value) &&
        Objects.equals(this.offset, consumerGroupResetOffsetParameters.offset) &&
        Objects.equals(this.topics, consumerGroupResetOffsetParameters.topics);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, offset, topics);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConsumerGroupResetOffsetParameters {\n");
    sb.append("    value: ").append(toIndentedString(value)).append("\n");
    sb.append("    offset: ").append(toIndentedString(offset)).append("\n");
    sb.append("    topics: ").append(toIndentedString(topics)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

