/*
 * Kafka Admin REST API
 * An API to provide REST endpoints for query Kafka for admin operations
 *
 * The version of the OpenAPI document: 0.3.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.openshift.cloud.api.kas.auth.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A Kafka consumer is responsible for reading records from one or more topics and one or more partitions of a topic.
 */
@ApiModel(description = "A Kafka consumer is responsible for reading records from one or more topics and one or more partitions of a topic.")
@JsonPropertyOrder({
  Consumer.JSON_PROPERTY_GROUP_ID,
  Consumer.JSON_PROPERTY_TOPIC,
  Consumer.JSON_PROPERTY_PARTITION,
  Consumer.JSON_PROPERTY_OFFSET,
  Consumer.JSON_PROPERTY_LOG_END_OFFSET,
  Consumer.JSON_PROPERTY_LAG,
  Consumer.JSON_PROPERTY_MEMBER_ID
})
@JsonTypeName("Consumer")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class Consumer {
  public static final String JSON_PROPERTY_GROUP_ID = "groupId";
  private String groupId;

  public static final String JSON_PROPERTY_TOPIC = "topic";
  private String topic;

  public static final String JSON_PROPERTY_PARTITION = "partition";
  private Integer partition;

  public static final String JSON_PROPERTY_OFFSET = "offset";
  private BigDecimal offset;

  public static final String JSON_PROPERTY_LOG_END_OFFSET = "logEndOffset";
  private BigDecimal logEndOffset;

  public static final String JSON_PROPERTY_LAG = "lag";
  private Integer lag;

  public static final String JSON_PROPERTY_MEMBER_ID = "memberId";
  private String memberId;

  public Consumer() { 
  }

  public Consumer groupId(String groupId) {
    
    this.groupId = groupId;
    return this;
  }

   /**
   * Unique identifier for the consumer group to which this consumer belongs.
   * @return groupId
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Unique identifier for the consumer group to which this consumer belongs.")
  @JsonProperty(JSON_PROPERTY_GROUP_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getGroupId() {
    return groupId;
  }


  @JsonProperty(JSON_PROPERTY_GROUP_ID)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setGroupId(String groupId) {
    this.groupId = groupId;
  }


  public Consumer topic(String topic) {
    
    this.topic = topic;
    return this;
  }

   /**
   * The unique topic name to which this consumer belongs
   * @return topic
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "The unique topic name to which this consumer belongs")
  @JsonProperty(JSON_PROPERTY_TOPIC)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public String getTopic() {
    return topic;
  }


  @JsonProperty(JSON_PROPERTY_TOPIC)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setTopic(String topic) {
    this.topic = topic;
  }


  public Consumer partition(Integer partition) {
    
    this.partition = partition;
    return this;
  }

   /**
   * The partition number to which this consumer group is assigned to.
   * @return partition
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "The partition number to which this consumer group is assigned to.")
  @JsonProperty(JSON_PROPERTY_PARTITION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getPartition() {
    return partition;
  }


  @JsonProperty(JSON_PROPERTY_PARTITION)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setPartition(Integer partition) {
    this.partition = partition;
  }


  public Consumer offset(BigDecimal offset) {
    
    this.offset = offset;
    return this;
  }

   /**
   * Offset denotes the position of the consumer in a partition.
   * @return offset
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Offset denotes the position of the consumer in a partition.")
  @JsonProperty(JSON_PROPERTY_OFFSET)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public BigDecimal getOffset() {
    return offset;
  }


  @JsonProperty(JSON_PROPERTY_OFFSET)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setOffset(BigDecimal offset) {
    this.offset = offset;
  }


  public Consumer logEndOffset(BigDecimal logEndOffset) {
    
    this.logEndOffset = logEndOffset;
    return this;
  }

   /**
   * The log end offset is the offset of the last message written to a log.
   * @return logEndOffset
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The log end offset is the offset of the last message written to a log.")
  @JsonProperty(JSON_PROPERTY_LOG_END_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getLogEndOffset() {
    return logEndOffset;
  }


  @JsonProperty(JSON_PROPERTY_LOG_END_OFFSET)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setLogEndOffset(BigDecimal logEndOffset) {
    this.logEndOffset = logEndOffset;
  }


  public Consumer lag(Integer lag) {
    
    this.lag = lag;
    return this;
  }

   /**
   * Offset Lag is the delta between the last produced message and the last consumer&#39;s committed offset.
   * @return lag
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "Offset Lag is the delta between the last produced message and the last consumer's committed offset.")
  @JsonProperty(JSON_PROPERTY_LAG)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)

  public Integer getLag() {
    return lag;
  }


  @JsonProperty(JSON_PROPERTY_LAG)
  @JsonInclude(value = JsonInclude.Include.ALWAYS)
  public void setLag(Integer lag) {
    this.lag = lag;
  }


  public Consumer memberId(String memberId) {
    
    this.memberId = memberId;
    return this;
  }

   /**
   * The member ID is a unique identifier given to a consumer by the coordinator upon initially joining the group.
   * @return memberId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The member ID is a unique identifier given to a consumer by the coordinator upon initially joining the group.")
  @JsonProperty(JSON_PROPERTY_MEMBER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getMemberId() {
    return memberId;
  }


  @JsonProperty(JSON_PROPERTY_MEMBER_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setMemberId(String memberId) {
    this.memberId = memberId;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Consumer consumer = (Consumer) o;
    return Objects.equals(this.groupId, consumer.groupId) &&
        Objects.equals(this.topic, consumer.topic) &&
        Objects.equals(this.partition, consumer.partition) &&
        Objects.equals(this.offset, consumer.offset) &&
        Objects.equals(this.logEndOffset, consumer.logEndOffset) &&
        Objects.equals(this.lag, consumer.lag) &&
        Objects.equals(this.memberId, consumer.memberId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(groupId, topic, partition, offset, logEndOffset, lag, memberId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Consumer {\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    topic: ").append(toIndentedString(topic)).append("\n");
    sb.append("    partition: ").append(toIndentedString(partition)).append("\n");
    sb.append("    offset: ").append(toIndentedString(offset)).append("\n");
    sb.append("    logEndOffset: ").append(toIndentedString(logEndOffset)).append("\n");
    sb.append("    lag: ").append(toIndentedString(lag)).append("\n");
    sb.append("    memberId: ").append(toIndentedString(memberId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

