/*
 * Kafka Admin REST API
 * An API to provide REST endpoints for query Kafka for admin operations
 *
 * The version of the OpenAPI document: 0.3.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.openshift.cloud.api.kas.auth.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.openshift.cloud.api.kas.auth.models.ConfigEntry;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * Kafka Topic (A feed where records are stored and published)
 */
@ApiModel(description = "Kafka Topic (A feed where records are stored and published)")
@JsonPropertyOrder({
  UpdateTopicInput.JSON_PROPERTY_CONFIG,
  UpdateTopicInput.JSON_PROPERTY_NUM_PARTITIONS
})
@JsonTypeName("UpdateTopicInput")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class UpdateTopicInput {
  public static final String JSON_PROPERTY_CONFIG = "config";
  private List<ConfigEntry> config = null;

  public static final String JSON_PROPERTY_NUM_PARTITIONS = "numPartitions";
  private Integer numPartitions;


  public UpdateTopicInput config(List<ConfigEntry> config) {
    
    this.config = config;
    return this;
  }

  public UpdateTopicInput addConfigItem(ConfigEntry configItem) {
    if (this.config == null) {
      this.config = new ArrayList<>();
    }
    this.config.add(configItem);
    return this;
  }

   /**
   * Topic configuration entries.
   * @return config
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Topic configuration entries.")
  @JsonProperty(JSON_PROPERTY_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ConfigEntry> getConfig() {
    return config;
  }


  @JsonProperty(JSON_PROPERTY_CONFIG)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setConfig(List<ConfigEntry> config) {
    this.config = config;
  }


  public UpdateTopicInput numPartitions(Integer numPartitions) {
    
    this.numPartitions = numPartitions;
    return this;
  }

   /**
   * Number of partitions (only increasing supported)
   * @return numPartitions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Number of partitions (only increasing supported)")
  @JsonProperty(JSON_PROPERTY_NUM_PARTITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getNumPartitions() {
    return numPartitions;
  }


  @JsonProperty(JSON_PROPERTY_NUM_PARTITIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setNumPartitions(Integer numPartitions) {
    this.numPartitions = numPartitions;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateTopicInput updateTopicInput = (UpdateTopicInput) o;
    return Objects.equals(this.config, updateTopicInput.config) &&
        Objects.equals(this.numPartitions, updateTopicInput.numPartitions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(config, numPartitions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateTopicInput {\n");
    sb.append("    config: ").append(toIndentedString(config)).append("\n");
    sb.append("    numPartitions: ").append(toIndentedString(numPartitions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

