/*
 * Kafka Admin REST API
 * An API to provide REST endpoints for query Kafka for admin operations
 *
 * The version of the OpenAPI document: 0.3.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.openshift.cloud.api.kas.auth.models;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.openshift.cloud.api.kas.auth.models.ConsumerGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

/**
 * A list of consumer groups
 */
@ApiModel(description = "A list of consumer groups")
@JsonPropertyOrder({
  ConsumerGroupList.JSON_PROPERTY_ITEMS,
  ConsumerGroupList.JSON_PROPERTY_TOTAL,
  ConsumerGroupList.JSON_PROPERTY_SIZE,
  ConsumerGroupList.JSON_PROPERTY_PAGE
})
@JsonTypeName("ConsumerGroupList")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ConsumerGroupList {
  public static final String JSON_PROPERTY_ITEMS = "items";
  private List<ConsumerGroup> items = null;

  public static final String JSON_PROPERTY_TOTAL = "total";
  private BigDecimal total;

  public static final String JSON_PROPERTY_SIZE = "size";
  private BigDecimal size;

  public static final String JSON_PROPERTY_PAGE = "page";
  private Integer page;


  public ConsumerGroupList items(List<ConsumerGroup> items) {
    
    this.items = items;
    return this;
  }

  public ConsumerGroupList addItemsItem(ConsumerGroup itemsItem) {
    if (this.items == null) {
      this.items = new ArrayList<>();
    }
    this.items.add(itemsItem);
    return this;
  }

   /**
   * Consumer group list items
   * @return items
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Consumer group list items")
  @JsonProperty(JSON_PROPERTY_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<ConsumerGroup> getItems() {
    return items;
  }


  @JsonProperty(JSON_PROPERTY_ITEMS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setItems(List<ConsumerGroup> items) {
    this.items = items;
  }


  public ConsumerGroupList total(BigDecimal total) {
    
    this.total = total;
    return this;
  }

   /**
   * The total number of consumer groups.
   * @return total
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The total number of consumer groups.")
  @JsonProperty(JSON_PROPERTY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getTotal() {
    return total;
  }


  @JsonProperty(JSON_PROPERTY_TOTAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTotal(BigDecimal total) {
    this.total = total;
  }


  public ConsumerGroupList size(BigDecimal size) {
    
    this.size = size;
    return this;
  }

   /**
   * The number of consumer groups per page.
   * @return size
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The number of consumer groups per page.")
  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public BigDecimal getSize() {
    return size;
  }


  @JsonProperty(JSON_PROPERTY_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSize(BigDecimal size) {
    this.size = size;
  }


  public ConsumerGroupList page(Integer page) {
    
    this.page = page;
    return this;
  }

   /**
   * The page
   * @return page
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The page")
  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPage() {
    return page;
  }


  @JsonProperty(JSON_PROPERTY_PAGE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPage(Integer page) {
    this.page = page;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ConsumerGroupList consumerGroupList = (ConsumerGroupList) o;
    return Objects.equals(this.items, consumerGroupList.items) &&
        Objects.equals(this.total, consumerGroupList.total) &&
        Objects.equals(this.size, consumerGroupList.size) &&
        Objects.equals(this.page, consumerGroupList.page);
  }

  @Override
  public int hashCode() {
    return Objects.hash(items, total, size, page);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ConsumerGroupList {\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    size: ").append(toIndentedString(size)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

