/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.spatial;

import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.spatial.GeometryExpression;
import com.querydsl.spatial.GeometryOperation;
import com.querydsl.spatial.LineStringExpression;
import com.querydsl.spatial.LineStringOperation;
import com.querydsl.spatial.PointExpression;
import com.querydsl.spatial.PointOperation;
import com.querydsl.spatial.PolygonExpression;
import com.querydsl.spatial.PolygonOperation;
import com.querydsl.spatial.SpatialOps;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.LineString;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;

public final class GeometryExpressions {
    public static StringExpression asEWKT(GeometryExpression<?> expr) {
        return Expressions.stringOperation((Operator)SpatialOps.AS_EWKT, (Expression[])new Expression[]{expr});
    }

    public static GeometryExpression<?> fromText(String text) {
        return GeometryExpressions.geometryOperation(SpatialOps.GEOM_FROM_TEXT, new Expression[]{ConstantImpl.create((Object)text)});
    }

    public static GeometryExpression<?> fromText(Expression<String> text) {
        return GeometryExpressions.geometryOperation(SpatialOps.GEOM_FROM_TEXT, text);
    }

    public static <T extends Geometry> GeometryExpression<T> setSRID(Expression<T> expr, int srid) {
        return GeometryExpressions.geometryOperation(expr.getType(), SpatialOps.SET_SRID, new Expression[]{expr, ConstantImpl.create((int)srid)});
    }

    public static NumberExpression<Double> xmin(GeometryExpression<?> expr) {
        return Expressions.numberOperation(Double.class, (Operator)SpatialOps.XMIN, (Expression[])new Expression[]{expr});
    }

    public static NumberExpression<Double> xmax(GeometryExpression<?> expr) {
        return Expressions.numberOperation(Double.class, (Operator)SpatialOps.XMAX, (Expression[])new Expression[]{expr});
    }

    public static NumberExpression<Double> ymin(GeometryExpression<?> expr) {
        return Expressions.numberOperation(Double.class, (Operator)SpatialOps.YMIN, (Expression[])new Expression[]{expr});
    }

    public static NumberExpression<Double> ymax(GeometryExpression<?> expr) {
        return Expressions.numberOperation(Double.class, (Operator)SpatialOps.YMAX, (Expression[])new Expression[]{expr});
    }

    public static BooleanExpression dwithin(Expression<? extends Geometry> expr1, Expression<? extends Geometry> expr2, Expression<Double> distance) {
        return Expressions.booleanOperation((Operator)SpatialOps.DWITHIN, (Expression[])new Expression[]{expr1, expr2, distance});
    }

    public static BooleanExpression dwithin(Expression<? extends Geometry> expr1, Expression<? extends Geometry> expr2, double distance) {
        return Expressions.booleanOperation((Operator)SpatialOps.DWITHIN, (Expression[])new Expression[]{expr1, expr2, ConstantImpl.create((Object)distance)});
    }

    public static GeometryExpression<?> extent(Expression<? extends GeometryCollection> collection) {
        return GeometryExpressions.geometryOperation(SpatialOps.EXTENT, collection);
    }

    public static GeometryExpression<?> collect(Expression<? extends GeometryCollection> collection) {
        return GeometryExpressions.geometryOperation(SpatialOps.COLLECT, collection);
    }

    public static GeometryExpression<?> collect(Expression<? extends Geometry> expr1, Expression<? extends Geometry> expr2) {
        return GeometryExpressions.geometryOperation(SpatialOps.COLLECT2, expr1, expr2);
    }

    public static <T extends Geometry> GeometryExpression<T> translate(Expression<T> expr, float deltax, float deltay) {
        return GeometryExpressions.geometryOperation(expr.getType(), SpatialOps.TRANSLATE, new Expression[]{expr, ConstantImpl.create((Object)Float.valueOf(deltax)), ConstantImpl.create((Object)Float.valueOf(deltay))});
    }

    public static <T extends Geometry> GeometryExpression<T> translate(Expression<T> expr, float deltax, float deltay, float deltaz) {
        return GeometryExpressions.geometryOperation(expr.getType(), SpatialOps.TRANSLATE2, new Expression[]{expr, ConstantImpl.create((Object)Float.valueOf(deltax)), ConstantImpl.create((Object)Float.valueOf(deltay)), ConstantImpl.create((Object)Float.valueOf(deltaz))});
    }

    public static GeometryExpression<Geometry> geometryOperation(Operator op, Expression<?> ... args) {
        return new GeometryOperation<Geometry>(Geometry.class, op, args);
    }

    public static <T extends Geometry> GeometryExpression<T> geometryOperation(Class<? extends T> type, Operator op, Expression<?> ... args) {
        return new GeometryOperation<T>(type, op, args);
    }

    public static LineStringExpression<LineString> lineStringOperation(Operator op, Expression<?> ... args) {
        return new LineStringOperation<LineString>(LineString.class, op, args);
    }

    public static PointExpression<Point> pointOperation(Operator op, Expression<?> ... args) {
        return new PointOperation<Point>(Point.class, op, args);
    }

    public static PolygonExpression<Polygon> polygonOperation(Operator op, Expression<?> ... args) {
        return new PolygonOperation<Polygon>(Polygon.class, op, args);
    }

    private GeometryExpressions() {
    }
}

